/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.elements.TwigStatement;
import com.jetbrains.twig.formatter.TwigBlock;
import com.jetbrains.twig.formatter.TwigBlockWithInjection;
import java.util.List;

public class TwigFormattingModelBuilder
extends AbstractXmlTemplateFormattingModelBuilder {
    protected boolean isTemplateFile(PsiFile file) {
        return file instanceof TwigFile;
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        return element.getNode().getElementType() == TwigTokenTypes.OUTER_ELEMENT_TYPE;
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        IElementType theType = element.getNode().getElementType();
        return theType == TwigTokenTypes.TEMPLATE_HTML_TEXT || theType == TwigElementTypes.TEMPLATE_DATA;
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, Alignment alignment, Wrap wrap) {
        PsiElement nodePsi = node.getPsi();
        if (nodePsi instanceof TwigStatement && TwigFormattingModelBuilder.hasInjection(nodePsi)) {
            return new TwigBlockWithInjection(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        }
        return new TwigBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
    }

    public static boolean hasInjection(PsiElement host) {
        List psiFiles = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles(host);
        return psiFiles != null && psiFiles.size() > 0;
    }
}

