/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.TwigLexer;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigCompositeElementType;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.parser.TwigParser;
import org.jetbrains.annotations.NotNull;

public class TwigParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE = TokenSet.create((IElementType[])new IElementType[]{TwigTokenTypes.WHITE_SPACE});
    private static final TokenSet COMMENT = TokenSet.create((IElementType[])new IElementType[]{TwigTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        TwigLexer twigLexer = new TwigLexer();
        if (twigLexer == null) {
            TwigParserDefinition.$$$reportNull$$$0(0);
        }
        return twigLexer;
    }

    public PsiParser createParser(Project project) {
        return new TwigParser();
    }

    public IFileElementType getFileNodeType() {
        return TwigElementTypes.TWIG_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACE;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TwigTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            TwigParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof TwigCompositeElementType) {
            PsiElement psiElement = ((TwigCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                TwigParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new TwigFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public String toString() {
        return "TwigParserDefinition";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/twig/parser/TwigParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

