/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.wiztools.restclient.ui.AbstractScriptEditor;
import org.wiztools.restclient.ui.TextEditorSyntax;

public class RSyntaxScriptEditor
extends AbstractScriptEditor {
    private final RSyntaxTextArea textArea = new RSyntaxTextArea();

    public RSyntaxScriptEditor() {
        this.textArea.setPopupMenu(null);
        this.textArea.setAntiAliasingEnabled(true);
    }

    public RSyntaxScriptEditor(TextEditorSyntax syntax) {
        this();
        this.setSyntax(syntax);
    }

    @Override
    public final void setSyntax(TextEditorSyntax syntax) {
        switch (syntax) {
            case GROOVY: {
                this.textArea.setSyntaxEditingStyle("text/groovy");
                break;
            }
            case XML: {
                this.textArea.setSyntaxEditingStyle("text/xml");
                break;
            }
            case JSON: 
            case JS: {
                this.textArea.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case HTML: {
                this.textArea.setSyntaxEditingStyle("text/html");
                break;
            }
            case CSS: {
                this.textArea.setSyntaxEditingStyle("text/css");
                break;
            }
            default: {
                this.textArea.setSyntaxEditingStyle("text/plain");
            }
        }
    }

    @Override
    public JComponent getEditorView() {
        return this.textArea;
    }

    @Override
    public JTextComponent getEditorComponent() {
        return this.textArea;
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public void setViewText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public String getViewText() {
        return this.textArea.getText();
    }

    @Override
    public void setCaretPosition(int offset) {
        this.textArea.setCaretPosition(offset);
    }

    @Override
    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textArea.setEnabled(enabled);
    }

    @Override
    public void setPopupMenu(JPopupMenu menu) {
        this.textArea.setPopupMenu(menu);
    }
}

