/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class FilterLexer
extends DelegateLexer {
    private final Filter myFilter;
    private final boolean[] myStateFilter;
    private int myPrevTokenEnd;

    public FilterLexer(Lexer original, Filter filter, boolean[] stateFilter) {
        super(original);
        this.myFilter = filter;
        this.myStateFilter = stateFilter;
    }

    public FilterLexer(Lexer original, Filter filter) {
        this(original, filter, null);
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            FilterLexer.$$$reportNull$$$0(0);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myPrevTokenEnd = -1;
        this.locateToken();
    }

    @Override
    public void advance() {
        this.myPrevTokenEnd = this.getDelegate().getTokenEnd();
        super.advance();
        this.locateToken();
    }

    public int getPrevTokenEnd() {
        return this.myPrevTokenEnd;
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = this.getDelegate().getCurrentPosition();
        if (lexerPosition == null) {
            FilterLexer.$$$reportNull$$$0(1);
        }
        return lexerPosition;
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            FilterLexer.$$$reportNull$$$0(2);
        }
        this.getDelegate().restore(position);
        this.myPrevTokenEnd = -1;
    }

    public final void locateToken() {
        Lexer delegate;
        IElementType tokenType;
        while ((tokenType = (delegate = this.getDelegate()).getTokenType()) != null && (this.myFilter != null && this.myFilter.reject(tokenType) || this.myStateFilter != null && this.myStateFilter[delegate.getState()])) {
            delegate.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/FilterLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/FilterLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class SetFilter
    implements Filter {
        private final TokenSet mySet;

        public SetFilter(TokenSet set) {
            this.mySet = set;
        }

        @Override
        public boolean reject(IElementType type) {
            return this.mySet.contains(type);
        }
    }

    public static interface Filter {
        public boolean reject(IElementType var1);
    }
}

