/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Override
    protected JSType doGetDeclarationTypeStubSafe() {
        return TypeScriptPsiUtil.getTypeFromDeclaration(this);
    }

    @Override
    @Nullable
    protected final JSType doGetType() {
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            PsiElement parent = this.getParent();
            if (JSDestructuringUtil.isDestructuring(parent)) {
                return new JSDestructuringTypeImpl((Segment)this.getTextRange(), JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
            JSExpression initializer = this.getInitializer();
            if (initializer != null) {
                if (initializer instanceof JSLiteralExpression) {
                    JSType typeFromConstant = JSTypeEvaluator.getTypeFromConstant(initializer);
                    if (this.isConst() && typeFromConstant != null) {
                        return typeFromConstant;
                    }
                    JSType possibleType = JSTypeUtils.getApparentType(typeFromConstant);
                    if (possibleType != null) {
                        return possibleType;
                    }
                }
                return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    @Nullable
    protected String doGetName() {
        boolean computed;
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        if (name != null) {
            return name;
        }
        ASTNode nameNode = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
        boolean bl = computed = nameNode != null;
        if (nameNode == null) {
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
        }
        return TypeScriptVariableImpl.getResultNameFromNameNode(nameNode, computed);
    }

    @Override
    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return super.useLocalSearchScope(declarationScope) && !(declarationScope instanceof TypeScriptModule);
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(0);
        }
        return accessType;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember((PsiElement)this) || super.isNamespaceExplicitlyDeclared();
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return JSTypeUtils.serializeType(type);
    }

    @Override
    protected boolean useTypesFromJSDoc() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "calcAccessType"));
    }
}

