/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ObjectKind
implements Comparable<ObjectKind> {
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(0);
    public static final Map<String, ObjectKind> ourKinds = ContainerUtil.newConcurrentMap();
    public static final ObjectKind NONE = new ObjectKind("NONE");
    public static final ObjectKind ROOT = new ObjectKind("ROOT");
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE");
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA");
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE");
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER");
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE");
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE");
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE");
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE");
    public static final ObjectKind TABLE = new ObjectKind("TABLE");
    public static final ObjectKind MAT_LOG = new ObjectKind("MATERIALIZED LOG");
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW");
    public static final ObjectKind VIEW = new ObjectKind("VIEW");
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE");
    public static final ObjectKind BODY = new ObjectKind("BODY");
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE");
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR");
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE");
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN");
    public static final ObjectKind INDEX = new ObjectKind("INDEX");
    public static final ObjectKind KEY = new ObjectKind("KEY");
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY");
    public static final ObjectKind CHECK = new ObjectKind("CHECK");
    public static final ObjectKind DEFAULT = new ObjectKind("DEFAULT");
    public static final ObjectKind RULE = new ObjectKind("RULE");
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER");
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT");
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE");
    public static final ObjectKind COMMENT = new ObjectKind("COMMENT");
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM");
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK");
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE");
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION");
    public static final ObjectKind SCRIPT = new ObjectKind("SCRIPT");
    public static final ObjectKind TABLESPACE = new ObjectKind("TABLESPACE");
    public static final ObjectKind DATA_FILE = new ObjectKind("DATA FILE");
    public static final ObjectKind ROLE = new ObjectKind("ROLE");
    public static final ObjectKind USER = new ObjectKind("USER");
    public static final ObjectKind CONNECTION = new ObjectKind("CONNECTION");
    public static final ObjectKind FOREIGN_DATA_WRAPPER = new ObjectKind("FOREIGN DATA WRAPPER");
    public static final ObjectKind SERVER = new ObjectKind("SERVER");
    public static final ObjectKind USER_MAPPING = new ObjectKind("USER MAPPING");
    public static final ObjectKind FOREIGN_TABLE = new ObjectKind("FOREIGN TABLE");
    public static final ObjectKind EXTERNAL_SCHEMA = new ObjectKind("EXTERNAL SCHEMA");
    public static final ObjectKind SCHEDULED_EVENT = new ObjectKind("SCHEDULED EVENT");
    public static final ObjectKind ACCESS_METHOD = new ObjectKind("ACCESS METHOD");
    public static final ObjectKind AGGREGATE = new ObjectKind("AGGREGATE");
    public static final ObjectKind EXCEPTION = new ObjectKind("EXCEPTION");
    public static final ObjectKind EXTENSION = new ObjectKind("EXTENSION");
    public static final ObjectKind PROJECTION = new ObjectKind("PROJECTION");
    public static final ObjectKind MACRO = new ObjectKind("MACRO");
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", Integer.MAX_VALUE);
    private static final int ourLastDatabaseKind = ourOrderNumCounter.get();
    private final String myName;
    private final int myOrderNum;
    private final String myCode;

    public ObjectKind(@NotNull String name) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(0);
        }
        this(name, ourOrderNumCounter.getAndIncrement());
    }

    private ObjectKind(@NotNull String name, int orderNum) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(1);
        }
        assert (name.length() > 0);
        assert (orderNum >= 0);
        this.myName = name;
        this.myCode = this.myName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
        this.myOrderNum = orderNum;
        ourKinds.putIfAbsent(this.myCode, this);
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myCode;
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            ObjectKind.$$$reportNull$$$0(2);
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Uncomparable object kinds: %s and %s", this.code(), that.code()));
    }

    @NotNull
    public static Iterable<ObjectKind> getDatabaseKinds() {
        JBIterable jBIterable = JBIterable.from(ourKinds.values()).filter(k -> k.myOrderNum < ourLastDatabaseKind);
        if (jBIterable == null) {
            ObjectKind.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

