/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.sass.extensions.CompassImportPathRegistrationWatcherRM;
import org.jetbrains.plugins.sass.extensions.GemUtil;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.sass.extensions.compass.CompassImportPathRegistrationWatcher;
import org.jetbrains.plugins.sass.extensions.compass.CompassSassExtension;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;

public class RubyCompassExtension
extends CompassSassExtension {
    protected boolean isAvailableInModule(@NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(0);
        }
        if (!module.isDisposed() && SassRubyIntegrationHelper.getInstance().hasRubyPlugin()) {
            CompassSettings compassSettings = CompassSettings.getInstance((Module)module);
            return compassSettings != null && compassSettings.isCompassSupportEnabled();
        }
        return false;
    }

    public void startActivity(final @NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(1);
        }
        if (!module.isDisposed()) {
            MessageBusConnection connection = module.getProject().getMessageBus().connect((Disposable)module);
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RubyCompassExtension.this.enableWatcherIfNeeded(module);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/sass/extensions/RubyCompassExtension$1", "rootsChanged"));
                }
            });
            this.enableWatcherIfNeeded(module);
        }
    }

    public void stopActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherRM watcher;
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(2);
        }
        if ((watcher = CompassImportPathRegistrationWatcherRM.getInstance(module)) != null) {
            Disposer.dispose((Disposable)watcher);
        }
        this.stopDefaultActivity(module);
    }

    private void enableWatcherIfNeeded(@NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(3);
        }
        if (!module.isDisposed()) {
            if (SassRubyIntegrationHelper.getInstance().isRubyModule(module)) {
                this.stopDefaultActivity(module);
                if (GemSearchUtil.findGemEx((Module)module, (String)this.getName()) != null) {
                    this.startRubyActivity(module);
                } else {
                    RubyCompassExtension.stopRubyActivity(module);
                    if (CompassSettings.getInstance((Module)module).isCompassSupportEnabled()) {
                        CompassSettings.getInstance((Module)module).resetEnabledFlag();
                    }
                }
            } else {
                RubyCompassExtension.stopRubyActivity(module);
                this.startDefaultActivity(module);
            }
        }
    }

    private void startRubyActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherRM watcher;
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(4);
        }
        if ((watcher = CompassImportPathRegistrationWatcherRM.getInstance(module)) != null) {
            this.fillCompassSettings(module);
            CompassSettings settings = CompassSettings.getInstance((Module)module);
            if (settings != null && settings.isCompassSupportEnabled()) {
                watcher.subscribe((CompassImportPathRegistrationWatcher.ImportPathsListener)this, !settings.getCompassConfigPath().isEmpty());
            }
        }
    }

    private void startDefaultActivity(@NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(5);
        }
        super.startActivity(module);
    }

    private static void stopRubyActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherRM watcher;
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(6);
        }
        if ((watcher = CompassImportPathRegistrationWatcherRM.getInstance(module)) != null && watcher.isStarted()) {
            Disposer.dispose((Disposable)watcher);
        }
    }

    private void stopDefaultActivity(@NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(7);
        }
        super.stopActivity(module);
    }

    private void fillCompassSettings(@NotNull Module module) {
        VirtualFile compassFile;
        VirtualFile gemFile;
        GemInfo gem;
        CompassSettings settings;
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(8);
        }
        if ((settings = CompassSettings.getInstance((Module)module)) != null && (gem = GemSearchUtil.findGemEx((Module)module, (String)this.getName())) != null && (gemFile = gem.getFile()) != null && (compassFile = gemFile.findFileByRelativePath("bin/compass")) != null && GemUtil.isValidExecutableFile((VirtualFile)compassFile)) {
            settings.setCompassExecutableFilePath(compassFile.getPath());
        }
    }

    @NotNull
    public Collection<? extends VirtualFile> getStylesheetsRoots(@NotNull Module module) {
        if (module == null) {
            RubyCompassExtension.$$$reportNull$$$0(9);
        }
        HashSet result = ContainerUtil.newHashSet((Iterable)super.getStylesheetsRoots(module));
        for (GemInfo gemInfo : GemManager.getAllGems((Module)module)) {
            VirtualFile sassDirectory;
            VirtualFile gemDirectory = gemInfo.getFile();
            if (gemDirectory == null) continue;
            VirtualFile stylesheetsDirectory = gemDirectory.findChild("stylesheets");
            if (stylesheetsDirectory != null) {
                result.add(stylesheetsDirectory);
            }
            if ((sassDirectory = gemDirectory.findChild("sass")) == null) continue;
            result.add(sassDirectory);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            RubyCompassExtension.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/RubyCompassExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/RubyCompassExtension";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesheetsRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableInModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopActivity";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enableWatcherIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startRubyActivity";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startDefaultActivity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopRubyActivity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stopDefaultActivity";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillCompassSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStylesheetsRoots";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

