/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.epp.lexer;

import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.epp.lexer.EppLexerBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;

class _EppLexer
extends EppLexerBase {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int LEX_PUPPET = 2;
    public static final int LEX_PARAM = 4;
    public static final int LEX_COMMENT = 6;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    static final char[] ZZ_CMAP_Z = _EppLexer.zzUnpackCMap("\u0001\u0000\u0087@");
    static final char[] ZZ_CMAP_Y = _EppLexer.zzUnpackCMap("\u0001\u0000\u007f\u0080");
    static final char[] ZZ_CMAP_A = _EppLexer.zzUnpackCMap(" \u0000\u0001\u0006\u0002\u0000\u0001\b\u0001\u0000\u0001\u0002\u0007\u0000\u0001\u0004\u000e\u0000\u0001\u0001\u0001\u0003\u0001\u0005=\u0000\u0001\u0007\u0083\u0000");
    private static final int[] ZZ_ACTION = _EppLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0004\u0001\u0004\u0002\u0003\u0003\u0001\u0004\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0007\u0001\u0000\u0001\b\u0002\u0004\u0001\u0000\u0001\t\u0001\n\u0002\u0000\u0001\u000b\u0001\f";
    private static final int[] ZZ_ROWMAP = _EppLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\t\u0000\u0012\u0000\u001b\u0000$\u0000-\u00006\u0000?\u0000H\u0000Q\u0000Z\u0000c\u0000l\u0000u\u0000~\u0000\u0087\u0000\u0090\u0000H\u0000\u0099\u0000H\u0000Q\u0000\u00a2\u0000H\u0000u\u0000H\u0000H\u0000\u00ab\u0000\u00b4\u0000H\u0000H\u0000\u00bd\u0000\u00c6\u0000H\u0000H";
    private static final int[] ZZ_TRANS = _EppLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0005\u0001\b\u0004\u0005\u0002\t\u0001\n\u0001\t\u0001\u000b\u000b\t\u0001\f\u0001\t\u0002\r\u0001\u000e\u0001\r\u0001\u000f\u0004\r\u0001\u0005\u0002\u0000\u0006\u0005\u0002\u0000\u0001\u0010\b\u0000\u0001\u0011\u0002\u0000\u0001\u0012\u0003\u0000\u0001\u0005\u0001\u0000\u0001\u0013\u0006\u0005\u000e\u0000\u0001\u0014\u0005\u0000\u0001\u0015\f\u0000\u0001\u0016\u0002\u0000\u0002\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0005\u0000\u0001\u0017\u0005\u0000\u0001\u0018\b\u0000\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u0000\u0001\u001c\u0001\u0000\u0001\u001d\u0005\u0000\u0001\u001e\b\u0000\u0001\u0012\u0005\u0000\u0001\u001f\u0001\u0000\u0001 \n\u0000\u0001\u001c\t\u0000\u0001!\u0006\u0000\u0001\"\u0005\u0000\u0001\u001f\u0006\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _EppLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0004\u0000\u0004\u0001\u0001\t\u0007\u0001\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0002\t\u0001\u0001\u0001\u0000\u0002\t\u0002\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 13] | ch >> 7 & 0x3F] | ch & 0x7F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[34];
        int offset = 0;
        offset = _EppLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[34];
        int offset = 0;
        offset = _EppLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[207];
        int offset = 0;
        offset = _EppLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[34];
        int offset = 0;
        offset = _EppLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _EppLexer(Project project) {
        super(project);
        this.zzReader = null;
    }

    @Override
    public void setTokenEnd(int position) {
        this.zzMarkedPos = position;
    }

    _EppLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    @Override
    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    @Override
    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block30: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _EppLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 6: {
                        this.yybegin(0);
                        return PuppetTokenTypes.COMMENT;
                    }
                    case 35: {
                        continue block30;
                    }
                }
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return EPP_TEMPLATE_BLOCK;
                }
                case 13: {
                    continue block30;
                }
                case 2: {
                    return this.delegateLexing();
                }
                case 14: {
                    continue block30;
                }
                case 3: {
                    continue block30;
                }
                case 15: {
                    continue block30;
                }
                case 4: {
                    this.yybegin(2);
                    return EPP_EXPRESSION_OPENER;
                }
                case 16: {
                    continue block30;
                }
                case 5: {
                    return EPP_EXPRESSION_CLOSER;
                }
                case 17: {
                    continue block30;
                }
                case 6: {
                    this.yybegin(0);
                    return EPP_EXPRESSION_CLOSER;
                }
                case 18: {
                    continue block30;
                }
                case 7: {
                    this.yybegin(0);
                    return PuppetTokenTypes.COMMENT;
                }
                case 19: {
                    continue block30;
                }
                case 8: {
                    return EPP_LITERAL_OPENER;
                }
                case 20: {
                    continue block30;
                }
                case 9: {
                    this.yybegin(6);
                }
                case 21: {
                    continue block30;
                }
                case 10: {
                    return EPP_LITERAL_CLOSER;
                }
                case 22: {
                    continue block30;
                }
                case 11: {
                    this.yybegin(4);
                    return EPP_PARAMETER_OPENER;
                }
                case 23: {
                    continue block30;
                }
                case 12: {
                    this.yybegin(0);
                    return EPP_PARAMETER_CLOSER;
                }
                case 24: {
                    continue block30;
                }
            }
            this.zzScanError(1);
        }
    }
}

