/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;

public abstract class GraphicsDevice {
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;
    private Window full_screen;
    private Rectangle fullScreenOldBounds;
    private DisplayMode mode;

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate template) {
        return template.getBestConfiguration(this.getConfigurations());
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public synchronized void setFullScreenWindow(Window w) {
        if (this.full_screen != null) {
            this.full_screen.setBounds(this.fullScreenOldBounds);
        }
        this.full_screen = null;
        if (w != null) {
            this.fullScreenOldBounds = w.getBounds();
            this.full_screen = w;
            DisplayMode dMode = this.getDisplayMode();
            this.full_screen.setBounds(0, 0, dMode.getWidth(), dMode.getHeight());
            this.full_screen.requestFocus();
            this.full_screen.setLocationRelativeTo(null);
        }
    }

    public Window getFullScreenWindow() {
        return this.full_screen;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode mode) {
        DisplayMode[] array = this.getDisplayModes();
        if (!this.isDisplayChangeSupported()) {
            throw new UnsupportedOperationException();
        }
        int n = 0;
        if (array != null) {
            n = array.length;
        }
        int i = n;
        while (--i >= 0) {
            if (array[i].equals(mode)) break;
        }
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public DisplayMode getDisplayMode() {
        return this.mode;
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[0];
    }

    public int getAvailableAcceleratedMemory() {
        return 0;
    }

    protected GraphicsDevice() {
    }
}

