/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends FilterOutputStream {
    private static final int FIRST_TIME = 0;
    private static final int SECOND_TIME = 1;
    private static final int SEASONED = 2;
    private Cipher cipher;
    private byte[][] inBuffer;
    private int inLength;
    private byte[] outBuffer;
    private int state;
    private boolean isStream;

    public void close() throws IOException {
        try {
            int len;
            if (this.state != 0) {
                len = this.cipher.update(this.inBuffer[0], 0, this.inBuffer[0].length, this.outBuffer);
                this.out.write(this.outBuffer, 0, len);
            }
            len = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer);
            this.out.write(this.outBuffer, 0, len);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new IOException(ibse.toString());
        }
        catch (BadPaddingException bpe) {
            throw new IOException(bpe.toString());
        }
        catch (ShortBufferException sbe) {
            throw new IOException(sbe.toString());
        }
        this.out.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int b) throws IOException {
        if (this.isStream) {
            byte[] buf = new byte[]{(byte)b};
            try {
                this.cipher.update(buf, 0, 1, buf, 0);
            }
            catch (ShortBufferException sbe) {
                throw new IOException(sbe.toString());
            }
            this.out.write(buf);
            return;
        }
        this.inBuffer[1][this.inLength++] = (byte)b;
        if (this.inLength == this.inBuffer[1].length) {
            this.process();
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.isStream) {
            this.out.write(this.cipher.update(buf, off, len));
            return;
        }
        int count = 0;
        while (count < len) {
            int l = Math.min(this.inBuffer[1].length - this.inLength, len - count);
            System.arraycopy(buf, off + count, this.inBuffer[1], this.inLength, l);
            count += l;
            this.inLength += l;
            if (this.inLength != this.inBuffer[1].length) continue;
            this.process();
        }
    }

    private final void process() throws IOException {
        if (this.state == 1) {
            this.state = 2;
        } else {
            byte[] temp = this.inBuffer[0];
            this.inBuffer[0] = this.inBuffer[1];
            this.inBuffer[1] = temp;
        }
        if (this.state == 0) {
            this.inLength = 0;
            this.state = 1;
            return;
        }
        try {
            this.cipher.update(this.inBuffer[0], 0, this.inBuffer[0].length, this.outBuffer);
        }
        catch (ShortBufferException sbe) {
            throw new IOException(sbe.toString());
        }
        this.out.write(this.outBuffer);
        this.inLength = 0;
    }

    public CipherOutputStream(OutputStream out, Cipher cipher) {
        super(out);
        if (cipher != null) {
            this.cipher = cipher;
            boolean bl = false;
            if (cipher.getBlockSize() == 1) {
                bl = this.isStream = true;
            }
            if (!bl) {
                this.inBuffer = new byte[2][];
                this.inBuffer[0] = new byte[cipher.getBlockSize()];
                this.inBuffer[1] = new byte[cipher.getBlockSize()];
                this.inLength = 0;
                this.state = 0;
            }
        } else {
            this.cipher = new NullCipher();
        }
    }

    protected CipherOutputStream(OutputStream out) {
        super(out);
    }
}

