/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;
    static /* synthetic */ Class class$javax$swing$event$TableColumnModelListener;

    public void addColumn(TableColumn col) {
        if (col == null) {
            throw new IllegalArgumentException("Null 'col' argument.");
        }
        this.tableColumns.add(col);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.tableColumns.size() - 1));
    }

    public void removeColumn(TableColumn col) {
        int index = this.tableColumns.indexOf(col);
        if (index < 0) {
            return;
        }
        this.fireColumnRemoved(new TableColumnModelEvent(this, index, 0));
        this.tableColumns.remove(col);
        this.invalidateWidthCache();
    }

    public void moveColumn(int i, int j) {
        int columnCount = this.getColumnCount();
        if (i < 0 || i >= columnCount) {
            throw new IllegalArgumentException("Index 'i' out of range.");
        }
        if (j < 0 || j >= columnCount) {
            throw new IllegalArgumentException("Index 'j' out of range.");
        }
        Object column = this.tableColumns.remove(i);
        this.tableColumns.add(j, column);
        this.fireColumnAdded(new TableColumnModelEvent(this, i, j));
    }

    public void setColumnMargin(int m) {
        this.columnMargin = m;
        this.fireColumnMarginChanged();
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        int columnCount = this.tableColumns.size();
        int i = 0;
        while (i < columnCount) {
            TableColumn tc = (TableColumn)this.tableColumns.get(i);
            if (identifier.equals(tc.getIdentifier())) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("No TableColumn with that identifier.");
    }

    public TableColumn getColumn(int i) {
        return (TableColumn)this.tableColumns.get(i);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int x) {
        int i = 0;
        while (i < this.tableColumns.size()) {
            int w = ((TableColumn)this.tableColumns.get(i)).getWidth();
            if (x >= 0 && x < w) {
                return i;
            }
            x -= w;
            ++i;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel = model;
        this.selectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int[] getSelectedColumns() {
        ListSelectionModel lsm = this.selectionModel;
        int sz = this.getSelectedColumnCount();
        int[] ret = new int[sz];
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int j = 0;
        ArrayList ls = new ArrayList();
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    ret[0] = lo;
                    break;
                }
                case 1: {
                    int i = lo;
                    while (i <= hi) {
                        ret[j++] = i++;
                    }
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ret[j++] = i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public int getSelectedColumnCount() {
        ListSelectionModel lsm = this.selectionModel;
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int sum = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    sum = 1;
                    break;
                }
                case 1: {
                    sum = hi - lo + 1;
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ++sum;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return sum;
    }

    public void addColumnModelListener(TableColumnModelListener listener) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeColumnModelListener(TableColumnModelListener listener) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        return (TableColumnModelListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnAdded(e);
            ++i;
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnRemoved(e);
            ++i;
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnMoved(e);
            ++i;
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent evt) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        EventListener[] listeners = this.getListeners(clazz);
        int i = 0;
        while (i < listeners.length) {
            ((TableColumnModelListener)listeners[i]).columnSelectionChanged(evt);
            ++i;
        }
    }

    protected void fireColumnMarginChanged() {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        EventListener[] listeners = this.getListeners(clazz);
        int i = 0;
        while (i < listeners.length) {
            ((TableColumnModelListener)listeners[i]).columnMarginChanged(this.changeEvent);
            ++i;
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("columWidth")) {
            this.invalidateWidthCache();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            int i = 0;
            while (i < this.tableColumns.size()) {
                this.totalColumnWidth += ((TableColumn)this.tableColumns.get(i)).getWidth();
                ++i;
            }
        }
    }

    private final void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
    }

    public DefaultTableColumnModel() {
        this.this();
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }
}

