/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.Registry;
import org.apache.jk.core.JkHandler;

public class ModJkMX
extends JkHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$ModJkMX == null ? (class$org$apache$jk$common$ModJkMX = ModJkMX.class$("org.apache.jk.common.ModJkMX")) : class$org$apache$jk$common$ModJkMX));
    MBeanServer mserver;
    String webServerHost = "localhost";
    int webServerPort = 80;
    String statusPath = "/jkstatus";
    String user;
    String pass;
    Registry reg;
    HashMap mbeans = new HashMap();
    long lastRefresh = 0L;
    long updateInterval = 5000L;
    static /* synthetic */ Class class$org$apache$jk$common$ModJkMX;
    static /* synthetic */ Class class$org$apache$jk$common$ModJkMX$MBeanProxy;

    public String getWebServerHost() {
        return this.webServerHost;
    }

    public void setWebServerHost(String webServerHost) {
        this.webServerHost = webServerHost;
    }

    public int getWebServerPort() {
        return this.webServerPort;
    }

    public void setWebServerPort(int webServerPort) {
        this.webServerPort = webServerPort;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getStatusPath() {
        return this.statusPath;
    }

    public void setStatusPath(String statusPath) {
        this.statusPath = statusPath;
    }

    public void destroy() {
        try {
            Iterator mbeansIt = this.mbeans.values().iterator();
            MBeanServer mbserver = Registry.getRegistry(null, null).getMBeanServer();
            while (mbeansIt.hasNext()) {
                MBeanProxy proxy = (MBeanProxy)((Object)mbeansIt.next());
                String ooname = proxy.getObjectName();
                if (ooname == null) continue;
                ObjectName oname = null;
                if (ooname instanceof ObjectName) {
                    oname = (ObjectName)((Object)ooname);
                } else if (ooname instanceof String) {
                    oname = new ObjectName(ooname);
                }
                if (oname == null) continue;
                mbserver.unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Destroy error", t);
        }
    }

    public void init() throws IOException {
        try {
            log.info((Object)("init " + this.webServerHost + " " + this.webServerPort));
            this.reg = Registry.getRegistry(null, null);
            this.refreshMetadata();
            this.refreshAttributes();
        }
        catch (Throwable t) {
            log.error((Object)"Init error", t);
        }
    }

    public void start() throws IOException {
        if (this.reg == null) {
            this.init();
        }
    }

    public void refresh() {
        long time = System.currentTimeMillis();
        if (time - this.lastRefresh < this.updateInterval) {
            return;
        }
        this.lastRefresh = time;
        this.refreshMetadata();
        this.refreshAttributes();
    }

    public void refreshAttributes() {
        try {
            String line;
            int cnt = 0;
            BufferedReader is = this.getStream("dmp=*");
            if (is == null) {
                return;
            }
            String name = null;
            String att = null;
            String val = null;
            while ((line = is.readLine()) != null) {
                MBeanProxy proxy;
                int idx;
                if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read " + line));
                }
                if (line.startsWith("[") && (name = line.substring(1)).endsWith("]")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((idx = line.indexOf(61)) < 0) continue;
                att = line.substring(0, idx);
                val = line.substring(idx + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("name: " + name + " att=" + att + " val=" + val));
                }
                if ((proxy = (MBeanProxy)((Object)this.mbeans.get(name))) == null) {
                    log.info((Object)("Unknown object " + name));
                    continue;
                }
                proxy.update(att, val);
                ++cnt;
            }
            log.info((Object)("Refreshing attributes " + cnt));
        }
        catch (Exception ex) {
            log.info((Object)"Error ", (Throwable)ex);
        }
    }

    BufferedReader getStream(String qry) throws Exception {
        try {
            String path = this.statusPath + "?" + qry;
            URL url = new URL("http", this.webServerHost, this.webServerPort, path);
            URLConnection urlc = url.openConnection();
            BufferedReader is = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
            return is;
        }
        catch (IOException e) {
            log.info((Object)("Can't connect to jkstatus " + this.webServerHost + ":" + this.webServerPort + " " + e.toString()));
            return null;
        }
    }

    public void refreshMetadata() {
        try {
            int cnt = 0;
            int newCnt = 0;
            BufferedReader is = this.getStream("lst=*");
            if (is == null) {
                return;
            }
            String name = null;
            String type = null;
            ArrayList<String> getters = new ArrayList<String>();
            ArrayList<String> setters = new ArrayList<String>();
            ArrayList<String> methods = new ArrayList<String>();
            while (true) {
                String line = is.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read " + line));
                }
                if ((line == null || line.startsWith("[")) && name != null) {
                    ++cnt;
                    if (this.mbeans.get(name) == null) {
                        ++newCnt;
                        MBeanProxy mproxy = new MBeanProxy(this);
                        mproxy.init(name, getters, setters, methods);
                        this.mbeans.put(name, mproxy);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("mbean name: " + name + " type=" + type));
                    }
                    getters.clear();
                    setters.clear();
                    methods.clear();
                }
                if (line == null) break;
                if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    name = line.substring(1, line.length() - 1);
                }
                if (line.startsWith("T=")) {
                    type = line.substring(2);
                }
                if (line.startsWith("G=")) {
                    getters.add(line.substring(2));
                }
                if (line.startsWith("S=")) {
                    setters.add(line.substring(2));
                }
                if (!line.startsWith("M=")) continue;
                methods.add(line.substring(2));
            }
            log.info((Object)("Refreshing metadata " + cnt + " " + newCnt));
        }
        catch (Exception ex) {
            log.info((Object)"Error ", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MBeanProxy
    extends BaseModelMBean {
        private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$ModJkMX$MBeanProxy == null ? (class$org$apache$jk$common$ModJkMX$MBeanProxy = ModJkMX.class$("org.apache.jk.common.ModJkMX$MBeanProxy")) : class$org$apache$jk$common$ModJkMX$MBeanProxy));
        String jkName;
        List getAttNames;
        List setAttNames;
        HashMap atts = new HashMap();
        ModJkMX jkmx;

        public MBeanProxy(ModJkMX jkmx) throws Exception {
            this.jkmx = jkmx;
        }

        void init(String name, List getters, List setters, List methods) throws Exception {
            String att;
            int i;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register " + name));
            }
            int col = name.indexOf(58);
            this.jkName = name;
            String type = name.substring(0, col);
            String id = name.substring(col + 1);
            id = id.replace('*', '%');
            if ((id = id.replace(':', '%')).length() == 0) {
                id = "default";
            }
            ManagedBean mbean = new ManagedBean();
            AttributeInfo ai = new AttributeInfo();
            ai.setName("jkName");
            ai.setType("java.lang.String");
            ai.setWriteable(false);
            mbean.addAttribute(ai);
            for (i = 0; i < getters.size(); ++i) {
                att = (String)getters.get(i);
                ai = new AttributeInfo();
                ai.setName(att);
                ai.setType("java.lang.String");
                if (!setters.contains(att)) {
                    ai.setWriteable(false);
                }
                mbean.addAttribute(ai);
            }
            for (i = 0; i < setters.size(); ++i) {
                att = (String)setters.get(i);
                if (getters.contains(att)) continue;
                ai = new AttributeInfo();
                ai.setName(att);
                ai.setType("java.lang.String");
                ai.setReadable(false);
                mbean.addAttribute(ai);
            }
            for (i = 0; i < methods.size(); ++i) {
                att = (String)methods.get(i);
                OperationInfo oi = new OperationInfo();
                oi.setName(att);
                oi.setReturnType("void");
                mbean.addOperation(oi);
            }
            this.setModelMBeanInfo(mbean.createMBeanInfo());
            MBeanServer mserver = Registry.getRegistry(null, null).getMBeanServer();
            this.oname = new ObjectName("apache:type=" + type + ",id=" + id);
            mserver.registerMBean((Object)this, this.oname);
        }

        private void update(String name, String val) {
            log.debug((Object)("Updating " + this.jkName + " " + name + " " + val));
            this.atts.put(name, val);
        }

        public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if ("jkName".equals(name)) {
                return this.jkName;
            }
            this.jkmx.refresh();
            return this.atts.get(name);
        }

        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            try {
                String val = (String)attribute.getValue();
                String name = attribute.getName();
                BufferedReader is = this.jkmx.getStream("set=" + this.jkName + "|" + name + "|" + val);
                if (is == null) {
                    return;
                }
                String res = is.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting " + this.jkName + " " + name + " result " + res));
                }
                this.jkmx.refreshMetadata();
                this.jkmx.refreshAttributes();
            }
            catch (Exception ex) {
                throw new MBeanException(ex);
            }
        }

        public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            try {
                BufferedReader is = this.jkmx.getStream("inv=" + this.jkName + "|" + name);
                if (is == null) {
                    return null;
                }
                String res = is.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking " + this.jkName + " " + name + " result " + res));
                }
                this.jkmx.refreshMetadata();
                this.jkmx.refreshAttributes();
            }
            catch (Exception ex) {
                throw new MBeanException(ex);
            }
            return null;
        }
    }
}

