/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust.message.token;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.ws.sandbox.security.trust.WSTrustException;
import org.apache.ws.sandbox.security.trust.message.token.CompositeElement;
import org.apache.ws.sandbox.security.trust.message.token.Created;
import org.apache.ws.sandbox.security.trust.message.token.Expires;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Lifetime
extends CompositeElement {
    private Created createdElement;
    private Expires expiresElement;
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Lifetime", "wst");

    public Lifetime(Document doc, String created, String expires) {
        super(doc);
        this.createdElement = new Created(doc);
        this.createdElement.setValue(created);
        this.addChild(this.createdElement);
        this.expiresElement = new Expires(doc);
        this.expiresElement.setValue(expires);
        this.addChild(this.expiresElement);
    }

    public Lifetime(Element elem) throws WSTrustException {
        super(elem);
    }

    public Lifetime(Document doc, int duration) {
        super(doc);
        SimpleDateFormat sdtf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        this.createdElement = new Created(doc);
        this.createdElement.setValue(sdtf.format(rightNow.getTime()));
        this.addChild(this.createdElement);
        this.expiresElement = new Expires(doc);
        long exp = rightNow.getTime().getTime() + (long)(duration * 1000 * 60);
        expires.setTimeInMillis(exp);
        this.expiresElement.setValue(sdtf.format(expires.getTime()));
        this.addChild(this.expiresElement);
    }

    public String getCreated() {
        if (this.createdElement != null) {
            return this.createdElement.getValue();
        }
        return null;
    }

    public String getExpires() {
        if (this.expiresElement != null) {
            return this.expiresElement.getValue();
        }
        return null;
    }

    public void setCreated(String value) {
        if (this.createdElement != null) {
            this.createdElement.setValue(value);
        } else {
            this.createdElement = new Created(this.document);
            this.createdElement.setValue(value);
            this.addChild(this.createdElement);
        }
    }

    public void setExpires(String value) {
        if (this.expiresElement != null) {
            this.expiresElement.setValue(value);
        } else {
            this.expiresElement = new Expires(this.document);
            this.expiresElement.setValue(value);
            this.addChild(this.expiresElement);
        }
    }

    protected QName getToken() {
        return TOKEN;
    }

    protected void deserializeChildElement(Element elem) throws WSTrustException {
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (el.equals(Created.TOKEN)) {
            this.createdElement = new Created(elem);
        } else if (el.equals(Expires.TOKEN)) {
            this.expiresElement = new Expires(elem);
        } else {
            throw new WSTrustException("InvalidRequest", "incorrectChildElement", new Object[]{TOKEN.getPrefix(), TOKEN.getLocalPart(), el.getNamespaceURI(), el.getLocalPart()});
        }
    }
}

