/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ProgressBar
extends Canvas {
    private int nMinPos;
    private int nMaxPos;
    private int nCurPos;

    public ProgressBar(int nMin, int nMax) {
        this.nMinPos = nMin;
        this.nMaxPos = nMax;
        if (this.nMaxPos <= this.nMinPos) {
            this.nMaxPos = this.nMinPos + 1;
        }
        this.nCurPos = this.nMinPos;
        this.setBackground(Color.lightGray);
    }

    public int getMinPos() {
        return this.nMinPos;
    }

    public int getMaxPos() {
        return this.nMaxPos;
    }

    public int getCurPos() {
        return this.nCurPos;
    }

    public void setCurPos(int nPos) {
        this.nCurPos = nPos;
        if (this.nCurPos > this.nMaxPos) {
            this.nCurPos = this.nMaxPos;
        }
        if (this.nCurPos < this.nMinPos) {
            this.nCurPos = this.nMinPos;
        }
        this.repaint();
    }

    public int getCurPercent() {
        return 100 * (this.nCurPos - this.nMinPos) / (this.nMaxPos - this.nMinPos);
    }

    public void paint(Graphics graphics) {
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        graphics.setColor(Color.darkGray);
        graphics.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 2);
        graphics.drawLine(rect.x, rect.y, rect.x + rect.width - 2, rect.y);
        graphics.setColor(Color.white);
        graphics.drawLine(rect.x + rect.width - 1, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + 1);
        graphics.drawLine(rect.x + rect.width - 1, rect.y + rect.height - 1, rect.x + 1, rect.y + rect.height - 1);
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        graphics.setColor(Color.blue);
        rect.width = rect.width * (this.nCurPos - this.nMinPos) / (this.nMaxPos - this.nMinPos);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(128, 22);
        return dim;
    }
}

