/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.dss;

import gnu.crypto.hash.Sha160;
import gnu.crypto.util.PRNG;
import gnu.crypto.util.Prime;
import java.math.BigInteger;
import java.security.SecureRandom;

public class FIPS186 {
    public static final int DSA_PARAMS_SEED = 0;
    public static final int DSA_PARAMS_COUNTER = 1;
    public static final int DSA_PARAMS_Q = 2;
    public static final int DSA_PARAMS_P = 3;
    public static final int DSA_PARAMS_E = 4;
    public static final int DSA_PARAMS_G = 5;
    private static final BigInteger TWO = new BigInteger("2");
    private static final BigInteger TWO_POW_160 = TWO.pow(160);
    private Sha160 sha;
    private int L;
    private SecureRandom rnd;

    private /* synthetic */ void finit$() {
        this.sha = new Sha160();
        this.rnd = null;
    }

    public FIPS186(int L, SecureRandom rnd) {
        this.finit$();
        this.L = L;
        this.rnd = rnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BigInteger[] generateParameters() {
        BigInteger g;
        BigInteger p_minus_1;
        BigInteger h;
        BigInteger e;
        BigInteger p;
        int counter;
        BigInteger q;
        BigInteger SEED;
        byte[] kb = new byte[20];
        int b = (this.L - 1) % 160;
        int n = (this.L - 1 - b) / 160;
        BigInteger[] V = new BigInteger[n + 1];
        block6: while (true) {
            byte[] u;
            byte[] a;
            this.nextRandomBytes(kb);
            SEED = new BigInteger(1, kb).setBit(159).setBit(0);
            BigInteger alpha = SEED.add(BigInteger.ONE).mod(TWO_POW_160);
            Sha160 sha160 = this.sha;
            // MONITORENTER : sha160
            try {
                a = SEED.toByteArray();
                this.sha.update(a, 0, a.length);
                a = this.sha.digest();
                u = alpha.toByteArray();
                this.sha.update(u, 0, u.length);
                u = this.sha.digest();
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                // MONITOREXIT : sha160
                throw throwable;
            }
            Object var21_20 = null;
            // MONITOREXIT : sha160
            for (int i = 0; i < a.length; ++i) {
                int n2 = i;
                a[n2] = a[n2] ^ u[i];
            }
            BigInteger U = new BigInteger(1, a);
            q = U.setBit(159).setBit(0);
            if (!Prime.isProbablePrime(q)) continue;
            counter = 0;
            int offset = 2;
            do {
                BigInteger c;
                int k2;
                BigInteger OFFSET = BigInteger.valueOf((long)offset & 0xFFFFFFFFL);
                BigInteger SEED_PLUS_OFFSET = SEED.add(OFFSET);
                Sha160 sha1602 = this.sha;
                // MONITORENTER : sha1602
                try {
                    for (k2 = 0; k2 <= n; ++k2) {
                        a = SEED_PLUS_OFFSET.add(BigInteger.valueOf((long)k2 & 0xFFFFFFFFL)).mod(TWO_POW_160).toByteArray();
                        this.sha.update(a, 0, a.length);
                        V[k2] = new BigInteger(1, this.sha.digest());
                    }
                    Object k2 = null;
                }
                catch (Throwable throwable) {
                    Object k2 = null;
                    // MONITOREXIT : sha1602
                    throw throwable;
                }
                BigInteger W = V[0];
                for (k2 = 1; k2 < n; W = W.add(V[k2].multiply(TWO.pow(k2 * 160))), ++k2) {
                }
                BigInteger X = (W = W.add(V[n].mod(TWO.pow(b)).multiply(TWO.pow(n * 160)))).add(TWO.pow(this.L - 1));
                p = X.subtract((c = X.mod(TWO.multiply(q))).subtract(BigInteger.ONE));
                if (p.compareTo(TWO.pow(this.L - 1)) >= 0 && Prime.isProbablePrime(p)) {
                    e = p.subtract(BigInteger.ONE).divide(q);
                    h = TWO;
                    p_minus_1 = p.subtract(BigInteger.ONE);
                    g = TWO;
                    break block6;
                }
                offset += n + 1;
            } while (++counter < 4096);
        }
        while (h.compareTo(p_minus_1) < 0 && (g = h.modPow(e, p)).equals(BigInteger.ONE)) {
            h = h.add(BigInteger.ONE);
        }
        return new BigInteger[]{SEED, BigInteger.valueOf(counter), q, p, e, g};
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            PRNG.nextBytes(buffer);
        }
    }
}

