/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grouper;

import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.date.DateMonthGrouper;
import com.jidesoft.grouper.date.DateYearGrouper;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.util.Calendar;
import java.util.Date;

public class ObjectGrouperManager {
    private static CacheMap<ObjectGrouper, GrouperContext> _cache = new CacheMap(GrouperContext.DEFAULT_CONTEXT);
    private static ObjectGrouper _defaultGrouper = null;
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    public static void registerGrouper(Class<?> clazz, ObjectGrouper grouper, GrouperContext context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (context == null) {
            context = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        _cache.register(clazz, grouper, context);
    }

    public static void registerGrouper(Class<?> clazz, ObjectGrouper grouper) {
        ObjectGrouperManager.registerGrouper(clazz, grouper, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterGrouper(Class<?> clazz, GrouperContext context) {
        if (context == null) {
            context = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        _cache.unregister(clazz, context);
    }

    public static void unregisterGrouper(Class<?> clazz) {
        ObjectGrouperManager.unregisterGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllGroupers(Class<?> clazz) {
        _cache.remove(clazz);
    }

    public static void unregisterAllGroupers() {
        _cache.clear();
    }

    public static ObjectGrouper getGrouper(Class<?> clazz, GrouperContext context) {
        ObjectGrouper object;
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        if (context == null) {
            context = GrouperContext.DEFAULT_CONTEXT;
        }
        if ((object = _cache.getRegisteredObject(clazz, context)) != null) {
            return object;
        }
        return _defaultGrouper;
    }

    public static ObjectGrouper getGrouper(Class<?> clazz) {
        return ObjectGrouperManager.getGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object) {
        if (object != null) {
            return ObjectGrouperManager.getGroupValue(object, object.getClass(), GrouperContext.DEFAULT_CONTEXT);
        }
        return null;
    }

    public static Object getGroupValue(Object object, Class<?> clazz) {
        return ObjectGrouperManager.getGroupValue(object, clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object, Class<?> clazz, GrouperContext context) {
        ObjectGrouper grouper = ObjectGrouperManager.getGrouper(clazz, context);
        if (grouper != null) {
            return grouper.getValue(object);
        }
        return null;
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean autoInit) {
        _autoInit = autoInit;
    }

    public static void addRegistrationListener(RegistrationListener l) {
        _cache.addRegistrationListener(l);
    }

    public static void removeRegistrationListener(RegistrationListener l) {
        _cache.removeRegistrationListener(l);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static GrouperContext[] getGrouperContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (GrouperContext[])new GrouperContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultGrouper() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            DateYearGrouper dateYearGrouper = new DateYearGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            DateMonthGrouper dateMonthGrouper = new DateMonthGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        ObjectGrouperManager.resetInit();
        _cache.clear();
    }
}

