/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.formatter.TwigFormatterOptions;
import com.jetbrains.twig.parser.TwigBlockStatements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigBlock
extends TemplateLanguageBlock {
    private final TwigFormatterOptions myOptions;

    protected TwigBlock(AbstractXmlTemplateFormattingModelBuilder builder, @NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent) {
        if (node == null) {
            TwigBlock.$$$reportNull$$$0(0);
        }
        super(builder, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        this.myOptions = (TwigFormatterOptions)settings.getCustomSettings(TwigFormatterOptions.class);
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            TwigBlock.$$$reportNull$$$0(1);
        }
        if (!(child1 instanceof ASTBlock)) {
            return null;
        }
        if (!(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode leftNode = ((ASTBlock)child1).getNode();
        ASTNode rightNode = ((ASTBlock)child2).getNode();
        IElementType leftType = leftNode.getElementType();
        IElementType rightType = rightNode.getElementType();
        if (leftType == TwigTokenTypes.STATEMENT_BLOCK_START || rightType == TwigTokenTypes.STATEMENT_BLOCK_END) {
            return TwigBlock.createSingleSpace(this.myOptions.SPACES_INSIDE_DELIMITERS);
        }
        if (leftType == TwigTokenTypes.PRINT_BLOCK_START || rightType == TwigTokenTypes.PRINT_BLOCK_END) {
            return TwigBlock.createSingleSpace(this.myOptions.SPACES_INSIDE_VARIABLE_DELIMITERS);
        }
        return null;
    }

    private static Spacing createSingleSpace(boolean addSpace) {
        int spaces = addSpace ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @NotNull
    protected Indent getChildIndent(@NotNull ASTNode childNode) {
        TwigBlockStatements.StatementDefinition statementDefinition;
        if (childNode == null) {
            TwigBlock.$$$reportNull$$$0(2);
        }
        IElementType theType = this.myNode.getElementType();
        ASTNode firstChildNode = this.myNode.getFirstChildNode();
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        IElementType childType = childNode.getElementType();
        if (theType == TwigElementTypes.TAG) {
            if (childType != TwigTokenTypes.STATEMENT_BLOCK_START && childType != TwigTokenTypes.STATEMENT_BLOCK_END) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(3);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.TWIG_STATEMENT) {
            if (childType != TwigElementTypes.TAG) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(4);
                }
                return indent;
            }
        } else if (TwigElementTypes.TAGS.contains(theType)) {
            if (childType != TwigTokenTypes.STATEMENT_BLOCK_START && childType != TwigTokenTypes.STATEMENT_BLOCK_END) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(5);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.IF_STATEMENT) {
            if (childType != TwigElementTypes.IF_TAG && childType != TwigElementTypes.ELSE_STATEMENT && childType != TwigElementTypes.ELSE_TAG && childType != TwigElementTypes.ENDIF_TAG && childType != TwigElementTypes.ELSEIF_STATEMENT) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(6);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.ELSE_STATEMENT) {
            if (childType != TwigElementTypes.ELSE_TAG && childType != TwigElementTypes.ENDIF_TAG && childType != TwigElementTypes.ENDFOR_TAG) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(7);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.ELSEIF_STATEMENT) {
            if (childType != TwigElementTypes.ELSE_TAG && childType != TwigElementTypes.ELSE_STATEMENT && childType != TwigElementTypes.ENDIF_TAG && childType != TwigElementTypes.ELSEIF_STATEMENT && childType != TwigElementTypes.ELSEIF_TAG) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(8);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.FOR_STATEMENT) {
            if (childType != TwigElementTypes.FOR_TAG && childType != TwigElementTypes.ENDFOR_TAG && childType != TwigElementTypes.ELSE_STATEMENT) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(9);
                }
                return indent;
            }
        } else if (theType == TwigElementTypes.LITERAL) {
            if (firstChildNode != null) {
                if (firstChildNode.getElementType() == TwigTokenTypes.LBRACE_CURL) {
                    if (!(childType == TwigTokenTypes.LBRACE_CURL && childNode == firstChildNode || childType == TwigTokenTypes.RBRACE_CURL && childNode == lastChildNode)) {
                        Indent indent = Indent.getNormalIndent();
                        if (indent == null) {
                            TwigBlock.$$$reportNull$$$0(10);
                        }
                        return indent;
                    }
                } else if (!(childType == TwigTokenTypes.LBRACE_SQ && childNode == firstChildNode || childType == TwigTokenTypes.RBRACE_SQ && childNode == lastChildNode)) {
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        TwigBlock.$$$reportNull$$$0(11);
                    }
                    return indent;
                }
            }
        } else if (theType == TwigElementTypes.FUNCTION_CALL || theType == TwigElementTypes.METHOD_CALL) {
            if (firstChildNode != null && childNode != firstChildNode && childType != TwigTokenTypes.RBRACE && firstChildNode.getTreeNext() != childNode) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    TwigBlock.$$$reportNull$$$0(12);
                }
                return indent;
            }
        } else if (TwigBlockStatements.isBlockStatement(theType) && (statementDefinition = TwigBlockStatements.getStatementDefinitionByType(theType)) != null && !statementDefinition.isStartTag(childType) && !statementDefinition.isEndTag(childType)) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                TwigBlock.$$$reportNull$$$0(13);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            TwigBlock.$$$reportNull$$$0(14);
        }
        return indent;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == TwigTokenTypes.COMMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                TwigBlock.$$$reportNull$$$0(15);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        if (childAttributes == null) {
            TwigBlock.$$$reportNull$$$0(16);
        }
        return childAttributes;
    }

    protected Spacing getSpacing(TemplateLanguageBlock adjacentBlock) {
        return Spacing.getReadOnlySpacing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/formatter/TwigBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/formatter/TwigBlock";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

