/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.accessors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import org.jetbrains.annotations.NotNull;

public class PhpAccessorsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(PhpAccessorsCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition().getOriginalElement();
        PsiElement parent = position.getParent();
        if (PhpAccessorsCompletionProvider.isValidPosition(position)) {
            PhpClass phpClass = (PhpClass)parent;
            for (Field field : phpClass.getFields()) {
                if (!PhpAccessorsCompletionProvider.isApplicableToField(phpClass, field)) continue;
                PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(phpClass, field);
                if (accessorsGenerator.findGetters().length == 0) {
                    for (PhpAccessorMethodData data : accessorsGenerator.createGetters(true)) {
                        result.addElement((LookupElement)new AccessorLookupElement(data));
                    }
                }
                if (accessorsGenerator.findSetters().length != 0) continue;
                for (PhpAccessorMethodData data : accessorsGenerator.createSetters(false, true)) {
                    result.addElement((LookupElement)new AccessorLookupElement(data));
                }
            }
        }
    }

    public static boolean isValidPosition(@NotNull PsiElement position) {
        PsiElement before;
        PsiElement parent;
        if (position == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(3);
        }
        return (parent = position.getParent()) instanceof PhpClass && !((PhpClass)parent).isInterface() && (before = PhpPsiUtil.getPrevSibling(position, e -> e instanceof PsiWhiteSpace || e instanceof PsiErrorElement)) != null && !PhpTokenTypes.tsKEYWORDS.contains(before.getNode().getElementType()) && !(before instanceof PhpModifierList);
    }

    private static boolean isApplicableToField(@NotNull PhpClass currClass, @NotNull Field field) {
        PhpClass fieldClass;
        if (currClass == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(4);
        }
        if (field == null) {
            PhpAccessorsCompletionProvider.$$$reportNull$$$0(5);
        }
        return !field.isConstant() && ((fieldClass = field.getContainingClass()) == currClass || field.getModifier().isProtected() || field.getModifier().isPublic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/accessors/PhpAccessorsCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPosition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableToField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AccessorLookupElement
    extends LookupElement {
        PhpAccessorMethodData myData;

        private AccessorLookupElement(@NotNull PhpAccessorMethodData data) {
            if (data == null) {
                AccessorLookupElement.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        @NotNull
        public String getLookupString() {
            String string = this.myData.getCompletionLookupString();
            if (string == null) {
                AccessorLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                AccessorLookupElement.$$$reportNull$$$0(2);
            }
            AccessorLookupElement.insertMethod(context, this.getTextToInsert());
        }

        public static void insertMethod(@NotNull InsertionContext context, @NotNull String methodText) {
            if (context == null) {
                AccessorLookupElement.$$$reportNull$$$0(3);
            }
            if (methodText == null) {
                AccessorLookupElement.$$$reportNull$$$0(4);
            }
            Editor editor = context.getEditor();
            int startOffset = context.getStartOffset();
            int tailOffset = context.getTailOffset();
            int endOffset = startOffset + methodText.length();
            editor.getDocument().replaceString(startOffset, tailOffset, (CharSequence)methodText);
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(editor.getDocument());
            if (psiFile != null) {
                CodeStyleManager.getInstance((Project)context.getProject()).reformatText(psiFile, startOffset, endOffset);
            } else {
                LOG.warn("Formatting failed, no PsiFile");
            }
        }

        @NotNull
        private String getTextToInsert() {
            PhpAccessorMethodData[] accessors;
            StringBuilder sb = new StringBuilder();
            PhpAccessorsGenerator generator = new PhpAccessorsGenerator(this.myData.getTargetClass(), this.myData.getClassField());
            for (PhpAccessorMethodData methodData : accessors = generator.createAccessors(false, false)) {
                if (methodData.getAccessorType() != this.myData.getAccessorType()) continue;
                PhpDocComment phpDoc = methodData.getDocComment();
                if (phpDoc != null) {
                    sb.append(phpDoc.getText());
                }
                sb.append(methodData.getMethod().getText());
            }
            String string = sb.toString();
            if (string == null) {
                AccessorLookupElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setIcon(PhpIcons.METHOD);
            presentation.setTailText("{...}", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/accessors/PhpAccessorsCompletionProvider$AccessorLookupElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/accessors/PhpAccessorsCompletionProvider$AccessorLookupElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextToInsert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMethod";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

