/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayFilterCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayMapToLoopQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayMapCanBeConvertedToLoopInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpConvertArrayMapToLoopQuickFix()};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayMapCanBeConvertedToLoopInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference arrayMapCall) {
                if (PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(arrayMapCall, "array_map") && PhpArrayMapCanBeConvertedToLoopInspection.isClosureArrayMapFromOneArray(arrayMapCall)) {
                    holder.registerProblem((PsiElement)arrayMapCall, PhpBundle.message("inspection.arraymap.can.be.converted.to.loop", new Object[0]), FIXES);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpArrayMapCanBeConvertedToLoopInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Contract(value="null -> false")
    private static boolean isClosureArrayMapFromOneArray(@NotNull FunctionReference arrayMapCall) {
        PsiElement[] arguments;
        if (arrayMapCall == null) {
            PhpArrayMapCanBeConvertedToLoopInspection.$$$reportNull$$$0(2);
        }
        if ((arguments = arrayMapCall.getParameters()).length != 2) {
            return false;
        }
        Function closure = (Function)PhpPsiUtil.getChildByCondition(arguments[0], (Condition<? super PsiElement>)Function.INSTANCEOF);
        return PhpArrayFilterCanBeConvertedToLoopInspection.canBeCalledAsLambda(arguments[0]) || closure != null && closure.getParameters().length == 1 && arguments[0] instanceof PhpTypedElement && ((PhpTypedElement)arguments[0]).getType().equals((Object)PhpType.CLOSURE) && PhpArrayMapCanBeConvertedToLoopInspection.hasNoUseByReferences(closure) && PsiTreeUtil.findChildrenOfType((PsiElement)closure, PhpReturn.class).size() == 1;
    }

    @Contract(value="null,_ -> false")
    public static boolean isGlobalFunctionCallWithName(@Nullable FunctionReference functionCall, @NotNull String name) {
        if (name == null) {
            PhpArrayMapCanBeConvertedToLoopInspection.$$$reportNull$$$0(3);
        }
        Function function = functionCall != null ? (Function)ObjectUtils.tryCast((Object)functionCall.resolve(), Function.class) : null;
        return function != null && PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName()) && StringUtil.equals((CharSequence)function.getName(), (CharSequence)name);
    }

    public static boolean hasNoUseByReferences(@NotNull Function closure) {
        if (closure == null) {
            PhpArrayMapCanBeConvertedToLoopInspection.$$$reportNull$$$0(4);
        }
        return PhpPsiUtil.getChildByCondition(PsiTreeUtil.getChildOfType((PsiElement)closure, PhpUseList.class), (Condition<? super PsiElement>)Conditions.and((Condition)Variable.INSTANCEOF, PhpWorkaroundUtil::isReadReference)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayMapCanBeConvertedToLoopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayMapCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayMapCanBeConvertedToLoopInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isClosureArrayMapFromOneArray";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalFunctionCallWithName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasNoUseByReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

