/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.PhpFunctionTemplate;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFunctionCodeGenerator {
    public static final PhpFunctionCodeGenerator PREVIEW = new PhpFunctionPreviewGenerator("\n   ", "\n", "\n   ");
    public static final PhpFunctionCodeGenerator DECLARATION = new PhpFunctionDeclarationGenerator();
    public static final PhpFunctionCodeGenerator IMPLEMENTATION = new PhpFunctionImplementationGenerator();
    public static final PhpFunctionCodeGenerator CALL = new PhpFunctionCallGenerator();
    private final String myStartBoundedSeparator;
    private final String myEndBoundedSeparator;
    private final String myParameterSeparator;

    private PhpFunctionCodeGenerator(@NotNull String startBoundedSeparator, @NotNull String endBoundedSeparator, @NotNull String parameterSeparator) {
        if (startBoundedSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(0);
        }
        if (endBoundedSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(1);
        }
        if (parameterSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(2);
        }
        this.myStartBoundedSeparator = startBoundedSeparator;
        this.myEndBoundedSeparator = endBoundedSeparator;
        this.myParameterSeparator = parameterSeparator;
    }

    private PhpFunctionCodeGenerator() {
        this.myStartBoundedSeparator = "";
        this.myEndBoundedSeparator = "";
        this.myParameterSeparator = "";
    }

    public String generate(final @NotNull String name, final @NotNull List<? extends PhpParameterTemplate> parameters, final @NotNull String returnType) {
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(5);
        }
        PhpFunctionTemplate template = new PhpFunctionTemplate(){

            @Override
            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public List getParameters() {
                List list = parameters;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            public PhpModifier.Access getVisibility() {
                return null;
            }

            @Override
            public boolean isDeclareStatic() {
                return false;
            }

            @Override
            @NotNull
            public String getFunctionBody() {
                if ("" == null) {
                    1.$$$reportNull$$$0(2);
                }
                return "";
            }

            @Override
            @NotNull
            public String getReturnType() {
                String string = returnType;
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionBody";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReturnType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        return this.generate(template);
    }

    public String generate(@NotNull Function function, @Nullable String returnTypeText) {
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(6);
        }
        StringBuilder builder = new StringBuilder();
        this.appendFunctionPrefix(builder, function);
        builder.append(function.getName());
        builder.append("(");
        this.generateParameterList(builder, function.getParameters());
        builder.append(")");
        if (StringUtil.isNotEmpty((String)returnTypeText)) {
            builder.append(" : ").append(returnTypeText);
        }
        return builder.toString();
    }

    public String generate(@NotNull Function function) {
        PhpReturnType returnType;
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(7);
        }
        if ((returnType = function.getReturnType()) != null) {
            return this.generate(function, returnType.getText());
        }
        return this.generate(function, null);
    }

    public String generate(@NotNull PhpFunctionTemplate template) {
        if (template == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(8);
        }
        StringBuilder builder = new StringBuilder();
        this.appendFunctionPrefix(builder, template);
        builder.append(template.getName());
        builder.append("(");
        this.generateParameterList(builder, template.getParameters());
        builder.append(")");
        if (!template.getReturnType().isEmpty()) {
            builder.append(":").append(template.getReturnType());
        }
        this.appendFunctionBody(builder, template);
        return builder.toString();
    }

    private void generateParameterList(@NotNull StringBuilder builder, @NotNull Parameter[] parameters) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(10);
        }
        builder.append(this.myStartBoundedSeparator);
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            Parameter parameter = parameters[i];
            if (i > 0) {
                builder.append(",");
                builder.append(this.myParameterSeparator);
            }
            this.appendParameter(builder, parameter);
        }
        builder.append(this.myEndBoundedSeparator);
    }

    private void generateParameterList(@NotNull StringBuilder builder, @NotNull List<? extends PhpParameterTemplate> parameters) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(12);
        }
        builder.append(this.myStartBoundedSeparator);
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            PhpParameterTemplate parameter = parameters.get(i);
            if (i > 0) {
                builder.append(",");
                builder.append(this.myParameterSeparator);
            }
            this.appendParameter(builder, parameter);
        }
        builder.append(this.myEndBoundedSeparator);
    }

    public static String generateParameter(@NotNull PhpParameterTemplate parameter) {
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(13);
        }
        StringBuilder builder = new StringBuilder();
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, parameter.getName());
        return builder.toString();
    }

    public static String generateParameter(@NotNull PhpParameterTemplate parameter, @NotNull CharSequence newName) {
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(15);
        }
        StringBuilder builder = new StringBuilder();
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, newName);
        return builder.toString();
    }

    private static void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter, @NotNull CharSequence name) {
        CharSequence type;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(16);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(17);
        }
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(18);
        }
        if (!StringUtil.isEmpty((CharSequence)(type = parameter.getTypeText()))) {
            builder.append(type);
            builder.append(" ");
        }
        if (parameter.isPassByRef()) {
            builder.append("&");
        }
        if (parameter.isVariadic()) {
            builder.append("...");
        }
        PhpFunctionCodeGenerator.appendParameterName(builder, name);
        CharSequence initializer = parameter.getInitializer();
        if (!StringUtil.isEmpty((CharSequence)initializer)) {
            builder.append(" = ");
            builder.append(initializer);
        }
    }

    private static void appendParameterName(@NotNull StringBuilder builder, @NotNull CharSequence name) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(19);
        }
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(20);
        }
        builder.append("$");
        builder.append(name);
    }

    private static void appendParameterName(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(21);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(22);
        }
        builder.append("$");
        builder.append(parameter.getName());
    }

    @NotNull
    public static String getInitializer(@NotNull Parameter parameter) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(23);
        }
        String string = (defaultValue = parameter.getDefaultValue()) == null ? "" : defaultValue.getText();
        if (string == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(24);
        }
        return string;
    }

    protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
        PhpModifier.Access visibility;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(25);
        }
        if (template == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(26);
        }
        if ((visibility = template.getVisibility()) != null) {
            builder.append(StringUtil.toLowerCase((String)visibility.toString()));
            builder.append(" ");
        }
        if (template.isDeclareStatic()) {
            builder.append("static ");
        }
        builder.append("function ");
    }

    protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull Function function) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(27);
        }
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(28);
        }
        if (function instanceof Method) {
            Method method = (Method)function;
            PhpModifier.Access visibility = method.getAccess();
            if (PhpFunctionCodeGenerator.shouldAddVisibility(method) && visibility != null) {
                builder.append(StringUtil.toLowerCase((String)visibility.toString()));
                builder.append(" ");
            }
            if (method.isStatic()) {
                builder.append("static ");
            }
        }
        builder.append("function ");
    }

    protected static boolean shouldAddVisibility(@NotNull Method method) {
        if (method == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(29);
        }
        if (method.getAccess().isPublic()) {
            PhpModifierList modifier = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
            PsiElement accessElement = modifier == null ? null : PhpFunctionCodeGenerator.getFirstChildMatchedText((PsiElement)modifier, PhpModifier.Access.PUBLIC.toString());
            return accessElement != null;
        }
        return true;
    }

    @Nullable
    public static PsiElement getFirstChildMatchedText(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(30);
        }
        if (text == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(31);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getText().equalsIgnoreCase(text)) continue;
            return child;
        }
        return null;
    }

    protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(32);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(33);
        }
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, parameter.getName());
    }

    protected void appendParameter(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
        String type;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(34);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(35);
        }
        if (!StringUtil.isEmpty((CharSequence)(type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter)))) {
            builder.append((CharSequence)type);
            builder.append(" ");
        }
        if (parameter.isPassByRef()) {
            builder.append("&");
        }
        if (parameter.isVariadic()) {
            builder.append("...");
        }
        PhpFunctionCodeGenerator.appendParameterName(builder, parameter);
        String initializer = PhpFunctionCodeGenerator.getInitializer(parameter);
        if (!StringUtil.isEmpty((CharSequence)initializer)) {
            builder.append(" = ");
            builder.append((CharSequence)initializer);
        }
    }

    protected abstract void appendFunctionBody(@NotNull StringBuilder var1, @NotNull PhpFunctionTemplate var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBoundedSeparator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endBoundedSeparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSeparator";
                break;
            }
            case 3: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 6: 
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateParameter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendParameter";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 24: {
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionPrefix";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddVisibility";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildMatchedText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpFunctionImplementationGenerator
    extends PhpFunctionCodeGenerator {
        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionImplementationGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionImplementationGenerator.$$$reportNull$$$0(1);
            }
            builder.append("{\n");
            builder.append(template.getFunctionBody());
            builder.append("\n}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionImplementationGenerator";
            objectArray[2] = "appendFunctionBody";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionDeclarationGenerator
    extends PhpFunctionCodeGenerator {
        protected PhpFunctionDeclarationGenerator() {
            super("", "", " ");
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionDeclarationGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionDeclarationGenerator.$$$reportNull$$$0(1);
            }
            builder.append(";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionDeclarationGenerator";
            objectArray[2] = "appendFunctionBody";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionPreviewGenerator
    extends PhpFunctionCodeGenerator {
        protected PhpFunctionPreviewGenerator(@NotNull String startBoundedSeparator, @NotNull String endBoundedSeparator, @NotNull String parameterSeparator) {
            if (startBoundedSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(0);
            }
            if (endBoundedSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(1);
            }
            if (parameterSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(2);
            }
            super(startBoundedSeparator, endBoundedSeparator, parameterSeparator);
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(3);
            }
            if (template == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(4);
            }
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
            if (builder == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(5);
            }
            if (parameter == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(6);
            }
            builder.append(parameter.getParameterPreviewText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startBoundedSeparator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endBoundedSeparator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterSeparator";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionPreviewGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionBody";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionCallGenerator
    extends PhpFunctionCodeGenerator {
        @Override
        protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(1);
            }
        }

        @Override
        protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull Function template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(2);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(3);
            }
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(4);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(5);
            }
            builder.append(";");
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(6);
            }
            if (parameter == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(7);
            }
            PhpFunctionCodeGenerator.appendParameterName(builder, parameter.getName());
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(8);
            }
            if (parameter == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(9);
            }
            PhpFunctionCodeGenerator.appendParameterName(builder, parameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionCallGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionPrefix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionBody";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

