/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceVariable;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.inplace.PhpVariableInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableDialog;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariablePresenter;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceVariableHandler
extends PhpIntroduceBaseHandler<PhpIntroduceVariableSettings, PhpIntroduceVariablePresenter> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler");

    @NotNull
    private static Statement getVariableDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        StringBuilder assignBuilder = new StringBuilder();
        assignBuilder.append("$");
        assignBuilder.append(settings.getName());
        assignBuilder.append("=");
        assignBuilder.append(introduceContext.getElementDeclarationText());
        assignBuilder.append(";");
        assignBuilder.append("\n");
        Statement statement = PhpPsiElementFactory.createStatement(introduceContext.getProject(), assignBuilder.toString());
        if (statement == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        return statement;
    }

    @NotNull
    private static PsiElement getNewExpressionForOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        Variable variable = PhpPsiElementFactory.createVariable(introduceContext.getProject(), settings.getName(), true);
        if (variable == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        return variable;
    }

    @NotNull
    public static PsiElement getNewExpressionForOriginalElement(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        if (introduceContext.isPhysical() || introduceContext.getPhysicalElement() instanceof NewExpression) {
            PsiElement psiElement = PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
            if (psiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        if (introduceContext.getPhysicalElement() instanceof BinaryExpression) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(3);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.STRING)) {
            if (settings.isEmbedVariable()) {
                PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByEmbeding((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
                if (phpPsiElement == null) {
                    PhpIntroduceVariableHandler.$$$reportNull$$$0(4);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(5);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.HEREDOC)) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoHeredoc((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(6);
            }
            return phpPsiElement;
        }
        assert (false);
        if (null == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    private static Statement getParentStatement(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        for (PsiElement curElement = strict ? element.getParent() : element; curElement != null; curElement = curElement.getParent()) {
            if (!(curElement instanceof Statement) || curElement instanceof ElseIf || curElement instanceof Include) continue;
            return (Statement)curElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement isDeleteSelf(@NotNull PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        IElementType grandParentNodeType;
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        if (!introduceContext.isPhysical() || settings.isReplaceAllOccurrences()) {
            return null;
        }
        PsiElement anchor = introduceContext.getPhysicalElement();
        PsiElement parent = anchor.getParent();
        IElementType parentNodeType = PhpIntroduceVariableHandler.getElementType(parent);
        IElementType iElementType = grandParentNodeType = parent == null ? null : PhpIntroduceVariableHandler.getElementType(parent.getParent());
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentNodeType)) {
            return anchor;
        }
        if (PhpElementTypes.STATEMENT == parentNodeType && PhpElementTypes.ANY_GROUP_STATEMENT.contains(grandParentNodeType)) {
            return parent;
        }
        return null;
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        ASTNode node = element.getNode();
        return node == null ? null : node.getElementType();
    }

    public static void replaceOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, PsiElement expressionForOriginalElement) {
        if (settings.isReplaceAllOccurrences()) {
            PsiElement expressionForOccurrences = introduceContext.isPhysical() ? expressionForOriginalElement : PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
            for (PsiElement occurrence : introduceContext.getOccurrences()) {
                occurrence.replace(expressionForOccurrences);
            }
        }
    }

    @Override
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.variable.name", new Object[0]);
    }

    @Override
    protected String getFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        PsiNamedElement scope;
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        if ((scope = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PhpClass.class, PhpFile.class, Function.class, Method.class, PhpNamespace.class})) instanceof PhpClass) {
            return null;
        }
        return scope;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        return !PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT);
    }

    @Override
    protected boolean isSupportedScope(@NotNull PsiElement scope, @NotNull PsiElement expression) {
        if (scope == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        return true;
    }

    @Override
    protected boolean isSupportedContext(@NotNull PsiElement context, @NotNull PsiElement logicalExpression, @NotNull PsiElement physicalExpression) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        if (logicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(15);
        }
        if (physicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(16);
        }
        if (context instanceof Parameter) {
            return false;
        }
        if (context instanceof Constant) {
            return context instanceof PhpDefine;
        }
        return true;
    }

    @Override
    protected MultiMap<PsiElement, PsiElement> getOccurrences(@NotNull PsiElement scope, @NotNull PsiElement sample, boolean isPhysical, @NotNull PsiElement sampleContext, @NotNull TextRange elementRange, @NotNull PhpIntroduceContext introduceContext) {
        if (scope == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(17);
        }
        if (sample == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(18);
        }
        if (sampleContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(19);
        }
        if (elementRange == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(20);
        }
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(21);
        }
        PhpIntroduceBaseHandler.OccurrencesCollector collector = new PhpIntroduceBaseHandler.OccurrencesCollector(scope, sample, isPhysical, sampleContext, elementRange){

            @Override
            protected boolean processContext(PsiElement element) {
                return !(element instanceof PhpClass) && !(element instanceof Function) && !(element instanceof Field);
            }
        };
        return collector.getOccurrences();
    }

    @Override
    @NotNull
    protected PhpIntroduceVariablePresenter getPresenter(PhpIntroduceContext introduceContext) {
        PhpIntroduceVariablePresenter phpIntroduceVariablePresenter = new PhpIntroduceVariablePresenter(new PhpIntroduceVariableDialog(introduceContext.getProject()), this, introduceContext);
        if (phpIntroduceVariablePresenter == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(22);
        }
        return phpIntroduceVariablePresenter;
    }

    @Nullable
    private PsiElement findAnchor(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        Statement anchor;
        block7: {
            Statement commonStatement;
            if (settings.isReplaceAllOccurrences()) {
                PsiElement[] introducedExpressions = (PsiElement[])ArrayUtil.append((Object[])introduceContext.getOccurrences(), (Object)introduceContext.getPhysicalElement());
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(PsiTreeUtil.findCommonParent((PsiElement[])introducedExpressions), false);
            } else {
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(introduceContext.getPhysicalElement(), false);
            }
            if (commonStatement instanceof GroupStatement) {
                PsiElement[] introducedExpressions = (PsiElement[])ArrayUtil.append((Object[])introduceContext.getOccurrences(), (Object)introduceContext.getPhysicalElement());
                for (anchor = commonStatement.getFirstPsiChild(); anchor != null; anchor = anchor.getNextPsiSibling()) {
                    for (PsiElement curExpression : introducedExpressions) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)curExpression, (boolean)false)) {
                            continue;
                        }
                        break block7;
                    }
                }
            } else {
                anchor = commonStatement;
            }
        }
        return anchor;
    }

    @Override
    protected PsiElement doRefactoring(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        super.doRefactoring(introduceContext, settings);
        PsiElement deleteSelf = PhpIntroduceVariableHandler.isDeleteSelf(introduceContext, settings);
        Statement assignStatement = PhpIntroduceVariableHandler.getVariableDeclaration(introduceContext, settings);
        if (deleteSelf != null) {
            return deleteSelf.replace((PsiElement)assignStatement);
        }
        PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        PsiElement anchor = this.findAnchor(introduceContext, settings);
        if (anchor != null) {
            PsiElement physicalElement = introduceContext.getPhysicalElement();
            if (anchor == physicalElement) {
                anchor = physicalElement.replace(expressionForOriginalElement);
            } else {
                physicalElement.replace(expressionForOriginalElement);
            }
            Statement result = PhpCodeEditUtil.putStatementBefore(anchor, assignStatement);
            PhpIntroduceVariableHandler.replaceOccurrences(introduceContext, settings, expressionForOriginalElement);
            return result;
        }
        this.showErrorHint(introduceContext.getProject(), introduceContext.getEditor(), PhpBundle.message("refactoring.common.not.supported.expression.in.scope", this.getRefactoringName()));
        return null;
    }

    @Override
    @Nullable
    protected PhpInplaceIntroduceFacade<PhpIntroduceVariableSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(23);
        }
        return !PhpRefactoringUtil.isEmbedVariableAllowed(context) ? new PhpVariableInplaceIntroduceFacade(context) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleContext";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOriginalElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteSelf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

