/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.remote.PhpRemoteSdkConnector;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSshConnectionProvider
implements SshConnectionProvider {
    private static String getId(RemoteSdkCredentials data) {
        return data.getFullInterpreterPath();
    }

    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        List<RemoteConnector> list = this.collectRemoteInterpreters();
        if (list == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private List<RemoteConnector> collectRemoteInterpreters() {
        ArrayList result = ContainerUtil.newArrayList();
        for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType(this.getSdkType())) {
            SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
            if (!(additionalData instanceof RemoteSdkCredentials)) continue;
            result.add(new RemoteInterpreterConnector((RemoteSdkCredentials)additionalData));
        }
        return result;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(RemoteConnectionType type, @Nullable String id, Project project, Module module) {
        if (type == RemoteConnectionType.DEFAULT_SDK) {
            SdkAdditionalData data = this.getCurrentSdkAdditionalData(project, module);
            if (data != null) {
                if (data instanceof RemoteSdkCredentials) {
                    return new PhpRemoteSdkConnector((RemoteSdkCredentials)data);
                }
                Messages.showWarningDialog((Project)project, (String)"Current project interpreter is not remote", (String)"No Host To Connect");
            }
        } else if (type == RemoteConnectionType.REMOTE_SDK) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType(this.getSdkType());
            for (Sdk sdk : sdks) {
                SdkAdditionalData data = sdk.getSdkAdditionalData();
                if (!(data instanceof RemoteSdkCredentials) || !StringUtil.equals((CharSequence)id, (CharSequence)PhpSshConnectionProvider.getId((RemoteSdkCredentials)data))) continue;
                return new RemoteInterpreterConnector((RemoteSdkCredentials)data);
            }
        }
        return null;
    }

    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        if ("Default Remote Interpreter" == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(1);
        }
        return "Default Remote Interpreter";
    }

    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEFAULT_SDK;
        if (remoteConnectionType == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(2);
        }
        return remoteConnectionType;
    }

    @Nullable
    private SdkAdditionalData getCurrentSdkAdditionalData(@Nullable Project project, @Nullable Module contextModule) {
        Pair<Sdk, Module> sdkAndModule = this.findCurrentSdk(project, contextModule);
        Sdk sdk = (Sdk)sdkAndModule.first;
        if (sdk != null) {
            return sdk.getSdkAdditionalData();
        }
        return null;
    }

    @NotNull
    private Pair<Sdk, Module> findCurrentSdk(@Nullable Project project, @Nullable Module contextModule) {
        Sdk sdk = null;
        Module module = null;
        if (contextModule != null) {
            module = contextModule;
            sdk = this.findSdkByModule(module);
        }
        if (sdk == null && project != null) {
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (this.findSdkByModule(m) == null || (sdk = this.findSdkByModule(m)) == null) continue;
                module = m;
                break;
            }
        }
        Pair pair = Pair.create(sdk, (Object)module);
        if (pair == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public SdkTypeId getSdkType() {
        return PhpSdkType.getInstance();
    }

    @Nullable
    public String getSettingCreationDescription() {
        return "add PHP remote interpreter";
    }

    @Nullable
    public Sdk findSdkByModule(Module module) {
        if (module == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return sdk != null && sdk.getSdkType() instanceof PhpSdkType ? sdk : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteConnectors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCurrentSdk";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RemoteInterpreterConnector
    implements RemoteConnector {
        private final RemoteSdkCredentials myRemoteData = new RemoteSdkCredentialsHolder("");

        RemoteInterpreterConnector(RemoteSdkCredentials data) {
            RemoteSdkCredentialsBuilder.copyRemoteSdkCredentials((RemoteSdkCredentials)data, (RemoteSdkCredentials)this.myRemoteData);
        }

        public String getId() {
            return PhpSshConnectionProvider.getId(this.myRemoteData);
        }

        @NotNull
        public String getName() {
            String string = this.myRemoteData.getHost() + ":" + this.myRemoteData.getPort() + " (Remote interpreter)";
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.REMOTE_SDK;
            if (remoteConnectionType == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<RemoteCredentials> remoteCredentialsConsumer) {
            remoteCredentialsConsumer.consume((Object)this.myRemoteData);
        }

        @NotNull
        public Object getConnectorKey() {
            String string = this.myRemoteData.getHost() + ":" + this.myRemoteData.getPort();
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider$RemoteInterpreterConnector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

