/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    protected final ChangeListManager myChangeListManager;
    private final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final List<VirtualFile> myAddedFiles;
    private final Map<VirtualFile, VirtualFile> myCopyFromMap;
    protected final List<VcsException> myExceptions;
    protected final List<FilePath> myDeletedFiles;
    protected final List<FilePath> myDeletedWithoutConfirmFiles;
    protected final List<MovedFileInfo> myMovedFiles;

    protected VcsVFSListener(@NotNull Project project, @NotNull AbstractVcs vcs) {
        if (project == null) {
            VcsVFSListener.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            VcsVFSListener.$$$reportNull$$$0(1);
        }
        this.myAddedFiles = new ArrayList<VirtualFile>();
        this.myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
        this.myExceptions = new SmartList();
        this.myDeletedFiles = new ArrayList<FilePath>();
        this.myDeletedWithoutConfirmFiles = new ArrayList<FilePath>();
        this.myMovedFiles = new ArrayList<MovedFileInfo>();
        this.myProject = project;
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance(project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance(project);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        VirtualFileManager.getInstance().addVirtualFileListener(new MyVirtualFileListener(), this);
        project.getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)new MyCommandAdapter());
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance(this.myProject);
    }

    public void dispose() {
    }

    protected boolean isEventIgnored(@NotNull VirtualFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(2);
        }
        if (event.isFromRefresh()) {
            return true;
        }
        return !this.isUnderMyVcs(event.getFile());
    }

    private boolean isUnderMyVcs(@NotNull VirtualFile file) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(3);
        }
        return this.myVcsManager.getVcsFor(file) == this.myVcs && this.myVcsManager.isFileInContent(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    protected void executeAdd() {
        List<VirtualFile> addedFiles = this.acquireAddedFiles();
        LOG.debug("executeAdd. addedFiles: ", new Object[]{addedFiles});
        addedFiles.removeIf(this.myVcsFileListenerContextHelper::isAdditionIgnored);
        Map<VirtualFile, VirtualFile> copyFromMap = this.acquireCopiedFiles();
        if (!addedFiles.isEmpty()) {
            this.executeAdd(addedFiles, copyFromMap);
        }
    }

    @NotNull
    private Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
        HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
        this.myCopyFromMap.clear();
        HashMap<VirtualFile, VirtualFile> hashMap = copyFromMap;
        if (hashMap == null) {
            VcsVFSListener.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    private List<VirtualFile> acquireAddedFiles() {
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>(this.myAddedFiles);
        this.myAddedFiles.clear();
        ArrayList<VirtualFile> arrayList = addedFiles;
        if (arrayList == null) {
            VcsVFSListener.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(6);
        }
        if (copyFromMap == null) {
            VcsVFSListener.$$$reportNull$$$0(7);
        }
        LOG.debug("executeAdd. add-option: ", new Object[]{this.myAddOption.getValue(), ", files to add: ", addedFiles});
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
            Collection<VirtualFile> filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    private void addFileToDelete(@NotNull VirtualFile file) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(8);
        }
        if (file.isDirectory() && file instanceof NewVirtualFile && !this.isDirectoryVersioningSupported()) {
            for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                this.addFileToDelete(child);
            }
        } else {
            VcsDeleteType type = this.needConfirmDeletion(file);
            FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(file.getPath()), file.isDirectory());
            if (type == VcsDeleteType.CONFIRM) {
                this.myDeletedFiles.add(filePath2);
            } else if (type == VcsDeleteType.SILENT) {
                this.myDeletedWithoutConfirmFiles.add(filePath2);
            }
        }
    }

    protected void executeDelete() {
        ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        filesToDelete.removeIf(this.myVcsFileListenerContextHelper::isDeletionIgnored);
        deletedFiles.removeIf(this.myVcsFileListenerContextHelper::isDeletionIgnored);
        if (deletedFiles.isEmpty() && filesToDelete.isEmpty()) {
            return;
        }
        if (this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            if (this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || deletedFiles.isEmpty()) {
                filesToDelete.addAll(deletedFiles);
            } else {
                Collection<FilePath> filePaths = this.selectFilePathsToDelete(deletedFiles);
                if (filePaths != null) {
                    filesToDelete.addAll(filePaths);
                }
            }
        }
        this.performDeletion(filesToDelete);
    }

    @Nullable
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(9);
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
        return helper.selectFilePathsToProcess(deletedFiles, this.getDeleteTitle(), null, this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), this.myRemoveOption);
    }

    protected void beforeContentsChange(@NotNull VirtualFileEvent event, @NotNull VirtualFile file) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(10);
        }
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(11);
        }
    }

    protected void fileAdded(@NotNull VirtualFileEvent event, @NotNull VirtualFile file) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(12);
        }
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(13);
        }
        if (!(this.isEventIgnored(event) || this.myChangeListManager.isIgnoredFile(file) || !this.isDirectoryVersioningSupported() && file.isDirectory())) {
            LOG.debug("Adding [", new Object[]{file, "] to added files"});
            this.myAddedFiles.add(event.getFile());
        }
    }

    private void addFileToMove(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(14);
        }
        if (newParentPath == null) {
            VcsVFSListener.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            VcsVFSListener.$$$reportNull$$$0(16);
        }
        if (file.isDirectory() && !file.is(VFileProperty.SYMLINK) && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                }
            }
        } else {
            this.processMovedFile(file, newParentPath, newName);
        }
    }

    protected boolean filterOutUnknownFiles() {
        return true;
    }

    protected void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(17);
        }
        if (newParentPath == null) {
            VcsVFSListener.$$$reportNull$$$0(18);
        }
        if (newName == null) {
            VcsVFSListener.$$$reportNull$$$0(19);
        }
        FileStatus status = ChangeListManager.getInstance(this.myProject).getStatus(file);
        LOG.debug("Checking moved file ", new Object[]{file, "; status=", status});
        String newPath = newParentPath + "/" + newName;
        if (!(this.filterOutUnknownFiles() && status == FileStatus.UNKNOWN || status == FileStatus.IGNORED)) {
            MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> {
                if (file == null) {
                    VcsVFSListener.$$$reportNull$$$0(22);
                }
                return Comparing.equal((Object)((MovedFileInfo)info).myFile, (Object)file);
            });
            if (existingMovedFile != null) {
                LOG.debug("Reusing existing moved file [" + file + "] with new path [" + newPath + "]");
                existingMovedFile.myNewPath = newPath;
            } else {
                LOG.debug("Registered moved file ", new Object[]{file});
                this.myMovedFiles.add(new MovedFileInfo(file, newPath));
            }
        } else {
            this.myDeletedFiles.remove(VcsUtil.getFilePath(newPath));
        }
    }

    private void executeMoveRename() {
        ArrayList<MovedFileInfo> movedFiles = new ArrayList<MovedFileInfo>(this.myMovedFiles);
        LOG.debug("executeMoveRename " + movedFiles);
        this.myMovedFiles.clear();
        this.performMoveRename(movedFiles);
    }

    @NotNull
    protected VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(20);
        }
        VcsDeleteType vcsDeleteType = VcsDeleteType.CONFIRM;
        if (vcsDeleteType == null) {
            VcsVFSListener.$$$reportNull$$$0(21);
        }
        return vcsDeleteType;
    }

    @NotNull
    protected abstract String getAddTitle();

    @NotNull
    protected abstract String getSingleFileAddTitle();

    @NotNull
    protected abstract String getSingleFileAddPromptTemplate();

    protected abstract void performAdding(@NotNull Collection<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);

    @NotNull
    protected abstract String getDeleteTitle();

    protected abstract String getSingleFileDeleteTitle();

    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performDeletion(@NotNull List<FilePath> var1);

    protected abstract void performMoveRename(@NotNull List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentPath";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireCopiedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireAddedFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "needConfirmDeletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEventIgnored";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderMyVcs";
                break;
            }
            case 4: 
            case 5: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFileToDelete";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeContentsChange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fileAdded";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFileToMove";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMovedFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "needConfirmDeletion";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMovedFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCommandAdapter
    implements CommandListener {
        private int myCommandLevel;

        private MyCommandAdapter() {
        }

        @Override
        public void commandStarted(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandAdapter.$$$reportNull$$$0(0);
            }
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            ++this.myCommandLevel;
        }

        private void checkMovedAddedSourceBack() {
            if (VcsVFSListener.this.myAddedFiles.isEmpty() || VcsVFSListener.this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(VcsVFSListener.this.myAddedFiles.size());
            for (VirtualFile file : VcsVFSListener.this.myAddedFiles) {
                addedPaths.put(file.getPath(), file);
            }
            Iterator<MovedFileInfo> iterator = VcsVFSListener.this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                if (!addedPaths.containsKey(movedFile.myOldPath)) continue;
                iterator.remove();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                VcsVFSListener.this.myAddedFiles.remove(oldAdded);
                VcsVFSListener.this.myAddedFiles.add(movedFile.myFile);
                VcsVFSListener.this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        private void doNotDeleteAddedCopiedOrMovedFiles() {
            ArrayList<String> copiedAddedMoved = new ArrayList<String>();
            for (VirtualFile file : VcsVFSListener.this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file.getPath());
            }
            for (VirtualFile file : VcsVFSListener.this.myAddedFiles) {
                copiedAddedMoved.add(file.getPath());
            }
            for (MovedFileInfo movedFileInfo : VcsVFSListener.this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            VcsVFSListener.this.myDeletedFiles.removeIf(path2 -> copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)path2.getPath())));
            VcsVFSListener.this.myDeletedWithoutConfirmFiles.removeIf(path2 -> copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)path2.getPath())));
        }

        @Override
        public void commandFinished(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandAdapter.$$$reportNull$$$0(1);
            }
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            --this.myCommandLevel;
            if (!(this.myCommandLevel != 0 || VcsVFSListener.this.myAddedFiles.isEmpty() && VcsVFSListener.this.myDeletedFiles.isEmpty() && VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty() && VcsVFSListener.this.myMovedFiles.isEmpty())) {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
                if (!VcsVFSListener.this.myAddedFiles.isEmpty()) {
                    VcsVFSListener.this.executeAdd();
                    VcsVFSListener.this.myAddedFiles.clear();
                }
                if (!VcsVFSListener.this.myDeletedFiles.isEmpty() || !VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty()) {
                    VcsVFSListener.this.executeDelete();
                    VcsVFSListener.this.myDeletedFiles.clear();
                    VcsVFSListener.this.myDeletedWithoutConfirmFiles.clear();
                }
                if (!VcsVFSListener.this.myMovedFiles.isEmpty()) {
                    VcsVFSListener.this.executeMoveRename();
                    VcsVFSListener.this.myMovedFiles.clear();
                }
                if (!VcsVFSListener.this.myExceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance(VcsVFSListener.this.myProject).showErrors(VcsVFSListener.this.myExceptions, VcsVFSListener.this.myVcs.getDisplayName() + " operations errors");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$MyCommandAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        @Override
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            VirtualFile file = event.getFile();
            LOG.debug("fileCreated: ", new Object[]{file});
            VcsVFSListener.this.fileAdded(event, file);
        }

        @Override
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            if (VcsVFSListener.this.isEventIgnored(event) || VcsVFSListener.this.myChangeListManager.isIgnoredFile(event.getFile())) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOriginalFile());
            if (oldVcs == VcsVFSListener.this.myVcs) {
                VirtualFile parent = event.getFile().getParent();
                if (parent != null) {
                    VcsVFSListener.this.myAddedFiles.add(event.getFile());
                    VcsVFSListener.this.myCopyFromMap.put(event.getFile(), event.getOriginalFile());
                }
            } else {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        @Override
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            VirtualFile file = event.getFile();
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            if (!VcsVFSListener.this.myChangeListManager.isIgnoredFile(file)) {
                VcsVFSListener.this.addFileToDelete(file);
                return;
            }
            if (event.getFile().isDirectory()) {
                LinkedList list = new LinkedList();
                VcsUtil.collectFiles(file, list, true, VcsVFSListener.this.isDirectoryVersioningSupported());
                for (VirtualFile child : list) {
                    if (VcsVFSListener.this.myChangeListManager.isIgnoredFile(child)) continue;
                    VcsVFSListener.this.addFileToDelete(child);
                }
            }
        }

        @Override
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            VirtualFile file = event.getFile();
            AbstractVcs newVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getNewParent());
            LOG.debug("beforeFileMovement ", new Object[]{event, " into ", newVcs});
            if (newVcs == VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                VcsVFSListener.this.addFileToDelete(event.getFile());
            }
        }

        @Override
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOldParent());
            if (oldVcs != VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        @Override
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(5);
            }
            if (!VcsVFSListener.this.isEventIgnored(event) && event.getPropertyName().equalsIgnoreCase("name")) {
                VirtualFile file;
                VirtualFile parent;
                LOG.debug("before file rename ", new Object[]{event});
                String oldName = (String)event.getOldValue();
                String newName = (String)event.getNewValue();
                if (!Comparing.equal((String)oldName, (String)newName) && (parent = (file = event.getFile()).getParent()) != null) {
                    VcsVFSListener.this.addFileToMove(file, parent.getPath(), newName);
                }
            }
        }

        @Override
        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(6);
            }
            VirtualFile file = event.getFile();
            assert (!file.isDirectory());
            if (VcsVFSListener.this.isUnderMyVcs(file)) {
                VcsVFSListener.this.beforeContentsChange(event, file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class MovedFileInfo {
        @NotNull
        public final String myOldPath;
        @NotNull
        public String myNewPath;
        @NotNull
        private final VirtualFile myFile;

        MovedFileInfo(@NotNull VirtualFile file, @NotNull String newPath) {
            if (file == null) {
                MovedFileInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                MovedFileInfo.$$$reportNull$$$0(1);
            }
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }

        public String toString() {
            return String.format("MovedFileInfo{[%s] -> [%s]}", this.myOldPath, this.myNewPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/VcsVFSListener$MovedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

