/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.psi.tree.IElementType;
import org.angularjs.lang.lexer.AngularJSTokenTypes;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.parser.AngularJSMessageFormatParser;

public class AngularJSParser
extends JavaScriptParser<AngularJSExpressionParser, StatementParser, FunctionParser, JSPsiTypeParser> {
    public AngularJSParser(PsiBuilder builder) {
        super(JavaScriptSupportLoader.JAVASCRIPT_1_5, builder);
        this.myExpressionParser = new AngularJSExpressionParser();
        this.myStatementParser = new StatementParser<AngularJSParser>(this){

            protected void doParseStatement(boolean canHaveClasses) {
                IElementType nextToken;
                IElementType firstToken = this.builder.getTokenType();
                if (firstToken == JSTokenTypes.LBRACE) {
                    this.parseExpressionStatement();
                    this.checkForSemicolon();
                    return;
                }
                if (this.isIdentifierToken(firstToken) && (nextToken = this.builder.lookAhead(1)) == JSTokenTypes.IN_KEYWORD) {
                    this.parseInStatement();
                    return;
                }
                if (this.tryParseNgIfStatement()) {
                    return;
                }
                if (firstToken == JSTokenTypes.LET_KEYWORD) {
                    if (this.builder.lookAhead(2) != JSTokenTypes.EQ) {
                        this.parseNgForStatement();
                        return;
                    }
                    this.parseExpressionStatement();
                    return;
                }
                if (this.builder.getTokenType() == JSTokenTypes.LPAR && this.parseInStatement()) {
                    return;
                }
                super.doParseStatement(canHaveClasses);
            }

            private void parseNgForStatement() {
                PsiBuilder.Marker statement = this.builder.mark();
                if (!((AngularJSExpressionParser)AngularJSParser.this.getExpressionParser()).parseForExpression()) {
                    statement.drop();
                    return;
                }
                this.checkForSemicolon();
                statement.done(JSElementTypes.EXPRESSION_STATEMENT);
            }

            private boolean parseInStatement() {
                PsiBuilder.Marker statement = this.builder.mark();
                if (!((AngularJSExpressionParser)AngularJSParser.this.getExpressionParser()).parseInExpression()) {
                    statement.drop();
                    return false;
                }
                statement.done(JSElementTypes.EXPRESSION_STATEMENT);
                return true;
            }

            private boolean tryParseNgIfStatement() {
                PsiBuilder.Marker ngIf = this.builder.mark();
                ((AngularJSExpressionParser)AngularJSParser.this.getExpressionParser()).parseExpression();
                if (this.builder.getTokenType() != JSTokenTypes.SEMICOLON) {
                    ngIf.rollbackTo();
                    return false;
                }
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.LET_KEYWORD) {
                    ((AngularJSExpressionParser)AngularJSParser.this.getExpressionParser()).parseHashDefinition();
                    this.builder.advanceLexer();
                }
                if (this.builder.getTokenType() != AngularJSTokenTypes.THEN && this.builder.getTokenType() != JSTokenTypes.ELSE_KEYWORD) {
                    ngIf.rollbackTo();
                    return false;
                }
                this.parseBranch(AngularJSTokenTypes.THEN);
                if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                    this.builder.advanceLexer();
                }
                this.parseBranch(JSTokenTypes.ELSE_KEYWORD);
                ngIf.done(JSElementTypes.IF_STATEMENT);
                this.checkForSemicolon();
                if (this.builder.getTokenType() == JSTokenTypes.LET_KEYWORD) {
                    ((AngularJSExpressionParser)AngularJSParser.this.getExpressionParser()).parseHashDefinition();
                }
                return true;
            }

            private void parseBranch(IElementType branchType) {
                if (this.builder.getTokenType() == branchType) {
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                        AngularJSParser.this.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
                    } else {
                        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                    }
                }
            }
        };
    }

    public boolean isIdentifierName(IElementType firstToken) {
        return super.isIdentifierName(firstToken) || firstToken == AngularJSTokenTypes.THEN;
    }

    public void parseAngular(IElementType root) {
        PsiBuilder.Marker rootMarker = this.builder.mark();
        while (!this.builder.eof()) {
            this.getStatementParser().parseStatement();
        }
        rootMarker.done(root);
    }

    protected class AngularJSExpressionParser
    extends ExpressionParser<AngularJSParser> {
        private final AngularJSMessageFormatParser myAngularJSMessageFormatParser;

        public AngularJSExpressionParser() {
            super((JavaScriptParser)AngularJSParser.this);
            this.myAngularJSMessageFormatParser = new AngularJSMessageFormatParser((AngularJSParser)this.myJavaScriptParser);
        }

        protected boolean parseUnaryExpression() {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.OR) {
                this.builder.advanceLexer();
                if (!this.parseFilter()) {
                    this.builder.error("expected filter");
                }
                return true;
            }
            if (tokenType == AngularJSTokenTypes.ONE_TIME_BINDING) {
                PsiBuilder.Marker expr = this.builder.mark();
                this.builder.advanceLexer();
                if (!super.parseUnaryExpression()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done(JSElementTypes.PREFIX_EXPRESSION);
                return true;
            }
            return super.parseUnaryExpression();
        }

        public boolean parsePrimaryExpression() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == JSTokenTypes.STRING_LITERAL) {
                return this.parseStringLiteral(firstToken);
            }
            if (firstToken == JSTokenTypes.LET_KEYWORD) {
                this.parseHashDefinition();
                return true;
            }
            if (this.isIdentifierToken(firstToken)) {
                if (this.myAngularJSMessageFormatParser.parseMessage()) {
                    return true;
                }
                int cur = -1;
                IElementType prev = this.builder.rawLookup(-1);
                while (prev != null && ((PsiBuilderImpl)this.builder).whitespaceOrComment(prev)) {
                    prev = this.builder.rawLookup(--cur);
                }
                if (prev == JSTokenTypes.AS_KEYWORD) {
                    this.parseExplicitIdentifierWithError();
                    return true;
                }
            }
            return super.parsePrimaryExpression();
        }

        private void parseExplicitIdentifierWithError() {
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                PsiBuilder.Marker def = this.builder.mark();
                AngularJSParser.this.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
                def.done((IElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
        }

        protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
            return tokenType == AngularJSTokenTypes.ELVIS || tokenType == AngularJSTokenTypes.ASSERT_NOT_NULL || super.isReferenceQualifierSeparator(tokenType);
        }

        protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
            if (this.builder.getTokenType() == JSTokenTypes.OR) {
                return 10;
            }
            return super.getCurrentBinarySignPriority(allowIn, advance);
        }

        private boolean parseFilter() {
            PsiBuilder.Marker mark = this.builder.mark();
            AngularJSParser.this.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
            PsiBuilder.Marker arguments = null;
            while (this.builder.getTokenType() == JSTokenTypes.COLON) {
                arguments = arguments == null ? this.builder.mark() : arguments;
                this.builder.advanceLexer();
                if (super.parseUnaryExpression()) continue;
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            if (arguments != null) {
                arguments.done(JSElementTypes.ARGUMENT_LIST);
            }
            mark.done(AngularJSElementTypes.FILTER_EXPRESSION);
            return true;
        }

        private boolean parseStringLiteral(IElementType firstToken) {
            PsiBuilder.Marker mark = this.builder.mark();
            IElementType currentToken = firstToken;
            StringBuilder literal = new StringBuilder();
            while (currentToken == JSTokenTypes.STRING_LITERAL || currentToken == AngularJSTokenTypes.ESCAPE_SEQUENCE || currentToken == AngularJSTokenTypes.INVALID_ESCAPE_SEQUENCE) {
                literal.append(this.builder.getTokenText());
                this.builder.advanceLexer();
                currentToken = this.builder.getTokenType();
            }
            mark.done((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
            String errorMessage = AngularJSExpressionParser.validateLiteralText((String)literal.toString());
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }

        public boolean parseForExpression() {
            PsiBuilder.Marker expr = this.builder.mark();
            this.parseHashDefinition();
            if (this.builder.getTokenType() != JSTokenTypes.OF_KEYWORD) {
                expr.drop();
                return true;
            }
            this.builder.advanceLexer();
            this.parseExpression();
            if (this.builder.lookAhead(1) == AngularJSTokenTypes.TRACK_BY_KEYWORD) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSTokenTypes.COLON) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
                } else {
                    this.builder.advanceLexer();
                }
                this.parseExpression();
            }
            expr.done(AngularJSElementTypes.FOR_EXPRESSION);
            return true;
        }

        protected void parseHashDefinition() {
            PsiBuilder.Marker def = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.IDENTIFIER) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            } else {
                AngularJSParser.this.buildTokenElement((IElementType)JSStubElementTypes.VARIABLE);
            }
            def.done((IElementType)JSStubElementTypes.VAR_STATEMENT);
        }

        public boolean parseInExpression() {
            PsiBuilder.Marker expr = this.builder.mark();
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                PsiBuilder.Marker statement = this.builder.mark();
                AngularJSParser.this.buildTokenElement((IElementType)JSStubElementTypes.VARIABLE);
                statement.done((IElementType)JSStubElementTypes.VAR_STATEMENT);
            } else {
                PsiBuilder.Marker keyValue = this.builder.mark();
                this.parseKeyValue();
                if (this.builder.getTokenType() != JSTokenTypes.IN_KEYWORD) {
                    expr.rollbackTo();
                    return false;
                }
                keyValue.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
            }
            this.builder.advanceLexer();
            this.parseExpression();
            if (this.builder.getTokenType() == AngularJSTokenTypes.TRACK_BY_KEYWORD) {
                this.builder.advanceLexer();
                this.parseExpression();
            }
            expr.done(AngularJSElementTypes.REPEAT_EXPRESSION);
            return true;
        }

        private void parseKeyValue() {
            this.builder.advanceLexer();
            PsiBuilder.Marker comma = this.builder.mark();
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                AngularJSParser.this.buildTokenElement((IElementType)JSStubElementTypes.VARIABLE);
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma", (Object[])new Object[0]));
            }
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                AngularJSParser.this.buildTokenElement((IElementType)JSStubElementTypes.VARIABLE);
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            comma.done((IElementType)JSStubElementTypes.VAR_STATEMENT);
            if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            }
        }
    }
}

