/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomElementsInspection<T extends DomElement>
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementsInspection");
    private final Set<Class<? extends T>> myDomClasses;

    public DomElementsInspection(Class<? extends T> domClass, Class<? extends T> ... additionalClasses) {
        if (additionalClasses == null) {
            DomElementsInspection.$$$reportNull$$$0(0);
        }
        this.myDomClasses = new THashSet(Arrays.asList(additionalClasses));
        this.myDomClasses.add(domClass);
    }

    public void checkFileElement(DomFileElement<T> domFileElement, final DomElementAnnotationHolder holder) {
        final DomHighlightingHelper helper = DomElementAnnotationsManager.getInstance(domFileElement.getManager().getProject()).getHighlightingHelper();
        Consumer<DomElement> consumer = new Consumer<DomElement>(){

            public void consume(DomElement element) {
                DomElementsInspection.this.checkChildren(element, this);
                DomElementsInspection.this.checkDomElement(element, holder, helper);
            }
        };
        consumer.consume(domFileElement.getRootElement());
    }

    protected void checkChildren(DomElement element, Consumer<? super DomElement> visitor) {
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            for (DomElement domElement : DomUtil.getDefinedChildren(element, true, true)) {
                XmlElement element1 = domElement.getXmlElement();
                if (element1 == null) {
                    LOG.error("child=" + domElement + " of class " + domElement.getClass() + "; parent=" + element);
                }
                if (!element1.isPhysical()) continue;
                visitor.consume((Object)domElement);
            }
            for (AbstractDomChildrenDescription abstractDomChildrenDescription : element.getGenericInfo().getChildrenDescriptions()) {
                if (abstractDomChildrenDescription.getAnnotation(Required.class) == null) continue;
                for (DomElement domElement : abstractDomChildrenDescription.getValues(element)) {
                    if (DomUtil.hasXml(domElement)) continue;
                    visitor.consume((Object)domElement);
                }
            }
        }
    }

    public final Set<Class<? extends T>> getDomClasses() {
        return this.myDomClasses;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            DomElementsInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DomElementsInspection.$$$reportNull$$$0(2);
        }
        if (file instanceof XmlFile && (file.isPhysical() || ApplicationManager.getApplication().isUnitTestMode())) {
            for (Class<? extends T> clazz : this.myDomClasses) {
                DomFileElement<? extends T> fileElement = DomManager.getDomManager(file.getProject()).getFileElement((XmlFile)file, clazz);
                if (fileElement == null) continue;
                return this.checkDomFile(fileElement, manager, isOnTheFly);
            }
        }
        return null;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DomElementsInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    protected ProblemDescriptor[] checkDomFile(@NotNull DomFileElement<T> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomElementAnnotationsManager annotationsManager;
        List<DomElementProblemDescriptor> list;
        if (domFileElement == null) {
            DomElementsInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            DomElementsInspection.$$$reportNull$$$0(5);
        }
        if ((list = (annotationsManager = DomElementAnnotationsManager.getInstance(manager.getProject())).checkFileElement(domFileElement, this, isOnTheFly)).isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List problems = ContainerUtil.concat(list, s -> {
            if (manager == null) {
                DomElementsInspection.$$$reportNull$$$0(6);
            }
            return annotationsManager.createProblemDescriptors(manager, (DomElementProblemDescriptor)s);
        });
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        throw new UnsupportedOperationException("checkDomElement() is not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkDomFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkDomFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

