/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.EncryptionSupport;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0012\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/credentialStore/AesEncryptionSupport;", "Lcom/intellij/credentialStore/EncryptionSupport;", "key", "Ljava/security/Key;", "(Ljava/security/Key;)V", "decrypt", "", "data", "encrypt", "Companion", "intellij.platform.credentialStore"})
class AesEncryptionSupport
implements EncryptionSupport {
    private final Key key;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return AesEncryptionSupport.Companion.encrypt(data, this.key);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return AesEncryptionSupport.Companion.decrypt(data, this.key);
    }

    public AesEncryptionSupport(@NotNull Key key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.key = key;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/credentialStore/AesEncryptionSupport$Companion;", "", "()V", "decrypt", "", "data", "key", "Ljava/security/Key;", "encrypt", "message", "intellij.platform.credentialStore"})
    public static final class Companion {
        private final byte[] encrypt(byte[] message, Key key) {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, key);
            byte[] body = cipher.doFinal(message, 0, message.length);
            Cipher cipher2 = cipher;
            Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
            byte[] iv = cipher2.getIV();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4 + iv.length + body.length]);
            byteBuffer.putInt(iv.length);
            byteBuffer.put(iv);
            byteBuffer.put(body);
            byte[] byArray = byteBuffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteBuffer.array()");
            return byArray;
        }

        private final byte[] decrypt(byte[] data, Key key) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            int ivLength = byteBuffer.getInt();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, key, new IvParameterSpec(data, byteBuffer.position(), ivLength));
            int dataOffset = byteBuffer.position() + ivLength;
            byte[] byArray = cipher.doFinal(data, dataOffset, data.length - dataOffset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data, dat\u2026, data.size - dataOffset)");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

