/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.BasePasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0013\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0096\u0002J\u0018\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0*2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J\u001b\u0010.\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010&H\u0096\u0002J#\u0010.\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010&2\u0006\u0010/\u001a\u00020\u0012H\u0096\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R$\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0013\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00060"}, d2={"Lcom/intellij/ide/passwordSafe/impl/BasePasswordSafe;", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "provider", "Lcom/intellij/credentialStore/CredentialStore;", "(Lcom/intellij/credentialStore/PasswordSafeSettings;Lcom/intellij/credentialStore/CredentialStore;)V", "_currentProvider", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "value", "currentProvider", "getCurrentProvider$intellij_platform_credentialStore", "()Lcom/intellij/credentialStore/CredentialStore;", "setCurrentProvider$intellij_platform_credentialStore", "(Lcom/intellij/credentialStore/CredentialStore;)V", "currentProviderIfComputed", "getCurrentProviderIfComputed", "isMemoryOnly", "", "()Z", "isRememberPasswordByDefault", "setRememberPasswordByDefault", "(Z)V", "memoryHelperProvider", "Lkotlin/Lazy;", "getMemoryHelperProvider", "()Lkotlin/Lazy;", "getSettings", "()Lcom/intellij/credentialStore/PasswordSafeSettings;", "closeCurrentStore", "", "isSave", "isEvenMemoryOnly", "closeCurrentStore$intellij_platform_credentialStore", "createMasterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "createMasterKeyEncryptionSpec$intellij_platform_credentialStore", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getAsync", "Lorg/jetbrains/concurrency/Promise;", "isPasswordStoredOnlyInMemory", "credentials", "save", "set", "memoryOnly", "intellij.platform.credentialStore"})
public class BasePasswordSafe
extends PasswordSafe {
    private final SynchronizedClearableLazy<CredentialStore> _currentProvider;
    @NotNull
    private final Lazy<CredentialStore> memoryHelperProvider;
    @NotNull
    private final PasswordSafeSettings settings;

    public boolean isRememberPasswordByDefault() {
        return this.settings.getState().isRememberPasswordByDefault();
    }

    public void setRememberPasswordByDefault(boolean value) {
        this.settings.getState().setRememberPasswordByDefault(value);
    }

    @Nullable
    protected final CredentialStore getCurrentProviderIfComputed() {
        return this._currentProvider.isInitialized() ? this._currentProvider.getValue() : null;
    }

    @NotNull
    public final CredentialStore getCurrentProvider$intellij_platform_credentialStore() {
        return this._currentProvider.getValue();
    }

    public final void setCurrentProvider$intellij_platform_credentialStore(@NotNull CredentialStore value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._currentProvider.setValue(value);
    }

    public final void closeCurrentStore$intellij_platform_credentialStore(boolean isSave, boolean isEvenMemoryOnly) {
        CredentialStore credentialStore = this.getCurrentProviderIfComputed();
        if (credentialStore == null) {
            return;
        }
        CredentialStore store = credentialStore;
        if (isEvenMemoryOnly || !(store instanceof InMemoryCredentialStore)) {
            this._currentProvider.drop();
            if (isSave && store instanceof KeePassCredentialStore) {
                try {
                    ((KeePassCredentialStore)store).save(this.createMasterKeyEncryptionSpec$intellij_platform_credentialStore());
                }
                catch (Exception e) {
                    CredentialStoreKt.getLOG().warn((Throwable)e);
                }
            }
        }
    }

    @NotNull
    public final EncryptionSpec createMasterKeyEncryptionSpec$intellij_platform_credentialStore() {
        String pgpKey = this.settings.getState().getPgpKeyId();
        String string = pgpKey;
        return string == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey);
    }

    @NotNull
    protected final Lazy<CredentialStore> getMemoryHelperProvider() {
        return this.memoryHelperProvider;
    }

    public boolean isMemoryOnly() {
        return this.settings.getProviderType() == ProviderType.MEMORY_ONLY;
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Credentials value = this.getCurrentProvider$intellij_platform_credentialStore().get(attributes);
        if ((value == null || (charSequence = (CharSequence)value.getPassword()) == null || charSequence.length() == 0) && this.memoryHelperProvider.isInitialized()) {
            CharSequence it;
            Credentials credentials = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
            if (credentials != null && !CredentialAttributesKt.isEmpty((Credentials)(it = (charSequence = credentials)))) {
                return it;
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.getCurrentProvider$intellij_platform_credentialStore().set(attributes, credentials);
        if (attributes.isPasswordMemoryOnly()) {
            Credentials credentials2 = credentials;
            CharSequence charSequence = (CharSequence)(credentials2 != null ? credentials2.getPassword() : null);
            if (!(charSequence == null || charSequence.length() == 0)) {
                ((CredentialStore)this.memoryHelperProvider.getValue()).set(CredentialAttributesKt.toPasswordStoreable((CredentialAttributes)attributes), credentials);
                return;
            }
        }
        if (!this.memoryHelperProvider.isInitialized()) return;
        ((CredentialStore)this.memoryHelperProvider.getValue()).set(attributes, null);
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials, boolean memoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (memoryOnly) {
            ((CredentialStore)this.memoryHelperProvider.getValue()).set(CredentialAttributesKt.toPasswordStoreable((CredentialAttributes)attributes), credentials);
            this.getCurrentProvider$intellij_platform_credentialStore().set(attributes, null);
        } else {
            this.set(attributes, credentials);
        }
    }

    @NotNull
    public Promise<Credentials> getAsync(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, attributes){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ BasePasswordSafe this$0;
            final /* synthetic */ CredentialAttributes $attributes$inlined;
            {
                this.$promise = asyncPromise;
                this.this$0 = basePasswordSafe;
                this.$attributes$inlined = credentialAttributes;
            }

            public final void run() {
                Credentials credentials;
                try {
                    credentials = this.this$0.get(this.$attributes$inlined);
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Credentials result2 = credentials;
                this.$promise.setResult((Object)result2);
            }
        });
        return (Promise)promise$iv;
    }

    public void save() {
        CredentialStore credentialStore = this.getCurrentProviderIfComputed();
        if (!(credentialStore instanceof KeePassCredentialStore)) {
            credentialStore = null;
        }
        KeePassCredentialStore keePassCredentialStore = (KeePassCredentialStore)credentialStore;
        if (keePassCredentialStore == null) {
            return;
        }
        KeePassCredentialStore keePassCredentialStore2 = keePassCredentialStore;
        keePassCredentialStore2.save(this.createMasterKeyEncryptionSpec$intellij_platform_credentialStore());
    }

    public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes, @NotNull Credentials credentials) {
        CharSequence it;
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (this.isMemoryOnly() || (charSequence2 = (CharSequence)credentials.getPassword()) == null || charSequence2.length() == 0) {
            return true;
        }
        if (!this.memoryHelperProvider.isInitialized()) {
            return false;
        }
        Credentials credentials2 = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
        return credentials2 != null ? !((charSequence = (CharSequence)(it = (charSequence2 = credentials2)).getPassword()) == null || charSequence.length() == 0) : false;
    }

    @NotNull
    public final PasswordSafeSettings getSettings() {
        return this.settings;
    }

    @JvmOverloads
    public BasePasswordSafe(@NotNull PasswordSafeSettings settings, @Nullable CredentialStore provider) {
        block0: {
            CredentialStore credentialStore;
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            this.settings = settings;
            this._currentProvider = new SynchronizedClearableLazy((Function0)new Function0<CredentialStore>(this){
                final /* synthetic */ BasePasswordSafe this$0;

                @NotNull
                public final CredentialStore invoke() {
                    return PasswordSafeImplKt.access$computeProvider(this.this$0.getSettings());
                }
                {
                    this.this$0 = basePasswordSafe;
                    super(0);
                }
            });
            this.memoryHelperProvider = LazyKt.lazy((Function0)memoryHelperProvider.1.INSTANCE);
            CredentialStore credentialStore2 = provider;
            if (credentialStore2 == null) break block0;
            CredentialStore it = credentialStore = credentialStore2;
            this.setCurrentProvider$intellij_platform_credentialStore(it);
        }
    }

    @JvmOverloads
    public /* synthetic */ BasePasswordSafe(PasswordSafeSettings passwordSafeSettings, CredentialStore credentialStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            credentialStore = null;
        }
        this(passwordSafeSettings, credentialStore);
    }

    @JvmOverloads
    public BasePasswordSafe(@NotNull PasswordSafeSettings settings) {
        this(settings, null, 2, null);
    }
}

