/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.SourceRootIconProvider;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public final class TodoDirNode
extends PsiDirectoryNode {
    private final TodoTreeBuilder myBuilder;

    public TodoDirNode(Project project, @NotNull PsiDirectory directory, TodoTreeBuilder builder2) {
        if (directory == null) {
            TodoDirNode.$$$reportNull$$$0(0);
        }
        super(project, directory, ViewSettings.DEFAULT);
        this.myBuilder = builder2;
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            TodoDirNode.$$$reportNull$$$0(1);
        }
        super.updateImpl(data);
        int fileCount = this.getFileCount((PsiDirectory)this.getValue());
        if (this.getValue() == null || !((PsiDirectory)this.getValue()).isValid() || fileCount == 0) {
            this.setValue(null);
            return;
        }
        VirtualFile directory = ((PsiDirectory)this.getValue()).getVirtualFile();
        boolean isProjectRoot = !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(directory);
        String newName = isProjectRoot || this.getStructure().getIsFlattenPackages() ? ((PsiDirectory)this.getValue()).getVirtualFile().getPresentableUrl() : ((PsiDirectory)this.getValue()).getName();
        int todoItemCount = this.getTodoItemCount((PsiDirectory)this.getValue());
        data.setLocationString(IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{todoItemCount}));
        data.setPresentableText(newName);
    }

    @Override
    protected void setupIcon(PresentationData data, PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (ProjectRootsUtil.isModuleContentRoot(virtualFile, psiDirectory.getProject())) {
            data.setIcon(new SourceRootIconProvider.DirectoryProvider().getIcon((PsiElement)psiDirectory, 0));
        } else {
            super.setupIcon(data, psiDirectory);
        }
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return TodoTreeHelper.getInstance(this.getProject()).getDirectoryChildren((PsiDirectory)this.getValue(), this.myBuilder, this.getSettings().isFlattenPackages());
    }

    public int getFileCount(PsiDirectory directory) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(directory);
        int count = 0;
        try {
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                if (!this.getStructure().accept(psiFile)) continue;
                ++count;
            }
        }
        catch (IndexNotReadyException e) {
            return count;
        }
        return count;
    }

    public int getTodoItemCount(PsiDirectory directory) {
        if (TodoTreeHelper.getInstance(this.getProject()).skipDirectory(directory)) {
            return 0;
        }
        int count = 0;
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(directory);
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            count += this.getStructure().getTodoItemCount(psiFile);
        }
        return count;
    }

    @Override
    public int getWeight() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/todo/nodes/TodoDirNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

