/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class RemoteServerListConfigurableProvider
extends ConfigurableProvider {
    public boolean canCreateConfigurable() {
        List<ServerType<?>> serverTypes = RemoteServerListConfigurableProvider.getServerTypesInCloudsList();
        return !serverTypes.isEmpty();
    }

    public Configurable createConfigurable() {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), RemoteServerListConfigurableProvider.getServerTypesInCloudsList(), null);
    }

    @NotNull
    private static List<ServerType<?>> getServerTypesInCloudsList() {
        Application application = ApplicationManager.getApplication();
        Set excludedTypes = Arrays.stream(application.getExtensions(Configurable.APPLICATION_CONFIGURABLE)).flatMap(RemoteServerListConfigurableProvider::tryGetServerTypes).collect(Collectors.toSet());
        Object[] allServerTypes = (ServerType[])ServerType.EP_NAME.getExtensions();
        List list2 = ContainerUtil.filter((Object[])allServerTypes, t -> !excludedTypes.contains(t));
        if (list2 == null) {
            RemoteServerListConfigurableProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    private static Stream<ServerType<?>> tryGetServerTypes(@NotNull ConfigurableEP<?> ep) {
        UnnamedConfigurable configurable;
        Class type;
        if (ep == null) {
            RemoteServerListConfigurableProvider.$$$reportNull$$$0(1);
        }
        if ((type = ep.getConfigurableType()) != null && RemoteServerListConfigurable.class.isAssignableFrom(type) && (configurable = ep.createConfigurable()) instanceof RemoteServerListConfigurable) {
            Stream<ServerType<?>> stream = ((RemoteServerListConfigurable)configurable).getDisplayedServerTypes().stream();
            if (stream == null) {
                RemoteServerListConfigurableProvider.$$$reportNull$$$0(2);
            }
            return stream;
        }
        Stream<ServerType<?>> stream = Stream.empty();
        if (stream == null) {
            RemoteServerListConfigurableProvider.$$$reportNull$$$0(3);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurableProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerTypesInCloudsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurableProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetServerTypes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryGetServerTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

