/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.apacheConfig.psi.ACArgument;
import com.intellij.lang.apacheConfig.psi.ACDirective;
import com.intellij.lang.apacheConfig.psi.ACDirectiveBase;
import com.intellij.lang.apacheConfig.psi.ACElement;
import com.intellij.lang.apacheConfig.psi.ACPsiUtils;
import com.intellij.lang.apacheConfig.psi.ACSection;
import com.intellij.lang.apacheConfig.psi.schema.ACDirectiveIndex;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ACCompletionContributor
extends CompletionContributor {
    private static final String INTELLIJ_IDEA_RULEZZZ = "IntellijIdeaRulezzz";

    public ACCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)new ACElementPattern(ACDirective.class), new ACDirectiveCompletionProvider(ACDirectiveCompletionProvider.Context.DIRECTIVE));
        this.extend(CompletionType.BASIC, (ElementPattern)new ACElementPattern(ACSection.class).andNot((ElementPattern)PlatformPatterns.psiElement().inside(ACArgument.class)), new ACDirectiveCompletionProvider(ACDirectiveCompletionProvider.Context.SECTION));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(INTELLIJ_IDEA_RULEZZZ)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(ACArgument.class))).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"<"})), new ACDirectiveCompletionProvider(ACDirectiveCompletionProvider.Context.BOTH));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(INTELLIJ_IDEA_RULEZZZ)).inside((ElementPattern)new ACElementPattern(ACDirectiveBase.class, "IfModule", false)), new ACModuleNameCompletionProvider());
    }

    private static class ACModuleNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private ACModuleNameCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Set<String> modules;
            if (parameters == null) {
                ACModuleNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ACModuleNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                ACModuleNameCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((modules = ACDirectiveIndex.shared().getModules()) != null) {
                for (String module : modules) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)module));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/apacheConfig/completion/ACCompletionContributor$ACModuleNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ACElementPattern
    extends PsiElementPattern.Capture<ACElement> {
        @NotNull
        private final Class clazz;
        @Nullable
        private final String name;
        private final boolean myNamePos;

        ACElementPattern(Class clazz) {
            this(clazz, null, true);
        }

        ACElementPattern(@NotNull Class clazz, @Nullable String name, boolean namePos) {
            if (clazz == null) {
                ACElementPattern.$$$reportNull$$$0(0);
            }
            super(clazz);
            this.clazz = clazz;
            this.name = name;
            this.myNamePos = namePos;
        }

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            if (o instanceof PsiElement) {
                ACDirectiveBase directiveBase = ACPsiUtils.getDirectiveBase((PsiElement)o);
                return !(directiveBase == null || !this.clazz.isInstance((Object)directiveBase) || this.myNamePos && directiveBase.getNameElement() != o || this.name != null && !this.name.equals(directiveBase.getName()));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/apacheConfig/completion/ACCompletionContributor$ACElementPattern", "<init>"));
        }
    }

    private static class ACDirectiveCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final Context myContext;

        ACDirectiveCompletionProvider(Context context) {
            this.myContext = context;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                ACDirectiveCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ACDirectiveCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                ACDirectiveCompletionProvider.$$$reportNull$$$0(2);
            }
            Project project = parameters.getOriginalFile().getProject();
            ACDirectiveIndex index = ACDirectiveIndex.shared();
            for (String dirName : index.getAllDirectives().keySet()) {
                ACDirectiveIndex.DirectiveEntry resolve = index.resolve(dirName);
                boolean isSection = resolve.isSection();
                List<String> directiveContexts = resolve.getContext();
                if (!(this.myContext == Context.DIRECTIVE && !isSection || this.myContext == Context.SECTION && isSection) && this.myContext != Context.BOTH || !directiveContexts.contains("htaccess")) continue;
                String module = resolve.getModule();
                LookupElementBuilder lookupElement = LookupElementBuilder.create((String)dirName).withTypeText(module, true);
                if (isSection) {
                    lookupElement = lookupElement.withInsertHandler((InsertHandler)new SectionInsertHandler(this.myContext));
                }
                result.addElement((LookupElement)lookupElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/apacheConfig/completion/ACCompletionContributor$ACDirectiveCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class SectionInsertHandler
        extends BasicInsertHandler<LookupElement> {
            private final Context myContext;

            SectionInsertHandler(Context context) {
                this.myContext = context;
            }

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    SectionInsertHandler.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    SectionInsertHandler.$$$reportNull$$$0(1);
                }
                context.setAddCompletionChar(false);
                if (this.myContext != Context.SECTION) {
                    context.getEditor().getDocument().insertString(context.getStartOffset(), (CharSequence)"<");
                }
                context.getEditor().getDocument().insertString(context.getTailOffset(), (CharSequence)(" >\n</" + item.getLookupString() + ">"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/apacheConfig/completion/ACCompletionContributor$ACDirectiveCompletionProvider$SectionInsertHandler";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static enum Context {
            DIRECTIVE,
            SECTION,
            BOTH;

        }
    }
}

