/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.JavaCvsSrcBundle;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.connection.UnknownUserException;
import org.netbeans.lib.cvsclient.io.IStreamLogger;
import org.netbeans.lib.cvsclient.io.StreamUtilities;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class PServerConnection
implements IConnection {
    private final String userName;
    private final String encodedPassword;
    private final String repository;
    private final ConnectionSettings connectionSettings;
    private Socket socket;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    @NonNls
    private static final String ENCODED_PASSWORD_OUTPUT_MESSAGE = "@encodedPassword@";
    @NonNls
    private static final String SUCCESS_MESSAGE = "I LOVE YOU";
    @NonNls
    private static final String FAILED_MESSAGE = "I HATE YOU";

    public PServerConnection(ConnectionSettings connectionSettings, String userName, String encodedPassword, String repository) {
        BugLog.getInstance().assertNotNull(userName);
        BugLog.getInstance().assertNotNull(repository);
        BugLog.getInstance().assertTrue(connectionSettings.getConnectionTimeout() >= 0, "Timeout must be >= 0");
        this.userName = userName;
        this.encodedPassword = encodedPassword != null ? encodedPassword : "";
        this.repository = repository;
        this.connectionSettings = connectionSettings;
    }

    @Override
    public InputStream getInputStream() {
        return this.socketInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.socketOutputStream;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public void verify(IStreamLogger streamLogger) throws AuthenticationException {
        try {
            this.open(streamLogger);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void open(IStreamLogger streamLogger) throws AuthenticationException {
        this.openConnection("BEGIN AUTH REQUEST", "END AUTH REQUEST", streamLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.socketInputStream != null) {
            try {
                this.socketInputStream.close();
            }
            catch (IOException ex) {
                BugLog.getInstance().showException(ex);
            }
            finally {
                this.socketInputStream = null;
            }
        }
        if (this.socketOutputStream != null) {
            try {
                this.socketOutputStream.close();
            }
            catch (IOException ex) {
                BugLog.getInstance().showException(ex);
            }
            finally {
                this.socketOutputStream = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    private void openConnection(@NonNls String preamble, @NonNls String postamble, IStreamLogger streamLogger) throws AuthenticationException {
        boolean error = true;
        try {
            this.createSocket();
            this.socketOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.socketInputStream = new BufferedInputStream(this.socket.getInputStream());
            OutputStream loggingOutputStream = streamLogger.createLoggingOutputStream(this.socketOutputStream);
            InputStream loggingInputStream = streamLogger.createLoggingInputStream(this.socketInputStream);
            PServerConnection.writeLn(loggingOutputStream, preamble, "US-ASCII");
            PServerConnection.writeLn(loggingOutputStream, this.repository);
            PServerConnection.writeLn(loggingOutputStream, this.userName);
            PServerConnection.writeLn(this.socketOutputStream, this.encodedPassword, "US-ASCII");
            PServerConnection.writeLn(streamLogger.getOutputLogStream(), ENCODED_PASSWORD_OUTPUT_MESSAGE);
            PServerConnection.writeLn(loggingOutputStream, postamble, "US-ASCII");
            loggingOutputStream.flush();
            String response = new StreamUtilities(null).readLine(loggingInputStream);
            if (response.equals(SUCCESS_MESSAGE)) {
                error = false;
                return;
            }
            try {
                if (response.length() == 0) {
                    throw new AuthenticationException(JavaCvsSrcBundle.message("no.response.from.server.error.message", new Object[0]));
                }
                if (response.equals(FAILED_MESSAGE)) {
                    throw new UnknownUserException(JavaCvsSrcBundle.message("wrong.password.or.unknown.user.error.message", new Object[0]));
                }
                response = PServerConnection.removePrefix(response, "error ");
                response = PServerConnection.removePrefix(response, "E ");
                throw new AuthenticationException(JavaCvsSrcBundle.message("authentication.failed.error.message", response));
            }
            catch (ConnectException ex) {
                throw new AuthenticationException(JavaCvsSrcBundle.message("cannot.connect.to.host.error.message", this.connectionSettings.getHostName()), ex);
            }
            catch (NoRouteToHostException ex) {
                throw new AuthenticationException(JavaCvsSrcBundle.message("no.route.to.host.error.message", this.connectionSettings.getHostName()), ex);
            }
            catch (UnknownHostException ex) {
                throw new AuthenticationException(JavaCvsSrcBundle.message("unknown.host.error.message", this.connectionSettings.getHostName()), ex);
            }
            catch (SocketTimeoutException ex) {
                throw new AuthenticationException(JavaCvsSrcBundle.message("timeout.error.message", this.connectionSettings.getHostName()), ex);
            }
            catch (IOException ex) {
                throw new AuthenticationException(JavaCvsSrcBundle.message("i.o.error.while.connecting.to.host.error.message", this.connectionSettings.getHostName()), ex);
            }
        }
        finally {
            if (error) {
                this.close();
            }
        }
    }

    private static void writeLn(OutputStream outputStream, String line, @NonNls String encoding) throws IOException {
        String line1 = line + "\n";
        outputStream.write(line1.getBytes(encoding));
    }

    private static void writeLn(OutputStream outputStream, String line) throws IOException {
        String line1 = line + "\n";
        outputStream.write(line1.getBytes());
    }

    private void createSocket() throws IOException {
        if (this.connectionSettings.isUseProxy()) {
            this.socket = this.connectionSettings.createProxyTransport();
        } else {
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(this.connectionSettings.getHostName(), this.connectionSettings.getPort());
            this.socket.connect(address, this.connectionSettings.getConnectionTimeout());
            this.socket.setSoTimeout(this.connectionSettings.getConnectionTimeout());
        }
    }

    private static String removePrefix(String response, @NonNls String prefix) {
        if (response.length() > prefix.length() && response.startsWith(prefix)) {
            return response.substring(prefix.length());
        }
        return response;
    }
}

