/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFilterExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathStepImpl
extends XPathElementImpl
implements XPathStep {
    public XPathStepImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        if (this.getNode().getElementType() == XPath2ElementTypes.CONTEXT_ITEM) {
            XPathExpression expression;
            PsiElement filter;
            XPathPredicate predicate = (XPathPredicate)PsiTreeUtil.getParentOfType((PsiElement)this, XPathPredicate.class);
            if (predicate != null && (filter = predicate.getParent()) instanceof XPathFilterExpression && (expression = ((XPathFilterExpression)filter).getExpression()) != null) {
                XPathType type = expression.getType();
                XPathType xPathType = type instanceof XPath2SequenceType ? ((XPath2SequenceType)type).getType() : type;
                if (xPathType == null) {
                    XPathStepImpl.$$$reportNull$$$0(0);
                }
                return xPathType;
            }
            XPath2Type xPath2Type = XPath2Type.SEQUENCE;
            if (xPath2Type == null) {
                XPathStepImpl.$$$reportNull$$$0(1);
            }
            return xPath2Type;
        }
        XPathExpression step = this.getStep();
        if (step != null) {
            XPathType xPathType = step.getType();
            if (xPathType == null) {
                XPathStepImpl.$$$reportNull$$$0(2);
            }
            return xPathType;
        }
        XPathType xPathType = XPathType.NODESET;
        if (xPathType == null) {
            XPathStepImpl.$$$reportNull$$$0(3);
        }
        return xPathType;
    }

    @Override
    public XPathAxisSpecifier getAxisSpecifier() {
        ASTNode node = this.getNode().findChildByType(XPathElementTypes.AXIS_SPECIFIER);
        if (node != null) {
            return (XPathAxisSpecifier)node.getPsi();
        }
        return this.findFromXPath2FilterExpr(XPathElementTypes.AXIS_SPECIFIER, XPathAxisSpecifier.class);
    }

    @Nullable
    private <T extends PsiElement> T findFromXPath2FilterExpr(IElementType type, Class<T> clazz) {
        XPathExpression f = this.getPreviousStep();
        if (f instanceof XPathFilterExpression) {
            ASTNode node = f.getNode();
            ASTNode child = node.findChildByType(type);
            return (T)(child != null ? child.getPsi(clazz) : null);
        }
        return null;
    }

    @Override
    public XPathNodeTest getNodeTest() {
        ASTNode node = this.getNode().findChildByType(XPathElementTypes.NODE_TEST);
        if (node != null) {
            return (XPathNodeTest)node.getPsi(XPathNodeTest.class);
        }
        return this.findFromXPath2FilterExpr(XPathElementTypes.NODE_TEST, XPathNodeTest.class);
    }

    @Override
    @NotNull
    public XPathPredicate[] getPredicates() {
        ASTNode[] nodes = this.getNode().getChildren(XPathElementTypes.PREDICATES);
        XPathPredicate[] predicates = new XPathPredicate[nodes.length];
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = (XPathPredicate)nodes[i].getPsi();
        }
        if (predicates == null) {
            XPathStepImpl.$$$reportNull$$$0(4);
        }
        return predicates;
    }

    @Override
    @Nullable
    public XPathExpression getPreviousStep() {
        XPathExpression[] nodes = (XPathExpression[])this.findChildrenByClass(XPathExpression.class);
        if (nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    @Override
    @Nullable
    public XPathExpression getStep() {
        XPathExpression[] nodes = (XPathExpression[])this.findChildrenByClass(XPathExpression.class);
        if (nodes.length > 1) {
            return nodes[1];
        }
        return null;
    }

    @Override
    public boolean isAbsolute() {
        return this.getPreviousStep() == null && this.getNode().getChildren(XPathTokenTypes.PATH_OPS).length > 0;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathStep(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/psi/impl/XPathStepImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredicates";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

