/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic;

import com.projectlibre1.util.ClassLoaderUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IconManager {
    protected static ClassLoader classLoader = ClassLoaderUtils.getLocalClassLoader();
    protected static HashMap icons = new HashMap();
    protected static HashMap ribbonIcons = new HashMap();
    private static final String[] iconPackages = new String[]{"com/projectlibre1/pm/graphic/images/", "com/projectlibre1/pm/graphic/images/big/", "com/projectlibre1/pm/graphic/images/ribbon/", "toolbarButtonGraphics/general/", "toolbarButtonGraphics/text/", "toolbarButtonGraphics/table/", "toolbarButtonGraphics/navigation/", "toolbarButtonGraphics/development/", "toolbarButtonGraphics/media/"};

    private static URL getIconResource(String string) {
        URL uRL = null;
        for (int i = 0; i < iconPackages.length && (uRL = classLoader.getResource(iconPackages[i] + string)) == null; ++i) {
        }
        return uRL;
    }

    public static URL getURL(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/projectlibre1/pm/graphic/images", Locale.getDefault(), classLoader);
        String string2 = resourceBundle.getString(string);
        if (string2 == null) {
            return null;
        }
        return IconManager.getIconResource(string2);
    }

    public static ImageIcon getIcon(String string) {
        ImageIcon imageIcon = (ImageIcon)icons.get(string);
        if (imageIcon == null) {
            URL uRL = IconManager.getURL(string);
            if (uRL == null) {
                return null;
            }
            imageIcon = new ImageIcon(uRL);
            icons.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static ResizableIcon getRibbonIcon(String string) {
        return IconManager.getRibbonIcon(string, 48, 48);
    }

    public static ResizableIcon getRibbonIcon(String string, int n, int n2) {
        ImageWrapperResizableIcon imageWrapperResizableIcon = null;
        URL uRL = IconManager.getURL(string);
        if (uRL == null) {
            return null;
        }
        imageWrapperResizableIcon = ImageWrapperResizableIcon.getIcon(uRL, new Dimension(n, n2));
        return imageWrapperResizableIcon;
    }

    public static ImageIcon getHalfSizedIcon(String string) {
        ImageIcon imageIcon = IconManager.getIcon(string);
        Image image = imageIcon.getImage();
        Image image2 = image.getScaledInstance(imageIcon.getIconWidth() / 2, imageIcon.getIconHeight() / 2, 1);
        return new ImageIcon(image2);
    }

    public static Image getImage(String string) {
        ImageIcon imageIcon = IconManager.getIcon(string);
        if (imageIcon == null) {
            return null;
        }
        return imageIcon.getImage();
    }
}

