/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet;

import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.util.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;

public class SpreadSheetPopupMenu
extends JPopupMenu {
    protected int row;
    protected int col;
    protected final SpreadSheet spreadSheet;
    private Map menuActionMap = null;

    public SpreadSheetPopupMenu(SpreadSheet spreadSheet) {
        this.spreadSheet = spreadSheet;
        this.setBorder(new BevelBorder(0));
        SpreadSheet spreadSheet2 = spreadSheet;
        String[] stringArray = spreadSheet.getActionList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(spreadSheet.prepareAction(stringArray[i]), this.getMenuAction(stringArray[i]));
            }
        }
    }

    protected String getMenuAction(String string) {
        if (this.menuActionMap == null) {
            this.menuActionMap = new HashMap();
            if (Environment.isNewLook()) {
                this.menuActionMap.put("InsertTask", "menu24.insertTask");
                this.menuActionMap.put("Delete", "menu24.delete");
                this.menuActionMap.put("Indent", "menu24.indent");
                this.menuActionMap.put("Outdent", "menu24.outdent");
                this.menuActionMap.put("Cut", "menu24.cut");
                this.menuActionMap.put("Copy", "menu24.copy");
                this.menuActionMap.put("Paste", "menu24.paste");
                this.menuActionMap.put("Expand", "menu24.expand");
                this.menuActionMap.put("Collapse", "menu24.collapse");
            } else {
                this.menuActionMap.put("InsertTask", "menu.insertTask");
                this.menuActionMap.put("Delete", "menu.delete");
                this.menuActionMap.put("Indent", "menu.rightArrow");
                this.menuActionMap.put("Outdent", "menu.leftArrow");
                this.menuActionMap.put("Cut", "menu.cut");
                this.menuActionMap.put("Copy", "menu.copy");
                this.menuActionMap.put("Paste", "menu.paste");
                this.menuActionMap.put("Expand", "menu.expand");
                this.menuActionMap.put("Collapse", "menu.collapse");
            }
        }
        return (String)this.menuActionMap.get(string);
    }

    private void add(Action action, String string) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setIcon(IconManager.getIcon(string));
        this.add(jMenuItem);
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int n) {
        this.col = n;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }
}

