/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.EmbeddedCssProvider;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.Nullable;

public class CssSupportLoader {
    private static final ExtensionPointName<EmbeddedCssProvider> EP = ExtensionPointName.create((String)"com.intellij.css.embeddedCssProvider");

    private CssSupportLoader() {
    }

    public static boolean isInFileThatSupportsEmbeddedCss(@Nullable PsiElement psiElement) {
        FileViewProvider fileViewProvider;
        if (psiElement == null) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider2 = fileViewProvider = containingFile != null ? containingFile.getViewProvider() : null;
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            containingFile = fileViewProvider.getPsi(((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage());
        } else if (fileViewProvider instanceof FreeThreadedFileViewProvider) {
            containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile(psiElement);
        }
        return containingFile != null && CssSupportLoader.isCssEnabledFileType(containingFile);
    }

    public static boolean isInFileThatSupportsCssResolve(PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            containingFile = fileViewProvider.getPsi(((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage());
        }
        return containingFile != null && CssSupportLoader.isCssEnabledFileType(containingFile);
    }

    private static boolean isCssEnabledFileType(PsiFile file) {
        Language language = file.getLanguage();
        if (language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE) {
            return true;
        }
        if (file.getFileType().getName().equals("JSPX")) {
            return true;
        }
        for (EmbeddedCssProvider provider : EP.getExtensionList()) {
            if (!provider.enableEmbeddedCssFor(language)) continue;
            return true;
        }
        return false;
    }
}

