/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.intentions.JSSplitDeclarationIntention;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationAndInitializationIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = JSVariablesWithInitializerPredicate.PREDICATE;
        if (jSElementPredicate == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSVarStatement varStatement;
        if (element == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(1);
        }
        JSVarStatement jSVarStatement = varStatement = element instanceof JSVarStatement ? (JSVarStatement)element : null;
        assert (varStatement != null);
        String declarationText = JSSplitDeclarationAndInitializationIntention.getDeclarationStatementText(varStatement, (Condition<? super JSVariable>)Conditions.alwaysTrue());
        String statementTail = JSCodeStyleSettings.getSemicolon((PsiElement)element) + "\n";
        List initializations = ContainerUtil.map((Object[])varStatement.getDeclarations(), declaration -> {
            if (declaration instanceof JSDestructuringElement) {
                boolean isDestructuringObject = ((JSDestructuringElement)declaration).getTarget() instanceof JSDestructuringObject;
                return (isDestructuringObject ? "(" + declaration.getText() + ")" : declaration.getText()) + statementTail;
            }
            if (declaration.getInitializer() != null) {
                return declaration.getName() + '=' + declaration.getInitializer().getText() + statementTail;
            }
            return declaration.getText();
        });
        this.doReplacement(declarationText, initializations, varStatement);
    }

    @NotNull
    public static String getDeclarationStatementText(@NotNull JSVarStatement varStatement, Condition<? super JSVariable> toRemoveInitializer) {
        if (varStatement == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(2);
        }
        String varStatementKeyword = varStatement.getVarKeyword().getText();
        String lineTail = JSCodeStyleSettings.getSemicolon((PsiElement)varStatement) + "\n";
        StringBuilder declarationBuffer = new StringBuilder();
        for (JSVariable variable : varStatement.getVariables()) {
            String docCommentText;
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment((JSVariable)variable, (JSVarStatement)varStatement);
            String string = docCommentText = docComment != null ? docComment.getText() : "";
            if (declarationBuffer.length() == 0) {
                declarationBuffer.append(docCommentText);
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n");
                }
                declarationBuffer.append(varStatementKeyword).append(" ");
            } else {
                declarationBuffer.append(",");
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n").append(docCommentText).append("\n");
                }
            }
            if (toRemoveInitializer.value((Object)variable)) {
                declarationBuffer.append(variable.getName());
                String typeString = JSSplitDeclarationAndInitializationIntention.getTypeString((JSInitializerOwner)variable);
                if (typeString == null) continue;
                declarationBuffer.append(":").append(typeString);
                continue;
            }
            declarationBuffer.append(variable.getText());
        }
        declarationBuffer.append(lineTail);
        String string = declarationBuffer.toString();
        if (string == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static String getTypeString(@NotNull JSInitializerOwner element) {
        JSType result;
        if (element == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.hasFeature((PsiElement)element, (JSLanguageFeature)JSLanguageFeature.TYPES)) {
            return null;
        }
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSElement)element);
        if (type != null) {
            return type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)element);
        if (holder == null) {
            return null;
        }
        JSType jSType = holder.isECMA4 ? JSResolveUtil.getQualifiedExpressionJSType((JSExpression)element.getInitializer(), (PsiFile)element.getContainingFile()) : (result = element instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)element).getType() : JSResolveUtil.getExpressionJSType((JSExpression)element.getInitializer()));
        if (result == null) {
            return null;
        }
        return JSVariablesWithInitializerPredicate.formatType((JSType)result, (PsiElement)element);
    }

    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSStatement newVarStatement = (JSStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)declarations, (PsiElement)oldVarStatement, JSStatement.class);
        newVarStatement = oldVarStatement.replace(newVarStatement);
        int startOffset = newVarStatement.getTextOffset();
        JSStatement anchor = newVarStatement;
        for (String initialization : initializations) {
            anchor = anchor.addStatementAfter((JSStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)initialization, (PsiElement)anchor, JSStatement.class));
        }
        int endOffset = anchor.getTextRange().getEndOffset();
        CodeStyleManager.getInstance((Project)newVarStatement.getProject()).reformatText(newVarStatement.getContainingFile(), startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationStatementText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationStatementText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

