/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.AnnotationProviderEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.annotation.AnnotationInfo;
import org.jetbrains.idea.perforce.application.annotation.PerforceFileAnnotation;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceAnnotationProvider
implements AnnotationProviderEx {
    private final Project myProject;
    private final PerforceRunner myRunner;

    public PerforceAnnotationProvider(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(0);
        }
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        FileAnnotation fileAnnotation = this.doAnnotate(file, ChangesUtil.getCommittedPath((Project)this.myProject, (FilePath)filePath), -1L);
        if (fileAnnotation == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(1);
        }
        return fileAnnotation;
    }

    @NotNull
    private FileAnnotation doAnnotate(VirtualFile vFile, FilePath file, long changeNumber) throws VcsException {
        P4Connection connection = PerforceSettings.getSettings(this.myProject).getConnectionForFile(vFile);
        if (connection == null) {
            throw new VcsException("Invalid Perforce settings");
        }
        FileAnnotation fileAnnotation = this.doAnnotate(changeNumber, connection, P4File.create(file).getEscapedPath()).createAnnotation(vFile);
        if (fileAnnotation == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private AnnotationPrecursor doAnnotate(long changeNumber, P4Connection connection, @NotNull String string) throws VcsException {
        void path;
        Object[] fileLog;
        P4Revision p4Revision;
        if (string == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(3);
        }
        String pathAtRevision = (p4Revision = (P4Revision)ContainerUtil.find((Object[])(fileLog = this.myRunner.filelog(connection, (String)path, true)), p4Revision1 -> p4Revision1.getChangeNumber() == changeNumber)) == null ? path : p4Revision.getDepotPath();
        long revision = p4Revision == null ? -1L : p4Revision.getRevisionNumber();
        AnnotationInfo annotationInfo = this.myRunner.annotate(connection, pathAtRevision, revision);
        AnnotationPrecursor annotationPrecursor = new AnnotationPrecursor(annotationInfo, (P4Revision[])fileLog, revision, p4Revision, connection);
        if (annotationPrecursor == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(4);
        }
        return annotationPrecursor;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, VcsFileRevision revision) throws VcsException {
        if (file == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(5);
        }
        PerforceVcsRevisionNumber number = (PerforceVcsRevisionNumber)revision.getRevisionNumber();
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        FileAnnotation fileAnnotation = this.doAnnotate(file, filePath, number.getChangeNumber());
        if (fileAnnotation == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(6);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber number) throws VcsException {
        PerforceSettings settings;
        P4Connection connection;
        if (path == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(7);
        }
        if (number == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(8);
        }
        if ((connection = (settings = PerforceSettings.getSettings(this.myProject)).getConnectionForFile(path.getIOFile())) == null) {
            throw new VcsException("Cannot find Perforce root for " + path);
        }
        long changeNumber = ((PerforceVcsRevisionNumber)number).getChangeNumber();
        AnnotationPrecursor precursor = this.doAnnotate(changeNumber, connection, ((PerforceVcsRevisionNumber)number).getDepotPath());
        if (precursor.p4Revision == null) {
            throw new VcsException("Cannot find Perforce revision " + changeNumber + " for " + path);
        }
        PerforceFileRevision revision = new PerforceFileRevision(precursor.p4Revision, connection, this.myProject);
        FileAnnotation fileAnnotation = precursor.createAnnotation((VirtualFile)new VcsVirtualFile(path.getPath(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance()));
        if (fileAnnotation == null) {
            PerforceAnnotationProvider.$$$reportNull$$$0(9);
        }
        return fileAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doAnnotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AnnotationPrecursor {
        final AnnotationInfo info;
        final P4Revision[] fileLog;
        final long changeNumber;
        @Nullable
        final P4Revision p4Revision;
        final P4Connection connection;

        AnnotationPrecursor(AnnotationInfo info, P4Revision[] fileLog, @Nullable long changeNumber, P4Revision p4Revision, P4Connection connection) {
            this.info = info;
            this.fileLog = fileLog;
            this.changeNumber = changeNumber;
            this.p4Revision = p4Revision;
            this.connection = connection;
        }

        FileAnnotation createAnnotation(@NotNull VirtualFile file) {
            if (file == null) {
                AnnotationPrecursor.$$$reportNull$$$0(0);
            }
            return new PerforceFileAnnotation(this.info, file, this.fileLog, PerforceAnnotationProvider.this.myProject, this.connection, this.changeNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider$AnnotationPrecursor", "createAnnotation"));
        }
    }
}

