/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.Semaphore;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.ConnectionStreams;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.ResponseService;
import org.netbeans.lib.cvsclient.ValidRequestsExpectedException;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.IGlobalOptions;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileDetails;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.io.IStreamLogger;
import org.netbeans.lib.cvsclient.progress.sending.IRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CaseRequest;
import org.netbeans.lib.cvsclient.request.GlobalOptionRequest;
import org.netbeans.lib.cvsclient.request.GzipStreamRequest;
import org.netbeans.lib.cvsclient.request.IRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.SetRequest;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.request.ValidResponsesRequest;
import org.netbeans.lib.cvsclient.response.DefaultResponseHandler;
import org.netbeans.lib.cvsclient.response.IResponseHandler;
import org.netbeans.lib.cvsclient.response.ResponseParser;
import org.netbeans.lib.cvsclient.response.ValidRequestsResponseHandler;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class RequestProcessor
implements IRequestProcessor {
    private final IGlobalOptions globalOptions;
    private final IClientEnvironment clientEnvironment;
    private final ResponseService responseServices;
    private final IStreamLogger streamLogger;
    private final ICvsCommandStopper commandStopper;
    @NonNls
    private static final String OS_NAME_PROPERTY = "os.name";
    @NonNls
    private static final String WINDOWS_PREFIX = "Windows";
    @NonNls
    private static final String CASE_REQUEST = "Case";
    @NonNls
    private static final String CVS_PASS_ENV_VARS_PROPERTY = "cvs.pass.env.vars";
    @NonNls
    private static final String NO = "no";
    private final long myTimeout;

    public RequestProcessor(IClientEnvironment clientEnvironment, IGlobalOptions globalOptions, IEventSender eventSender, IStreamLogger streamLogger, ICvsCommandStopper commandStopper) {
        this(clientEnvironment, globalOptions, eventSender, streamLogger, commandStopper, -1L);
    }

    public RequestProcessor(IClientEnvironment clientEnvironment, IGlobalOptions globalOptions, IEventSender eventSender, IStreamLogger streamLogger, ICvsCommandStopper commandStopper, long timeout) {
        this.myTimeout = timeout;
        BugLog.getInstance().assertNotNull(globalOptions);
        BugLog.getInstance().assertNotNull(clientEnvironment);
        BugLog.getInstance().assertNotNull(eventSender);
        BugLog.getInstance().assertNotNull(streamLogger);
        BugLog.getInstance().assertNotNull(commandStopper);
        this.globalOptions = globalOptions;
        this.clientEnvironment = clientEnvironment;
        this.responseServices = new ResponseService(eventSender);
        this.streamLogger = streamLogger;
        this.commandStopper = commandStopper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRequests(Requests requests, IRequestsProgressHandler communicationProgressHandler) throws CommandException, AuthenticationException {
        try (IConnectionStreams connectionStreams = this.openConnection();){
            boolean bl = this.processRequests(requests, connectionStreams, communicationProgressHandler);
            return bl;
        }
    }

    private IConnectionStreams openConnection() throws CommandException, AuthenticationException {
        this.clientEnvironment.getConnection().open(this.streamLogger);
        ConnectionStreams connectionStreams = new ConnectionStreams(this.clientEnvironment.getConnection(), this.streamLogger, this.clientEnvironment.getCharset());
        boolean exception = true;
        try {
            this.updateValidRequests(connectionStreams);
            this.sendRequest(new RootRequest(this.clientEnvironment.getConnection().getRepository()), connectionStreams);
            this.sendSetRequests(this.globalOptions, connectionStreams);
            if (this.globalOptions.isUseGzip() && this.isValidRequest("Gzip-stream")) {
                this.sendRequest(new GzipStreamRequest(), connectionStreams);
                connectionStreams.setGzipped();
            }
            this.sendRequest(new ValidResponsesRequest(), connectionStreams);
            this.sendRequest(new UseUnchangedRequest(), connectionStreams);
            this.sendGlobalOptionRequests(this.globalOptions, connectionStreams);
            if (System.getProperty(OS_NAME_PROPERTY).startsWith(WINDOWS_PREFIX) && this.isValidRequest(CASE_REQUEST)) {
                this.sendRequest(new CaseRequest(), connectionStreams);
            }
            exception = false;
            ConnectionStreams connectionStreams2 = connectionStreams;
            return connectionStreams2;
        }
        catch (IOException ex) {
            BugLog.getInstance().showException(ex);
            throw new IOCommandException(ex);
        }
        finally {
            if (exception) {
                connectionStreams.close();
            }
        }
    }

    private void sendSetRequests(IGlobalOptions globalOptions, ConnectionStreams connectionStreams) throws CommandAbortedException, IOException {
        Map<String, String> envVariables = globalOptions.getEnvVariables();
        if (envVariables == null) {
            return;
        }
        for (String varName : envVariables.keySet()) {
            String varValue = envVariables.get(varName);
            this.sendRequest(new SetRequest(varName, varValue), connectionStreams);
        }
    }

    private boolean processRequests(Requests requests, IConnectionStreams connectionStreams, IRequestsProgressHandler communicationProgressHandler) throws CommandException {
        BugLog.getInstance().assertNotNull(requests);
        DirectProcessRequestHelper helper = new DirectProcessRequestHelper();
        return helper.processRequests(requests, connectionStreams, communicationProgressHandler);
    }

    private void sendRequests(Requests requests, IConnectionStreams connectionStreams, IRequestsProgressHandler communicationProgressHandler) throws CommandAbortedException, IOException {
        for (IRequest request : requests.getRequests()) {
            this.sendRequest(request, connectionStreams);
            FileDetails fileDetails = request.getFileForTransmission();
            if (fileDetails != null) {
                this.sendFile(fileDetails, connectionStreams);
            }
            communicationProgressHandler.requestSent(request);
        }
    }

    private void updateValidRequests(IConnectionStreams connectionStreams) throws CommandException, IOException {
        this.sendRequest(new ValidRequestsRequest(), connectionStreams);
        connectionStreams.flushForReading();
        this.handleResponses(connectionStreams, new ValidRequestsResponseHandler());
        if (this.responseServices.getValidRequests() == null) {
            throw new ValidRequestsExpectedException();
        }
    }

    private void sendGlobalOptionRequests(IGlobalOptions globalOptions, IConnectionStreams connectionStreams) throws CommandAbortedException, IOException {
        if (!this.isValidRequest("Global_option")) {
            return;
        }
        if (globalOptions.isCheckedOutFilesReadOnly()) {
            this.sendRequest(new GlobalOptionRequest("-r"), connectionStreams);
        }
        if (globalOptions.isDoNoChanges()) {
            this.sendRequest(new GlobalOptionRequest("-n"), connectionStreams);
        }
        if (globalOptions.isNoHistoryLogging()) {
            this.sendRequest(new GlobalOptionRequest("-l"), connectionStreams);
        }
        if (globalOptions.isSomeQuiet()) {
            this.sendRequest(new GlobalOptionRequest("-q"), connectionStreams);
        }
    }

    private boolean isValidRequest(String request) {
        return this.responseServices.getValidRequests().indexOf(request) >= 0;
    }

    private void sendRequest(IRequest request, IConnectionStreams connectionStreams) throws CommandAbortedException, IOException {
        this.checkCanceled();
        connectionStreams.getLoggedWriter().write(request.getRequestString());
    }

    private void checkCanceled() throws CommandAbortedException {
        if (this.commandStopper.isAborted()) {
            throw new CommandAbortedException();
        }
    }

    private boolean handleResponses(IConnectionStreams connectionStreams, IResponseHandler responseHandler) throws CommandException, IOException {
        ResponseParser responseParser = new ResponseParser(responseHandler, this.clientEnvironment.getCharset());
        StringBuilder responseBuffer = new StringBuilder(32);
        while (true) {
            RequestProcessor.readResponse(connectionStreams.getLoggedReader(), responseBuffer);
            this.checkCanceled();
            if (responseBuffer.length() == 0) {
                return false;
            }
            Boolean result = responseParser.processResponse(responseBuffer.toString(), connectionStreams, this.responseServices, this.clientEnvironment);
            if (result != null) {
                return result;
            }
            this.checkCanceled();
        }
    }

    private static void readResponse(Reader reader, StringBuilder responseBuffer) throws IOException {
        responseBuffer.setLength(0);
        int chr = reader.read();
        while (chr >= 0 && chr != 10 && chr != 32) {
            responseBuffer.append((char)chr);
            chr = reader.read();
        }
    }

    private void sendFile(FileDetails fileDetails, IConnectionStreams connectionStreams) throws IOException {
        FileObject fileObject = fileDetails.getFileObject();
        if (fileDetails.isBinary()) {
            this.clientEnvironment.getLocalFileReader().transmitBinaryFile(fileObject, connectionStreams, this.clientEnvironment.getCvsFileSystem());
        } else {
            this.clientEnvironment.getLocalFileReader().transmitTextFile(fileObject, connectionStreams, this.clientEnvironment.getCvsFileSystem());
        }
    }

    private class DirectProcessRequestHelper
    extends ProcessRequestsHelper {
        private DirectProcessRequestHelper() {
        }

        @Override
        protected void before() {
        }

        @Override
        protected void callRunnable(Runnable runnable) {
            runnable.run();
        }

        @Override
        protected void afterInRunnable() {
        }

        @Override
        protected void after() {
        }
    }

    private class TimedOutProcessRequestHelper
    extends ProcessRequestsHelper {
        private final Semaphore mySemaphore;
        private Future<?> myFuture;

        private TimedOutProcessRequestHelper() {
            this.mySemaphore = new Semaphore();
        }

        @Override
        protected void before() {
            this.mySemaphore.down();
        }

        @Override
        protected void callRunnable(Runnable runnable) {
            this.myFuture = ConcurrencyUtil.newSingleThreadExecutor((String)"CVS request").submit(runnable);
            long tOut = RequestProcessor.this.myTimeout < 20000L ? 20000L : RequestProcessor.this.myTimeout;
            while (true) {
                this.mySemaphore.waitFor(tOut);
                if (this.myFuture.isDone() || this.myFuture.isCancelled() || !RequestProcessor.this.commandStopper.isAlive()) break;
                RequestProcessor.this.commandStopper.resetAlive();
            }
        }

        @Override
        protected void afterInRunnable() {
            this.mySemaphore.up();
        }

        @Override
        protected void after() throws CommandException {
            if (!(this.myFuture.isDone() || this.myFuture.isCancelled() || RequestProcessor.this.commandStopper.isAlive())) {
                this.myFuture.cancel(true);
                throw new CommandException(new CommandAbortedException(), "Command execution timed out");
            }
        }
    }

    private abstract class ProcessRequestsHelper {
        protected IOException myIOException;
        protected CommandException myCommandException;
        protected boolean myResult;

        private ProcessRequestsHelper() {
        }

        protected abstract void before();

        protected abstract void callRunnable(Runnable var1);

        protected abstract void afterInRunnable();

        protected abstract void after() throws CommandException;

        public boolean processRequests(Requests requests, IConnectionStreams connectionStreams, IRequestsProgressHandler communicationProgressHandler) throws CommandException {
            Runnable runnable = () -> {
                try {
                    RequestProcessor.this.checkCanceled();
                    RequestProcessor.this.sendRequests(requests, connectionStreams, communicationProgressHandler);
                    RequestProcessor.this.checkCanceled();
                    RequestProcessor.this.sendRequest(requests.getResponseExpectingRequest(), connectionStreams);
                    connectionStreams.flushForReading();
                    this.myResult = RequestProcessor.this.handleResponses(connectionStreams, new DefaultResponseHandler());
                }
                catch (IOException e) {
                    this.myIOException = e;
                }
                catch (CommandException e) {
                    this.myCommandException = e;
                }
                finally {
                    this.afterInRunnable();
                }
            };
            this.before();
            this.callRunnable(runnable);
            if (this.myIOException != null) {
                throw new IOCommandException(this.myIOException);
            }
            if (this.myCommandException != null) {
                throw this.myCommandException;
            }
            this.after();
            return this.myResult;
        }
    }
}

