/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.request;

import com.intellij.util.text.SyncDateFormat;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.request.AbstractRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class NotifyRequest
extends AbstractRequest {
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("EEE MMM dd hh:mm:ss yyyy z", Locale.US));
    private static final String HOST_NAME;
    @NonNls
    private static final String DATE_FORMAT_STR = "EEE MMM dd hh:mm:ss yyyy z";
    private final String request;

    public NotifyRequest(FileObject fileObject, String path, String command, String parameters) {
        BugLog.getInstance().assertNotNull(fileObject);
        StringBuilder buffer = new StringBuilder();
        buffer.append("Notify ");
        buffer.append(fileObject.getName());
        buffer.append('\n');
        buffer.append(command);
        buffer.append('\t');
        buffer.append(DATE_FORMAT.format(new Date()));
        buffer.append('\t');
        buffer.append(HOST_NAME);
        buffer.append('\t');
        buffer.append(path);
        buffer.append('\t');
        buffer.append(parameters);
        buffer.append('\n');
        this.request = buffer.toString();
    }

    @Override
    public String getRequestString() {
        return this.request;
    }

    static {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HOST_NAME = hostName;
    }
}

