/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentConfiguration
extends DeploymentConfigurationBase<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerDeploymentConfiguration.class);
    @NonNls
    private static final String HOST_CONFIG_PROPERTY = "HostConfig";
    @NonNls
    private static final String PORT_BINDINGS_PROPERTY = "PortBindings";
    @NonNls
    private static final String HOST_PORT_PROPERTY = "HostPort";
    private String mySourceFilePath;
    private String myContextFolderPath;
    private boolean myBuildOnly;
    private String myImageTag;
    private String myContainerName;
    private String myJSONFilePath;
    private Integer myDebugPort;
    private String myEntrypoint;
    private String myCommand;
    private List<DockerPortBindingImpl> myPortBindings = new ArrayList<DockerPortBindingImpl>();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = new ArrayList<DockerLinkImpl>();
    private List<DockerVolumeBindingImpl> myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
    private List<DockerEnvVarImpl> myEnvVars = new ArrayList<DockerEnvVarImpl>();
    private List<DockerEnvVarImpl> myBuildArgs = new ArrayList<DockerEnvVarImpl>();
    private String myRunCliOptions;
    private String myBuildCliOptions;
    private boolean myLinksExpanded = false;
    private boolean myVolumeBindingsExpanded = false;
    private boolean myEnvVarsExpanded = false;
    private boolean myPortBindingsExpanded = false;
    private List<String> mySecondarySourceFiles = new ArrayList<String>();
    private List<String> myServices = new ArrayList<String>();

    public String getImageTag() {
        return this.myImageTag;
    }

    public void setImageTag(String imageTag) {
        this.myImageTag = StringUtil.trim((String)imageTag);
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public void setContainerName(String containerName) {
        this.myContainerName = StringUtil.trim((String)containerName);
    }

    public String getSourceFilePath() {
        return this.mySourceFilePath;
    }

    public void setSourceFilePath(String path) {
        this.mySourceFilePath = path;
    }

    public String getJSONFilePath() {
        return this.myJSONFilePath;
    }

    public void setJSONFilePath(String JSONFilePath) {
        this.myJSONFilePath = JSONFilePath;
    }

    @OptionTag(value="commandLineOptions")
    public String getRunCliOptions() {
        return this.myRunCliOptions;
    }

    public void setRunCliOptions(String runCliOptions) {
        this.myRunCliOptions = runCliOptions;
    }

    public String getBuildCliOptions() {
        return this.myBuildCliOptions;
    }

    public void setBuildCliOptions(String buildCliOptions) {
        this.myBuildCliOptions = buildCliOptions;
    }

    @Transient
    public String getSystemDependentJSONFilePath() {
        return FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)this.getJSONFilePath()));
    }

    @Transient
    public void setSystemDependentJSONFilePath(String JSONFilePath) {
        this.setJSONFilePath(FileUtil.toSystemIndependentName((String)JSONFilePath));
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    public String getContextFolderPath() {
        return this.myContextFolderPath;
    }

    public void setContextFolderPath(String path) {
        this.myContextFolderPath = path;
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource, Project project) throws RuntimeConfigurationException {
        assert (deploymentSource != null);
        assert (project != null);
        if (deploymentSource.getType() instanceof DockerSingletonDeploymentSourceType) {
            DockerSingletonDeploymentSourceType typeImpl = (DockerSingletonDeploymentSourceType)deploymentSource.getType();
            typeImpl.checkDeploymentConfiguration(project, this);
        }
        if (this.myDebugPort != null && !this.hasDebugPortForwarding(project)) {
            throw new RuntimeConfigurationWarning("Debug port forwarding not found", () -> this.addDebugPortForwarding(project));
        }
    }

    private boolean hasDebugPortForwarding(Project project) {
        return this.getRemoteDebugPort(project) != null;
    }

    public String getRemoteDebugPort(Project project) {
        if (StringUtil.isEmpty((String)this.myJSONFilePath)) {
            return null;
        }
        try {
            JsonObject root = this.loadContainerConfig(project);
            JsonProperty property = new DebugConfigChecker(){

                @Override
                protected JsonProperty createProperty(JsonObject parent, String propertyName) throws CheckException {
                    throw new CheckException("Property not found: " + propertyName);
                }

                @Override
                protected JsonProperty createPortBinding(JsonObject parent, String port) throws CheckException {
                    throw new CheckException("Port binding not found");
                }
            }.check(root);
            return (String)StringUtil.split((String)property.getName(), (String)"/").get(0);
        }
        catch (CheckException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private void addDebugPortForwarding(final Project project) {
        try {
            if (StringUtil.isEmpty((String)this.myJSONFilePath)) {
                FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Container Settings", "Select path to save container settings with debug port forwarding.", new String[]{"json"});
                FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
                VirtualFileWrapper fileWrapper = saverDialog.save(project.getBaseDir(), "container_settings.json");
                if (fileWrapper == null) {
                    return;
                }
                File file2 = fileWrapper.getFile();
                DockerDeploymentConfiguration.createJSONFile(file2);
                this.setSystemDependentJSONFilePath(file2.getAbsolutePath());
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                try {
                    JsonObject root;
                    try {
                        root = this.loadContainerConfig(project);
                    }
                    catch (CheckException e) {
                        DockerDeploymentConfiguration.createJSONFile(new File(this.getSystemDependentJSONFilePath()));
                        root = this.loadContainerConfig(project);
                    }
                    new DebugConfigChecker(){

                        @Override
                        protected JsonProperty createProperty(JsonObject parent, String propertyName) throws CheckException {
                            return DockerDeploymentConfiguration.addProperty(project, parent, propertyName, "{}");
                        }

                        @Override
                        protected JsonProperty createPortBinding(JsonObject parent, String port) throws CheckException {
                            return DockerDeploymentConfiguration.addProperty(project, parent, port + "/tcp", "[{ \"HostIp\": \"0.0.0.0\", \"HostPort\": \"" + port + "\" }]");
                        }
                    }.check(root);
                }
                catch (CheckException e) {
                    LOG.warn(e.getMessage());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static JsonProperty addProperty(Project project, JsonObject parent, String propertyName, String propertyValue) throws CheckException {
        JsonElementGenerator generator = new JsonElementGenerator(project);
        JsonProperty property = generator.createProperty(propertyName, propertyValue);
        List list = parent.getPropertyList();
        if (list.isEmpty()) {
            JsonProperty result = (parent = (JsonObject)parent.replace((PsiElement)generator.createObject(property.getText()))).findProperty(propertyName);
            if (result == null) {
                throw new CheckException("Created property not found: " + propertyName);
            }
            return result;
        }
        JsonProperty anchor = (JsonProperty)list.get(list.size() - 1);
        PsiElement comma = parent.addAfter(generator.createComma(), (PsiElement)anchor);
        return (JsonProperty)parent.addAfter((PsiElement)property, comma);
    }

    private static void createJSONFile(File file2) throws IOException {
        FileUtil.writeToFile((File)file2, (String)"{}");
    }

    private JsonObject loadContainerConfig(Project project) throws CheckException {
        JsonObject result = this.doLoadContainerConfig(project);
        if (result == null) {
            throw new CheckException("Unable to load container settings");
        }
        return result;
    }

    private JsonObject doLoadContainerConfig(Project project) {
        VirtualFile virtualJSONFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSystemDependentJSONFilePath());
        if (virtualJSONFile == null) {
            return null;
        }
        PsiFile psiJSONFile = PsiManager.getInstance((Project)project).findFile(virtualJSONFile);
        if (psiJSONFile == null) {
            return null;
        }
        return (JsonObject)ContainerUtil.getFirstItem((List)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiJSONFile, JsonObject.class));
    }

    public String getEntrypoint() {
        return this.myEntrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.myEntrypoint = entrypoint;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public void setCommand(String command) {
        this.myCommand = command;
    }

    @AbstractCollection
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = new ArrayList<DockerPortBindingImpl>();
        }
        return this.myPortBindings;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = portBindings;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    @AbstractCollection
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = new ArrayList<DockerLinkImpl>();
        }
        return this.myLinks;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = links;
    }

    @AbstractCollection
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
        }
        return this.myVolumeBindings;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings) {
        this.myVolumeBindings = volumeBindings;
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myEnvVars;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = envVars;
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getBuildArgs() {
        if (this.myBuildArgs == null) {
            this.myBuildArgs = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myBuildArgs;
    }

    public void setBuildArgs(List<DockerEnvVarImpl> buildArgs) {
        this.myBuildArgs = buildArgs;
    }

    public boolean isLinksExpanded() {
        return this.myLinksExpanded;
    }

    public void setLinksExpanded(boolean linksExpanded) {
        this.myLinksExpanded = linksExpanded;
    }

    public boolean isVolumeBindingsExpanded() {
        return this.myVolumeBindingsExpanded;
    }

    public void setVolumeBindingsExpanded(boolean volumeBindingsExpanded) {
        this.myVolumeBindingsExpanded = volumeBindingsExpanded;
    }

    public boolean isEnvVarsExpanded() {
        return this.myEnvVarsExpanded;
    }

    public void setEnvVarsExpanded(boolean envVarsExpanded) {
        this.myEnvVarsExpanded = envVarsExpanded;
    }

    public boolean isPortBindingsExpanded() {
        return this.myPortBindingsExpanded;
    }

    public void setPortBindingsExpanded(boolean portBindingsExpanded) {
        this.myPortBindingsExpanded = portBindingsExpanded;
    }

    public boolean isBuildOnly() {
        return this.myBuildOnly;
    }

    public void setBuildOnly(boolean buildOnly) {
        this.myBuildOnly = buildOnly;
    }

    @AbstractCollection
    public List<String> getSecondarySourceFiles() {
        if (this.mySecondarySourceFiles == null) {
            this.mySecondarySourceFiles = new ArrayList<String>();
        }
        return this.mySecondarySourceFiles;
    }

    public void setSecondarySourceFiles(List<String> files) {
        this.mySecondarySourceFiles = files;
    }

    @AbstractCollection
    @NotNull
    public List<String> getServices() {
        if (this.myServices == null) {
            this.myServices = new ArrayList<String>();
        }
        List<String> list = this.myServices;
        if (list == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setServices(List<String> services) {
        this.myServices = services;
    }

    public void loadState(@NotNull DockerDeploymentConfiguration state) {
        if (state == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(1);
        }
        String mayBePresetPath = this.getSourceFilePath();
        super.loadState((DeploymentConfigurationBase)state);
        if (mayBePresetPath != null && this.getSourceFilePath() == null) {
            this.setSourceFilePath(mayBePresetPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class ProjectAwareHelper {
        public static void setSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @Nullable File sourceFile) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(1);
            }
            String path = sourceFile == null ? null : ProjectAwareHelper.getPathToStore(project, sourceFile);
            model.setSourceFilePath(path);
        }

        public static void setManySourceFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @NotNull List<File> sourceFiles) {
            List<Object> secondaryFiles;
            File mainFile;
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(2);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(3);
            }
            if (sourceFiles == null) {
                ProjectAwareHelper.$$$reportNull$$$0(4);
            }
            if (sourceFiles.isEmpty()) {
                mainFile = null;
                secondaryFiles = Collections.emptyList();
            } else {
                mainFile = sourceFiles.get(0);
                secondaryFiles = sourceFiles.subList(1, sourceFiles.size());
            }
            ProjectAwareHelper.setSourceFile(project, model, mainFile);
            List<String> storableSecondaries = secondaryFiles.stream().map(file2 -> {
                if (project == null) {
                    ProjectAwareHelper.$$$reportNull$$$0(23);
                }
                return ProjectAwareHelper.getPathToStore(project, file2);
            }).collect(Collectors.toList());
            model.setSecondarySourceFiles(storableSecondaries);
        }

        public static void setSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @Nullable VirtualFile sourceFile) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(5);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(6);
            }
            String path = sourceFile == null ? null : ProjectAwareHelper.getPathToStore(project, sourceFile);
            model.setSourceFilePath(path);
        }

        public static boolean isForSameFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @NotNull VirtualFile file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(7);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(8);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(9);
            }
            return FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (File)ProjectAwareHelper.getSourceFile(project, model));
        }

        @Nullable
        public static File getSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(10);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(11);
            }
            return ProjectAwareHelper.getSourceFile(project, model.getSourceFilePath());
        }

        @Nullable
        public static File getSourceFile(@NotNull Project project, @Nullable String path) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(12);
            }
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return null;
            }
            File file2 = new File(path = FileUtil.toSystemDependentName((String)path));
            return file2.isAbsolute() ? file2 : new File(project.getBasePath(), file2.getPath());
        }

        @NotNull
        public static String getPathToStore(@NotNull Project project, @NotNull VirtualFile file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(13);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(14);
            }
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            String string = ProjectAwareHelper.getPathToStore(project, ioFile);
            if (string == null) {
                ProjectAwareHelper.$$$reportNull$$$0(15);
            }
            return string;
        }

        @NotNull
        public static String getPathToStore(@NotNull Project project, @NotNull File file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(16);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(17);
            }
            String projectRelativePath = ProjectAwareHelper.makeProjectRelative(project, file2);
            String string = FileUtil.toSystemIndependentName((String)projectRelativePath);
            if (string == null) {
                ProjectAwareHelper.$$$reportNull$$$0(18);
            }
            return string;
        }

        @NotNull
        private static String makeProjectRelative(@NotNull Project project, @NotNull File ioFile) {
            String relativePath;
            String basePath;
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(19);
            }
            if (ioFile == null) {
                ProjectAwareHelper.$$$reportNull$$$0(20);
            }
            if ((basePath = project.getBasePath()) != null && (relativePath = FileUtil.getRelativePath((File)new File(basePath), (File)ioFile)) != null) {
                String string = relativePath;
                if (string == null) {
                    ProjectAwareHelper.$$$reportNull$$$0(21);
                }
                return string;
            }
            String string = ioFile.getAbsolutePath();
            if (string == null) {
                ProjectAwareHelper.$$$reportNull$$$0(22);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFiles";
                    break;
                }
                case 9: 
                case 14: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/DockerDeploymentConfiguration$ProjectAwareHelper";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ioFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/DockerDeploymentConfiguration$ProjectAwareHelper";
                    break;
                }
                case 15: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathToStore";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeProjectRelative";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setSourceFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setManySourceFiles";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isForSameFile";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getSourceFile";
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathToStore";
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: {
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "makeProjectRelative";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setManySourceFiles$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CheckException
    extends Exception {
        private final String myMessage;

        CheckException(String message) {
            this.myMessage = message;
        }

        @Override
        public String getMessage() {
            return this.myMessage;
        }
    }

    private abstract class DebugConfigChecker {
        private DebugConfigChecker() {
        }

        public JsonProperty check(JsonObject root) throws CheckException {
            String port = String.valueOf(DockerDeploymentConfiguration.this.myDebugPort);
            JsonObject hostConfigValue = this.getPropertyValue(root, DockerDeploymentConfiguration.HOST_CONFIG_PROPERTY);
            JsonObject portBindingsValue = this.getPropertyValue(hostConfigValue, DockerDeploymentConfiguration.PORT_BINDINGS_PROPERTY);
            for (JsonProperty property : portBindingsValue.getPropertyList()) {
                JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)property.getValue(), JsonArray.class);
                if (array == null) continue;
                for (JsonValue portBindingsArrayValue : array.getValueList()) {
                    JsonStringLiteral hostPortValue;
                    JsonProperty hostPort;
                    if (!(portBindingsArrayValue instanceof JsonObject) || (hostPort = ((JsonObject)portBindingsArrayValue).findProperty(DockerDeploymentConfiguration.HOST_PORT_PROPERTY)) == null || (hostPortValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)hostPort.getValue(), JsonStringLiteral.class)) == null || !StringUtil.equals((CharSequence)port, (CharSequence)hostPortValue.getValue())) continue;
                    return property;
                }
            }
            this.createPortBinding(portBindingsValue, port);
            return null;
        }

        private JsonObject getPropertyValue(JsonObject parent, String propertyName) throws CheckException {
            JsonObject result;
            JsonProperty property = parent.findProperty(propertyName);
            if (property == null) {
                property = this.createProperty(parent, propertyName);
            }
            if ((result = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) {
                throw new CheckException("Property value is expected to be an Object: " + propertyName);
            }
            return result;
        }

        protected abstract JsonProperty createProperty(JsonObject var1, String var2) throws CheckException;

        protected abstract JsonProperty createPortBinding(JsonObject var1, String var2) throws CheckException;
    }
}

