/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BundledPluginsLister
extends ApplicationStarterEx {
    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return "listBundledPlugins";
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        try {
            OutputStream out;
            if (args.length == 2) {
                File outFile = new File(args[1]);
                File parentFile = outFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                out = new FileOutputStream(outFile);
            } else {
                out = System.out;
            }
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out, CharsetToolkit.UTF8_CHARSET));){
                IdeaPluginDescriptor[] plugins2 = PluginManagerCore.getPlugins();
                List<String> modules = Arrays.stream(plugins2).filter(IdeaPluginDescriptorImpl.class::isInstance).filter(plugin -> ((IdeaPluginDescriptorImpl)plugin).getModules() != null).flatMap(plugin -> ((IdeaPluginDescriptorImpl)plugin).getModules().stream()).sorted().collect(Collectors.toList());
                List<String> pluginIds = Arrays.stream(plugins2).map(plugin -> plugin.getPluginId().getIdString()).sorted().collect(Collectors.toList());
                writer.beginObject();
                BundledPluginsLister.writeList(writer, "modules", modules);
                BundledPluginsLister.writeList(writer, "plugins", pluginIds);
                writer.endObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void writeList(JsonWriter writer, String name, List<String> elements) throws IOException {
        writer.name(name).beginArray();
        for (String module : elements) {
            writer.value(module);
        }
        writer.endArray();
    }
}

