/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditValueDialog
extends DialogWrapper {
    private final JPanel myComponent;
    private final TypePeer<Object> myTypePeer;

    public EditValueDialog(@NotNull Component parent, @NotNull String optionTitle, @NotNull JSHintOption option, @Nullable Object optionValue) {
        if (parent == null) {
            EditValueDialog.$$$reportNull$$$0(0);
        }
        if (optionTitle == null) {
            EditValueDialog.$$$reportNull$$$0(1);
        }
        if (option == null) {
            EditValueDialog.$$$reportNull$$$0(2);
        }
        super(parent, false);
        this.myTypePeer = EditValueDialog.createTypePeer(option);
        this.myTypePeer.setValue(optionValue);
        this.myComponent = EditValueDialog.createComponent(optionTitle, this.myTypePeer);
        this.myComponent.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        this.setTitle("Set '" + option.getKey() + "' Option");
        this.setOKButtonText("Set");
        this.init();
    }

    @NotNull
    private static TypePeer<?> createTypePeer(@NotNull JSHintOption option) {
        if (option == null) {
            EditValueDialog.$$$reportNull$$$0(3);
        }
        if (OptionTypes.isIntegerOption(option)) {
            IntegerTypePeer integerTypePeer = new IntegerTypePeer();
            if (integerTypePeer == null) {
                EditValueDialog.$$$reportNull$$$0(4);
            }
            return integerTypePeer;
        }
        if (OptionTypes.isStringOption(option)) {
            StringTypePeer stringTypePeer = new StringTypePeer();
            if (stringTypePeer == null) {
                EditValueDialog.$$$reportNull$$$0(5);
            }
            return stringTypePeer;
        }
        if (OptionTypes.isEnumOption(option)) {
            OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
            EnumTypePeer enumTypePeer = new EnumTypePeer(enumType);
            if (enumTypePeer == null) {
                EditValueDialog.$$$reportNull$$$0(6);
            }
            return enumTypePeer;
        }
        throw new RuntimeException("Unexpected option type: " + option.getType());
    }

    @NotNull
    private static <T> JPanel createComponent(@NotNull String optionTitle, @NotNull TypePeer<T> typePeer) {
        if (optionTitle == null) {
            EditValueDialog.$$$reportNull$$$0(7);
        }
        if (typePeer == null) {
            EditValueDialog.$$$reportNull$$$0(8);
        }
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        String labelLocation = typePeer.isHorizontallyStacked() ? "West" : "North";
        panel.add((Component)new JLabel(optionTitle + ":"), labelLocation);
        panel.add((Component)typePeer.getComponent(), "Center");
        if (typePeer instanceof IntegerTypePeer) {
            JLabel hintLabel = new JLabel("Clear field to disable", 4);
            hintLabel.setFont(UIUtil.getTitledBorderFont());
            panel.add((Component)SwingHelper.newVerticalPanel((float)1.0f, (Component[])new Component[]{Box.createVerticalStrut(5), hintLabel}), "South");
        }
        if (typePeer.isHorizontallyStacked()) {
            JPanel jPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
            if (jPanel == null) {
                EditValueDialog.$$$reportNull$$$0(9);
            }
            return jPanel;
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            EditValueDialog.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTypePeer.getComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myTypePeer.doValidate();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    @Nullable
    public Object getValue() {
        return this.myTypePeer.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionTitle";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePeer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypePeer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypePeer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumTypePeer
    implements TypePeer<Object> {
        private final OptionEnumType myEnumType;
        private final ButtonGroup myButtonGroup;
        private final JPanel myPanel;
        private final Map<ButtonModel, OptionEnumVariant> myVariantByModelMap;
        private final Map<OptionEnumVariant, ButtonModel> myModelByVariantMap;

        private EnumTypePeer(@NotNull OptionEnumType enumType) {
            if (enumType == null) {
                EnumTypePeer.$$$reportNull$$$0(0);
            }
            this.myVariantByModelMap = new IdentityHashMap<ButtonModel, OptionEnumVariant>();
            this.myModelByVariantMap = new IdentityHashMap<OptionEnumVariant, ButtonModel>();
            this.myEnumType = enumType;
            this.myButtonGroup = new ButtonGroup();
            ArrayList components = ContainerUtil.newArrayList();
            boolean first = true;
            for (OptionEnumVariant variant : enumType.getVariants()) {
                String html = "<html><body><strong>" + variant.getValueAsJsonStr() + "</strong></body></html>";
                JRadioButton radioButton = new JRadioButton(html);
                this.myButtonGroup.add(radioButton);
                this.myModelByVariantMap.put(variant, radioButton.getModel());
                this.myVariantByModelMap.put(radioButton.getModel(), variant);
                JPanel radioButtonPanel = SwingHelper.wrapWithoutStretch((JComponent)radioButton);
                if (!first) {
                    radioButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                }
                first = false;
                components.add(radioButtonPanel);
                JPanel descriptionPanel = EnumTypePeer.createDescriptionPanel(radioButton, variant);
                components.add(descriptionPanel);
            }
            this.myPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)SwingHelper.newLeftAlignedVerticalPanel((Collection)components));
        }

        private static JPanel createDescriptionPanel(@NotNull JRadioButton button, @NotNull OptionEnumVariant variant) {
            if (button == null) {
                EnumTypePeer.$$$reportNull$$$0(1);
            }
            if (variant == null) {
                EnumTypePeer.$$$reportNull$$$0(2);
            }
            int leftMargin = button.getMargin().left + EnumTypePeer.getRadioIconWidth() + button.getIconTextGap();
            JPanel result2 = new JPanel(new FlowLayout(0, 0, 0));
            JLabel label = new JLabel(variant.getValueDescription());
            label.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            result2.add(label);
            return result2;
        }

        private static int getRadioIconWidth() {
            Icon icon = UIManager.getIcon("RadioButton.icon");
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 12;
        }

        @Override
        public boolean isHorizontallyStacked() {
            return false;
        }

        @Override
        @Nullable
        public Object getValue() {
            ButtonModel model = this.myButtonGroup.getSelection();
            if (model == null) {
                return null;
            }
            OptionEnumVariant variant = this.myVariantByModelMap.get(model);
            if (variant == null) {
                throw new RuntimeException("No variant found!");
            }
            return variant.getValue();
        }

        @Override
        public void setValue(@Nullable Object value) {
            if (value == null) {
                throw new RuntimeException("Unexpected null for enum!");
            }
            OptionEnumVariant variant = this.myEnumType.getVariantByValue(value);
            if (variant == null) {
                throw new RuntimeException("Invalid enum value!");
            }
            ButtonModel model = this.myModelByVariantMap.get(variant);
            if (model == null) {
                throw new RuntimeException("Unexpected null");
            }
            model.setSelected(true);
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                EnumTypePeer.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptionPanel";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StringTypePeer
    implements TypePeer<String> {
        private final JBScrollPane myScrollPane;
        private final JTextArea myTextArea = new JTextArea();

        private StringTypePeer() {
            this.myTextArea.setLineWrap(true);
            this.myTextArea.setWrapStyleWord(true);
            this.myScrollPane = new JBScrollPane((Component)this.myTextArea);
            this.myScrollPane.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        }

        @Override
        public boolean isHorizontallyStacked() {
            return false;
        }

        @Override
        @Nullable
        public String getValue() {
            return this.getText();
        }

        @Override
        public void setValue(@Nullable String value) {
            this.myTextArea.setText(StringUtil.notNullize((String)value));
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JBScrollPane jBScrollPane = this.myScrollPane;
            if (jBScrollPane == null) {
                StringTypePeer.$$$reportNull$$$0(0);
            }
            return jBScrollPane;
        }

        @NotNull
        private String getText() {
            String string = StringUtil.notNullize((String)this.myTextArea.getText());
            if (string == null) {
                StringTypePeer.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog$StringTypePeer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class IntegerTypePeer
    implements TypePeer<Integer> {
        private final JTextField myTextField = new JTextField();

        private IntegerTypePeer() {
            this.myTextField.setColumns(6);
        }

        @Override
        public boolean isHorizontallyStacked() {
            return true;
        }

        @Override
        @Nullable
        public Integer getValue() {
            return IntegerTypePeer.toInteger(this.getText());
        }

        @Override
        public void setValue(@Nullable Integer value) {
            String text = value == null ? "" : value.toString();
            this.myTextField.setText(text);
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            OptionType<Integer> intType;
            Integer value;
            String text = this.getText();
            if (!(text.isEmpty() || (value = (intType = OptionTypes.INTEGER).fromString(text)) != null && intType.isValidValue(value))) {
                return new ValidationInfo("Illegal integer", (JComponent)this.myTextField);
            }
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                IntegerTypePeer.$$$reportNull$$$0(0);
            }
            return jTextField;
        }

        @Nullable
        private static Integer toInteger(@NotNull String text) {
            if (text == null) {
                IntegerTypePeer.$$$reportNull$$$0(1);
            }
            try {
                return Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }

        @NotNull
        private String getText() {
            String string = StringUtil.notNullize((String)this.myTextField.getText());
            if (string == null) {
                IntegerTypePeer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog$IntegerTypePeer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/EditValueDialog$IntegerTypePeer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toInteger";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface TypePeer<T> {
        public boolean isHorizontallyStacked();

        @Nullable
        public T getValue();

        public void setValue(@Nullable T var1);

        @Nullable
        public ValidationInfo doValidate();

        @NotNull
        public JComponent getComponent();
    }
}

