/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierAliasBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportedExportedDefaultBindingImpl;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImportStatementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptPropertySignatureImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTreeUtil {
    private static final Logger LOG = Logger.getInstance(JSTreeUtil.class);

    @NotNull
    private static JSScopeNamesUsages calcScopeNameUsage(final @NotNull CompositeElement scope) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(ScopeTypesHolder.SCOPE_TYPES_FOR_CACHING.contains(scope.getElementType()));
        final JSScopeNamesUsages result2 = new JSScopeNamesUsages();
        final ArrayDeque blocksStack = new ArrayDeque();
        scope.acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

            protected void visitNode(TreeElement element) {
                String declaredName;
                if (element == scope) {
                    super.visitNode(element);
                    return;
                }
                IElementType type = element.getElementType();
                if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(type)) {
                    blocksStack.push(element);
                }
                if ((declaredName = JSTreeUtil.getDeclaredOrAssignedName(element)) != null) {
                    Map usages = result2.rootUsages;
                    if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type) && !blocksStack.isEmpty() && JSVariableBaseImpl.hasBlockScope((ASTNode)element)) {
                        usages = result2.blockUsages.computeIfAbsent((TreeElement)blocksStack.peek(), (Function<TreeElement, Map<String, JSScopeDeclarationsAndAssignments>>)((Function<TreeElement, Map>)it -> new THashMap()));
                    }
                    JSScopeDeclarationsAndAssignments declaredNameUsage = usages.computeIfAbsent((String)declaredName, it -> new JSScopeDeclarationsAndAssignments());
                    declaredNameUsage.add((CompositeElement)element);
                }
                if (ScopeTypesHolder.SCOPE_TYPES_FOR_CACHING.contains(type)) {
                    if (element instanceof CompositeElement) {
                        result2.directChildScopes.add((CompositeElement)element);
                    }
                    return;
                }
                super.visitNode(element);
            }

            protected void elementFinished(@NotNull ASTNode element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(element.getElementType())) {
                    TreeElement pop = (TreeElement)blocksStack.pop();
                    LOG.assertTrue(element == pop);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil$1", "elementFinished"));
            }
        });
        LOG.assertTrue(blocksStack.isEmpty());
        JSScopeNamesUsages jSScopeNamesUsages = result2;
        if (jSScopeNamesUsages == null) {
            JSTreeUtil.$$$reportNull$$$0(1);
        }
        return jSScopeNamesUsages;
    }

    public static boolean definedInScopeAndUp(@NotNull String name, @NotNull ASTNode scopeElement) {
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(2);
        }
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(3);
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            IElementType parentType = parent.getElementType();
            if (!ScopeTypesHolder.SCOPE_TYPES.contains(parentType) || !(declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)).hasDeclarationOrAssignment(false)) continue;
            return true;
        }
        return false;
    }

    public static boolean processDeclarationsAndAssignmentsInScopeAndUp(@Nullable String name, @NotNull ASTNode scopeElement, @NotNull Processor<? super JSScopeDeclarationsAndAssignments> processor) {
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSTreeUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            IElementType parentType = parent.getElementType();
            if (!ScopeTypesHolder.SCOPE_TYPES.contains(parentType) || !(declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)).hasDeclarationOrAssignment(true) || processor.process((Object)declarationsAndAssignments)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScopeAndUp(@NotNull String name, @NotNull ASTNode scopeElement) {
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(6);
        }
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(7);
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        JSTreeUtil.processDeclarationsAndAssignmentsInScopeAndUp(name, scopeElement, (Processor<? super JSScopeDeclarationsAndAssignments>)processor);
        return (JSScopeDeclarationsAndAssignments)processor.getFoundValue();
    }

    @NotNull
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScope(@Nullable String name, @NotNull CompositeElement scope) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(8);
        }
        assert (ScopeTypesHolder.SCOPE_TYPES.contains(scope.getElementType())) : scope.getElementType() + " doesn't provide scope";
        JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInCodeBlockInner(scope, name);
        if (jSScopeDeclarationsAndAssignments == null) {
            JSTreeUtil.$$$reportNull$$$0(9);
        }
        return jSScopeDeclarationsAndAssignments;
    }

    @NotNull
    private static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInCodeBlockInner(@NotNull CompositeElement scope, @Nullable String name) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(10);
        }
        Map<String, JSScopeDeclarationsAndAssignments> scopeNameUsage = JSTreeUtil.getScopeNameUsage(scope);
        if (name != null) {
            JSScopeDeclarationsAndAssignments assignments = scopeNameUsage.get(name);
            JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = assignments != null ? assignments : JSScopeDeclarationsAndAssignments.EMPTY;
            if (jSScopeDeclarationsAndAssignments == null) {
                JSTreeUtil.$$$reportNull$$$0(11);
            }
            return jSScopeDeclarationsAndAssignments;
        }
        JSScopeDeclarationsAndAssignments result2 = new JSScopeDeclarationsAndAssignments();
        for (JSScopeDeclarationsAndAssignments nameUsages : scopeNameUsage.values()) {
            result2.myElements.addAll(nameUsages.myElements);
        }
        JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = result2;
        if (jSScopeDeclarationsAndAssignments == null) {
            JSTreeUtil.$$$reportNull$$$0(12);
        }
        return jSScopeDeclarationsAndAssignments;
    }

    @NotNull
    private static Map<String, JSScopeDeclarationsAndAssignments> getScopeNameUsage(@NotNull CompositeElement scopeOrBlock) {
        if (scopeOrBlock == null) {
            JSTreeUtil.$$$reportNull$$$0(13);
        }
        CompositeElement baseScope = scopeOrBlock;
        if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(scopeOrBlock.getElementType())) {
            baseScope = TreeUtil.findParent((ASTNode)scopeOrBlock, (TokenSet)ScopeTypesHolder.SCOPE_TYPES_FOR_CACHING);
        }
        if (!(baseScope instanceof CompositeElement)) {
            Map<String, JSScopeDeclarationsAndAssignments> map = Collections.emptyMap();
            if (map == null) {
                JSTreeUtil.$$$reportNull$$$0(14);
            }
            return map;
        }
        CompositeElement scope = baseScope;
        JSScopeNamesUsages scopeNamesUsages = JSTreeUtil.getScopeNamesUsages(scope);
        Map<String, JSScopeDeclarationsAndAssignments> map = scope == scopeOrBlock ? scopeNamesUsages.rootUsages : scopeNamesUsages.blockUsages.getOrDefault(scopeOrBlock, Collections.emptyMap());
        if (map == null) {
            JSTreeUtil.$$$reportNull$$$0(15);
        }
        return map;
    }

    @NotNull
    public static JSScopeNamesUsages getScopeNamesUsages(CompositeElement scope) {
        if (!ScopeTypesHolder.SCOPE_TYPES_FOR_CACHING.contains(scope.getElementType())) {
            JSScopeNamesUsages jSScopeNamesUsages = JSScopeNamesUsages.EMPTY;
            if (jSScopeNamesUsages == null) {
                JSTreeUtil.$$$reportNull$$$0(16);
            }
            return jSScopeNamesUsages;
        }
        JSScopeNamesUsages jSScopeNamesUsages = (JSScopeNamesUsages)CachedValuesManager.getManager((Project)scope.getManager().getProject()).getCachedValue((UserDataHolder)scope, () -> new CachedValueProvider.Result((Object)JSTreeUtil.calcScopeNameUsage(scope), new Object[]{scope.getPsi()}));
        if (jSScopeNamesUsages == null) {
            JSTreeUtil.$$$reportNull$$$0(17);
        }
        return jSScopeNamesUsages;
    }

    @Nullable
    public static String getDeclaredOrAssignedName(@NotNull TreeElement element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(18);
        }
        IElementType type = element.getElementType();
        ASTNode identifier = null;
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type)) {
            identifier = JSVariableBaseImpl.findVariableNameIdentifier((ASTNode)element);
        } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || type == JSStubElementTypes.FUNCTION_SIGNATURE || type == FlowJSElementTypes.FUNCTION_SIGNATURE) {
            identifier = JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)element);
        } else if (type == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode((ASTNode)element);
            if (expressionNode != null && expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expressionNode) == null) {
                identifier = JSReferenceExpressionImpl.getNameElement(expressionNode);
            }
        } else if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type) || type == JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS) {
            identifier = JSClassBase.findNameIdentifier((ASTNode)element);
        } else if (type == ES6ElementTypes.IMPORT_SPECIFIER || type == ES6ElementTypes.EXPORT_SPECIFIER) {
            if (element.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER_ALIAS) == null && element.findChildByType((IElementType)ES6ElementTypes.EXPORT_SPECIFIER_ALIAS) == null) {
                identifier = ES6ImportExportSpecifierBase.getDeclarationNameElement((ASTNode)element);
            }
        } else if (type == JSStubElementTypes.TYPESCRIPT_MODULE) {
            ASTNode moduleIdentifier = TypeScriptModuleImpl.findNameIdentifier((ASTNode)element);
            if (moduleIdentifier != null && !StringUtil.isQuotedString((String)moduleIdentifier.getText())) {
                identifier = moduleIdentifier;
            }
        } else {
            if (type == TypeScriptElementTypes.IMPLICIT_MODULE) {
                return ((TypeScriptImplicitModule)element.getPsi()).getName();
            }
            if (type == TypeScriptElementTypes.IMPORT_STATEMENT) {
                identifier = TypeScriptImportStatementImpl.findNameIdentifier((ASTNode)element);
            } else if (type == ES6ElementTypes.IMPORT_SPECIFIER_ALIAS || type == ES6ElementTypes.EXPORT_SPECIFIER_ALIAS) {
                identifier = ES6ImportExportSpecifierAliasBase.findNameIdentifier((ASTNode)element);
            } else if (type == ES6ElementTypes.IMPORTED_BINDING || type == ES6ElementTypes.EXPORTED_DEFAULT_BINDING) {
                identifier = ES6ImportedExportedDefaultBindingImpl.findNameIdentifier((ASTNode)element);
            } else if (type == TypeScriptElementTypes.PROPERTY_SIGNATURE) {
                identifier = TypeScriptPropertySignatureImpl.findNameIdentifier((ASTNode)element);
            } else if (JSStubElementTypes.CALL_SIGNATURE != type && TypeScriptElementTypes.INDEX_SIGNATURE != type) assert (!JSStubBasedPsiTreeUtil.DECLARATIONS_TOKEN_SET.contains(type)) : type + " is not handled";
        }
        return identifier != null ? identifier.getText() : null;
    }

    public static boolean hasDeclarationOrAssignmentInNestedScopes(@NotNull CompositeElement scope, @NotNull String name) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(19);
        }
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(20);
        }
        return JSTreeUtil.hasDeclarationOrAssignmentInScopeAndNestedScopes(scope, name, true);
    }

    public static boolean hasDeclarationOrAssignmentInScopeAndNestedScopes(@NotNull CompositeElement scope, @NotNull String name, boolean nestedOnly) {
        JSScopeDeclarationsAndAssignments assignments;
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(21);
        }
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(22);
        }
        JSScopeNamesUsages usages = JSTreeUtil.getScopeNamesUsages(scope);
        if (!nestedOnly && (assignments = usages.rootUsages.get(name)) != null && assignments.hasDeclarationOrAssignment(true)) {
            return true;
        }
        for (CompositeElement nested : usages.directChildScopes) {
            if (!JSTreeUtil.hasDeclarationOrAssignmentInScopeAndNestedScopes(nested, name, false)) continue;
            return true;
        }
        return false;
    }

    public static Language getLanguage(@NotNull ASTNode element) {
        JSLanguageDialect forcedLanguage;
        JSEmbeddedContentElementType type;
        ASTNode embeddedContent;
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(23);
        }
        if ((embeddedContent = TreeUtil.findParent((ASTNode)element, (TokenSet)JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS)) != null && (type = (JSEmbeddedContentElementType)((Object)ObjectUtils.tryCast((Object)embeddedContent.getElementType(), JSEmbeddedContentElementType.class))) != null && (forcedLanguage = type.getForcedLanguage()) != null) {
            return forcedLanguage;
        }
        FileElement fileElement = element instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)element)) : null;
        return fileElement != null ? fileElement.getElementType().getLanguage() : null;
    }

    @NotNull
    public static Set<String> findReturnedReferences(@NotNull CompositeElement function) {
        if (function == null) {
            JSTreeUtil.$$$reportNull$$$0(24);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)function.getPsi(), () -> {
            if (function == null) {
                JSTreeUtil.$$$reportNull$$$0(30);
            }
            return new CachedValueProvider.Result(JSTreeUtil.calculateReturnedReferences((TreeElement)function), new Object[]{function.getPsi()});
        });
        if (set == null) {
            JSTreeUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static Set<String> calculateReturnedReferences(final @NotNull TreeElement function) {
        if (function == null) {
            JSTreeUtil.$$$reportNull$$$0(26);
        }
        THashSet referencedNames = new THashSet();
        new RecursiveTreeElementWalkingVisitor((Set)referencedNames){
            int inReturnStatement;
            final /* synthetic */ Set val$referencedNames;
            {
                this.val$referencedNames = set;
            }

            protected void visitNode(TreeElement element) {
                if (element == function) {
                    super.visitNode(element);
                    return;
                }
                IElementType type = element.getElementType();
                if (type == JSStubElementTypes.RETURN_STATEMENT) {
                    ++this.inReturnStatement;
                } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) {
                    if (this.inReturnStatement == 0) {
                        return;
                    }
                } else if (JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type)) {
                    if (this.inReturnStatement > 0) {
                        if (type == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode((ASTNode)element) == null && element.getTreeParent().getElementType() != JSStubElementTypes.CALL_EXPRESSION) {
                            this.val$referencedNames.add(element.getLastChildNode().getText());
                        }
                    } else {
                        return;
                    }
                }
                super.visitNode(element);
            }

            protected void elementFinished(@NotNull ASTNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element.getElementType() == JSStubElementTypes.RETURN_STATEMENT) {
                    --this.inReturnStatement;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil$2", "elementFinished"));
            }
        }.visitNode(function);
        return referencedNames;
    }

    @Nullable
    public static String getName(@NotNull ASTNode namedElement) {
        ASTNode identifier;
        IElementType type;
        if (namedElement == null) {
            JSTreeUtil.$$$reportNull$$$0(27);
        }
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type = namedElement.getElementType())) {
            ASTNode identifier2 = JSVariableBaseImpl.findVariableNameIdentifier(namedElement);
            if (identifier2 != null) {
                return identifier2.getText();
            }
        } else if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(type) && (identifier = JSPropertyImpl.findNameIdentifier(namedElement)) != null) {
            return identifier.getText();
        }
        return null;
    }

    public static boolean withinWithStatement(@NotNull ASTNode element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(28);
        }
        return TreeUtil.findParent((ASTNode)element, (IElementType)JSElementTypes.WITH_STATEMENT) != null;
    }

    public static Project getProject(@NotNull ASTNode node) {
        if (node == null) {
            JSTreeUtil.$$$reportNull$$$0(29);
        }
        ASTNode parent = node;
        do {
            node = parent;
        } while ((parent = parent.getTreeParent()) != null);
        return node.getPsi().getProject();
    }

    public static ASTNode getInitializerNode(ASTNode ownerNode) {
        ASTNode eqNode;
        IElementType elementType = ownerNode.getElementType();
        ASTNode initializer = null;
        if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(elementType)) {
            initializer = ownerNode.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        } else if (elementType == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode parent = ownerNode.getTreeParent();
            if (parent != null && parent.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                initializer = JSBinaryExpressionImpl.getROperandNode(parent);
            }
        } else if (elementType != JSStubElementTypes.ASSIGNMENT_EXPRESSION && (eqNode = ownerNode.findChildByType(JSTokenTypes.EQ)) != null) {
            initializer = ownerNode.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, eqNode);
        }
        return initializer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSTreeUtil";
                break;
            }
            case 2: 
            case 6: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOrBlock";
                break;
            }
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcScopeNameUsage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsAndAssignmentsInScope";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsAndAssignmentsInCodeBlockInner";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNameUsage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNamesUsages";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnedReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcScopeNameUsage";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "definedInScopeAndUp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsAndAssignmentsInScopeAndUp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInScopeAndUp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInCodeBlockInner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScopeNameUsage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredOrAssignedName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclarationOrAssignmentInNestedScopes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclarationOrAssignmentInScopeAndNestedScopes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findReturnedReferences";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "calculateReturnedReferences";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "withinWithStatement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findReturnedReferences$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSScopeNamesUsages {
        static final JSScopeNamesUsages EMPTY = new JSScopeNamesUsages();
        @NotNull
        public Map<String, JSScopeDeclarationsAndAssignments> rootUsages = new THashMap();
        @NotNull
        public Map<TreeElement, Map<String, JSScopeDeclarationsAndAssignments>> blockUsages = new THashMap();
        Set<CompositeElement> directChildScopes = ContainerUtil.newHashSet();
    }

    public static class JSScopeDeclarationsAndAssignments {
        static final JSScopeDeclarationsAndAssignments EMPTY = new JSScopeDeclarationsAndAssignments();
        @NotNull
        private final List<CompositeElement> myElements = new SmartList();

        public boolean hasDeclarationOrAssignment(boolean includeAssignments) {
            if (includeAssignments) {
                return !this.myElements.isEmpty();
            }
            int size = this.myElements.size();
            for (int i = 0; i < size; ++i) {
                CompositeElement element = this.myElements.get(i);
                if (element.getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) continue;
                return true;
            }
            return false;
        }

        public void add(@NotNull CompositeElement element) {
            if (element == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(0);
            }
            this.myElements.add(element);
        }

        private int findNearestDefinitionIndex(@NotNull ASTNode context) {
            CompositeElement element;
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(1);
            }
            if (this.myElements.isEmpty()) {
                return -1;
            }
            if (this.myElements.size() == 1) {
                return 0;
            }
            int i = Collections.binarySearch(this.myElements, context, (o1, o2) -> {
                int o2Length;
                int o2Start;
                int o1Start = o1.getStartOffset();
                if (o1Start < (o2Start = o2.getStartOffset())) {
                    return -1;
                }
                if (o2Start < o1Start) {
                    return 1;
                }
                int o1Length = o1.getTextLength();
                if (o1Length < (o2Length = o2.getTextLength())) {
                    return -1;
                }
                if (o2Length < o1Length) {
                    return 1;
                }
                return 0;
            });
            if (i < 0) {
                i = -i - 2;
            }
            if ((element = this.myElements.get(i = Math.max(i, 0))).getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) {
                element = element.getTreeParent();
            }
            return element.getTextRange().contains(context.getTextRange()) && i > 0 ? i - 1 : i;
        }

        @Nullable
        public CompositeElement findNearestDefinition(@NotNull ASTNode context) {
            int i;
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(2);
            }
            return (i = this.findNearestDefinitionIndex(context)) >= 0 ? this.myElements.get(i) : null;
        }

        public boolean processFromNearest(@NotNull ASTNode context, @NotNull PsiScopeProcessor processor, boolean searchContext) {
            int i;
            int start;
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(3);
            }
            if (processor == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(4);
            }
            int n = searchContext ? this.findNearestDefinitionIndex(context) : (start = this.myElements.isEmpty() ? -1 : 0);
            if (start == -1) {
                return true;
            }
            for (i = start; i < this.myElements.size(); ++i) {
                PsiElement psi = this.myElements.get(i).getPsi();
                if (processor.execute(psi, ResolveState.initial())) continue;
                return false;
            }
            for (i = 0; i < start; ++i) {
                if (processor.execute(this.myElements.get(i).getPsi(), ResolveState.initial())) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public List<CompositeElement> getElements() {
            List<CompositeElement> list = this.myElements;
            if (list == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestDefinitionIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestDefinition";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processFromNearest";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ScopeTypesHolder {
        private static final TokenSet SCOPE_TYPES_FOR_CACHING = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, TokenSet.create((IElementType[])JSFileElementType.getAll().values().toArray(IElementType.EMPTY_ARRAY)), JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS});
        static final TokenSet BLOCK_SCOPE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.FOR_STATEMENT, JSElementTypes.FOR_IN_STATEMENT})});
        static final TokenSet SCOPE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{SCOPE_TYPES_FOR_CACHING, BLOCK_SCOPE_TYPES});

        ScopeTypesHolder() {
        }
    }
}

