/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSCallerChooser;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModel;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModelItem;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureDialog
extends ChangeSignatureDialogBase<JSParameterInfo, JSFunction, String, JSMethodDescriptor, JSParameterTableModelItem, JSParameterTableModel> {
    private JLabel myWarningLabel;

    public JSChangeSignatureDialog(JSFunction method, boolean forceConstructor, PsiElement defaultValueContext) {
        this(JSMethodDescriptorFactory.create(method, forceConstructor), defaultValueContext);
        this.setWarningText(method.isReferencesArguments() ? JSBundle.message((String)"change.signature.method.references.arguments", (Object[])new Object[0]) : null);
    }

    public JSChangeSignatureDialog(JSMethodDescriptor descriptor2, PsiElement resolveContext) {
        super(resolveContext.getProject(), (MethodDescriptor)descriptor2, false, resolveContext);
        this.setTitle(JSBundle.message((String)"change.signature.dialog.title", (Object[])new Object[]{JSFormatUtil.formatMethod(descriptor2.getMethod(), 4353, 0, 0, null)}));
    }

    protected LanguageFileType getFileType() {
        return JSChangeSignatureDialog.getFileTypeFromContext((PsiElement)((JSMethodDescriptor)this.myMethod).getMethod());
    }

    @NotNull
    protected JSParameterTableModel createParametersInfoModel(@NotNull JSMethodDescriptor method) {
        if (method == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        JSParameterTableModel jSParameterTableModel = new JSParameterTableModel(this.myDefaultValueContext, this.getDefaultValueColumnTitle(), this.getInitializerColumnTitle(), this.isShowTypeColumn(), this.isShowOptionalColumn());
        if (jSParameterTableModel == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        return jSParameterTableModel;
    }

    private boolean isShowOptionalColumn() {
        return ((JSMethodDescriptor)this.myMethod).canHaveOptional();
    }

    private boolean isShowTypeColumn() {
        return ((JSMethodDescriptor)this.myMethod).canHaveType();
    }

    public boolean placeReturnTypeBeforeName() {
        return ((JSMethodDescriptor)this.myMethod).isActionScript();
    }

    @Nullable
    private String getInitializerColumnTitle() {
        if (!((JSMethodDescriptor)this.myMethod).canHaveInitializers()) {
            return null;
        }
        if (((JSMethodDescriptor)this.myMethod).isActionScript()) {
            return JSBundle.message((String)"change.signature.column.name.initializer", (Object[])new Object[0]);
        }
        return JSBundle.message((String)"change.signature.column.name.default.parameter", (Object[])new Object[0]);
    }

    @Nullable
    protected String getDefaultValueColumnTitle() {
        PsiElement parent;
        if (((JSMethodDescriptor)this.myMethod).getMethod() instanceof JSFunctionExpression && !((parent = ((JSMethodDescriptor)this.myMethod).getMethod().getParent()) instanceof JSVariable) && !(parent instanceof JSAssignmentExpression) && !(parent instanceof JSProperty)) {
            return null;
        }
        if (((JSMethodDescriptor)this.myMethod).isActionScript()) {
            return RefactoringBundle.message((String)"column.name.default.value");
        }
        if (JSChangeSignatureDialog.hasES6DefaultParameters((JSMethodDescriptor)this.myMethod)) {
            return JSBundle.message((String)"change.signature.column.name.call.value", (Object[])new Object[0]);
        }
        return JSBundle.message((String)"change.signature.value.column.title", (Object[])new Object[0]);
    }

    protected JSChangeSignatureProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new JSChangeSignatureProcessor(((JSMethodDescriptor)this.myMethod).getMethod(), JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility())), this.getMethodName(), this.myReturnTypeCodeFragment != null ? this.myReturnTypeCodeFragment.getText() : "", parameters.toArray(JSParameterInfo.EMPTY_ARRAY), (Set)ObjectUtils.coalesce((Object)this.myMethodsToPropagateParameters, Collections.emptySet()), this.collectImportedElementsFromFragments());
    }

    @NotNull
    private Set<JSElement> collectImportedElementsFromFragments() {
        HashSet result2 = ContainerUtil.newHashSet();
        if (this.myReturnTypeCodeFragment != null) {
            result2.addAll(((JSExpressionCodeFragment)this.myReturnTypeCodeFragment).getImportedElements());
        }
        for (JSParameterTableModelItem item : ((JSParameterTableModel)this.myParametersTableModel).getItems()) {
            if (item.typeCodeFragment != null) {
                result2.addAll(((JSExpressionCodeFragment)item.typeCodeFragment).getImportedElements());
            }
            if (item.defaultValueCodeFragment != null) {
                result2.addAll(((JSExpressionCodeFragment)item.defaultValueCodeFragment).getImportedElements());
            }
            if (item.initializerCodeFragment == null) continue;
            result2.addAll(item.initializerCodeFragment.getImportedElements());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        JSExpressionCodeFragment jSExpressionCodeFragment = JSChangeSignatureDialog.createReturnTypeCodeFragment(((JSMethodDescriptor)this.myMethod).getReturnType(), (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), ((JSMethodDescriptor)this.myMethod).getFileLanguage());
        if (jSExpressionCodeFragment == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(3);
        }
        return jSExpressionCodeFragment;
    }

    public static JSExpressionCodeFragment createReturnTypeCodeFragment(String type, PsiElement context, @Nullable JSLanguageDialect lang) {
        JavaScriptParserBase.ForceContext codeFragmentType = lang != null && lang.getOptionHolder().isECMA4 ? JavaScriptParserBase.ForceContext.Type : JavaScriptParserBase.ForceContext.TypeAllowEmpty;
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(context.getProject(), type, context, lang, ProjectScope.getAllScope((Project)context.getProject()), JSElementFactory.TopLevelCompletion.YES, codeFragmentType);
        fragment.setIntentionActionsFilter(intentionAction -> false);
        return fragment;
    }

    protected EditorTextField createReturnTypeTextField(Document document) {
        return new JSEditorTextField(this.myProject, document);
    }

    protected CallerChooserBase<JSFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
        return new JSCallerChooser(((JSMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    protected String validateAndCommitData() {
        String returnTypeText;
        String name = this.getMethodName();
        JSFunction methodElement = ((JSMethodDescriptor)this.myMethod).getMethod();
        if (!(RenameUtil.isValidName((Project)methodElement.getProject(), (PsiElement)methodElement, (String)name) || StringUtil.isEmpty((String)name) && methodElement instanceof JSFunctionExpression)) {
            return JSBundle.message((String)"javascript.change.signature.invalid.function.name.0", (Object[])new Object[]{name});
        }
        if (this.myReturnTypeCodeFragment != null && ((JSMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && (returnTypeText = this.myReturnTypeCodeFragment.getText()).length() > 0 && JSRefactoringUtil.createTypeElement(returnTypeText, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod()) == null) {
            return JSBundle.message((String)"invalid.return.type.expression", (Object[])new Object[]{returnTypeText});
        }
        List items = ((JSParameterTableModel)this.myParametersTableModel).getItems();
        if (items.size() != 1 && ((JSMethodDescriptor)this.myMethod).getMethod().isSetProperty()) {
            return JSBundle.message((String)"javascript.validation.message.set.method.should.have.one.parameter", (Object[])new Object[0]);
        }
        if (((JSMethodDescriptor)this.myMethod).getMethod().isGetProperty() && "void".equals(this.myReturnTypeField.getText())) {
            return JSBundle.message((String)"javascript.validation.message.get.method.should.be.valid.type", (Object[])new Object[]{"void"});
        }
        boolean initializerFound = false;
        boolean initializerUsed = false;
        HashSet<String> paramsNames = new HashSet<String>();
        for (ParameterTableModelItemBase item : items) {
            JSParameterListElement element = JSChangeSignatureDialog.tryBuildParameterListElement((PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), ((JSParameterInfo)item.parameter).getDeclarationText());
            List<String> parameterVariableNames = element != null ? JSChangeSignatureDialog.extractParameterNames(element) : ContainerUtil.emptyList();
            for (String parameterVariableName : parameterVariableNames) {
                if (paramsNames.add(parameterVariableName)) continue;
                return JSBundle.message((String)"duplicate.parameter.name", (Object[])new Object[]{parameterVariableName});
            }
        }
        for (int i = 0; i < items.size(); ++i) {
            String typeText;
            ParameterTableModelItemBase item;
            item = (JSParameterTableModelItem)((Object)items.get(i));
            JSParameterInfo parameterItem = (JSParameterInfo)item.parameter;
            if (JSChangeSignatureDialog.tryBuildParameterListElement((PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), ((JSParameterInfo)item.parameter).getDeclarationText()) == null) {
                return JSBundle.message((String)"javascript.change.signature.invalid.parameter.declaration", (Object[])new Object[]{parameterItem.getName()});
            }
            if (((JSParameterInfo)item.parameter).isRest() && i != items.size() - 1) {
                return JSBundle.message((String)"changeSignature.vararg.not.last", (Object[])new Object[0]);
            }
            String initializer = item.initializerCodeFragment.getText();
            if (((JSParameterInfo)item.parameter).getOldIndex() < 0) {
                String defaultValueText = item.defaultValueCodeFragment.getText().trim();
                if (!((JSParameterInfo)item.parameter).isRest()) {
                    if (StringUtil.isEmpty((String)defaultValueText)) {
                        if (this.getDefaultValueColumnTitle() != null && StringUtil.isEmpty((String)initializer)) {
                            if (JSChangeSignatureDialog.hasES6DefaultParameters((JSMethodDescriptor)this.myMethod)) {
                                return JSBundle.message((String)"es6.changeSignature.no.call.value", (Object[])new Object[]{((JSParameterInfo)item.parameter).getDeclarationText()});
                            }
                            return JSBundle.message((String)"javascript.changeSignature.no.call.value", (Object[])new Object[]{((JSParameterInfo)item.parameter).getDeclarationText()});
                        }
                        initializerUsed = true;
                    } else {
                        if (initializerUsed) {
                            if (JSChangeSignatureDialog.hasES6DefaultParameters((JSMethodDescriptor)this.myMethod)) {
                                return JSBundle.message((String)"es6.changeSignature.call.value.not.allowed", (Object[])new Object[]{((JSParameterInfo)item.parameter).getDeclarationText()});
                            }
                            return JSBundle.message((String)"javascript.changeSignature.call.value.not.allowed", (Object[])new Object[]{((JSParameterInfo)item.parameter).getDeclarationText()});
                        }
                        try {
                            JSChangeUtil.createJSTreeFromText(this.myProject, defaultValueText, ((JSMethodDescriptor)this.myMethod).getFileLanguage());
                        }
                        catch (IncorrectOperationException e) {
                            return e.getMessage();
                        }
                    }
                }
                ((JSParameterInfo)item.parameter).setCallValue(defaultValueText);
            }
            if (StringUtil.isNotEmpty((String)initializer)) {
                initializerFound = true;
            } else if (initializerFound && !((JSParameterInfo)item.parameter).isRest()) {
                return JSBundle.message((String)"required.parameters.are.not.permitted.after.optional.parameters", (Object[])new Object[0]);
            }
            if (!((JSParameterInfo)item.parameter).isRest() && (typeText = item.typeCodeFragment.getText()).length() > 0 && JSRefactoringUtil.createTypeElement(typeText, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod()) == null) {
                return JSBundle.message((String)"invalid.parameter.type.expression", (Object[])new Object[]{typeText});
            }
            ((JSParameterInfo)item.parameter).setInitializer(initializer);
        }
        if (((JSMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            String returnTypeText2 = this.myReturnTypeCodeFragment.getText();
            if (((JSMethodDescriptor)this.myMethod).resolveTypes() && !JSRefactoringUtil.isResolvableType(returnTypeText2, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), true, false) && Messages.showYesNoDialog((Project)this.myProject, (String)JSBundle.message((String)"return.type.is.not.resolved", (Object[])new Object[]{returnTypeText2}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0) {
                return "";
            }
        }
        if (((JSMethodDescriptor)this.myMethod).isActionScript()) {
            for (ParameterTableModelItemBase item : items) {
                String typeText = item.typeCodeFragment.getText();
                if (StringUtil.isEmpty((String)typeText) ? Messages.showYesNoDialog((Project)this.myProject, (String)JSBundle.message((String)"parameter.type.is.not.specified", (Object[])new Object[]{((JSParameterInfo)item.parameter).getDeclarationText()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0 : ((JSMethodDescriptor)this.myMethod).resolveTypes() && !JSRefactoringUtil.isResolvableType(typeText, (PsiElement)((JSMethodDescriptor)this.myMethod).getMethod(), false, true) && Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.parameter.type", (Object[])new Object[]{typeText, ((JSParameterInfo)item.parameter).getDeclarationText()}), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon()) != 0) {
                    return "";
                }
                ((JSParameterInfo)item.parameter).setTypeText(((JSParameterTableModelItem)item).typeCodeFragment.getText());
            }
        }
        return null;
    }

    @Nullable
    private static JSParameterListElement tryBuildParameterListElement(@NotNull PsiElement context, @NotNull String text) {
        JSFunction function;
        if (context == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(4);
        }
        if (text == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(5);
        }
        if ((function = JSChangeUtil.createStatementPsiFromTextWithContext("function f(" + text + "){}", context, JSFunction.class)) == null) {
            return null;
        }
        return (JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters());
    }

    @NotNull
    private static List<String> extractParameterNames(@NotNull JSParameterListElement parameterListElement) {
        if (parameterListElement == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(6);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        PsiTreeUtil.processElements((PsiElement)parameterListElement, element -> {
            if (element instanceof JSParameter) {
                result2.add(StringUtil.notNullize((String)((JSParameter)element).getName()));
            }
            return true;
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        List<JSAttributeList.AccessType> visibility = ((JSMethodDescriptor)this.myMethod).getPossibleVisibility();
        Object[] names = new String[visibility.size()];
        String[] titles = new String[visibility.size()];
        for (int i = 0; i < visibility.size(); ++i) {
            JSAttributeList.AccessType accessType = visibility.get(i);
            names[i] = accessType.name();
            titles[i] = JSVisibilityUtil.getVisibilityKeyword(accessType);
        }
        return new ComboBoxVisibilityPanel(names, titles);
    }

    protected String calculateSignature() {
        ASTNode arrow;
        DialectOptionHolder holder;
        List items = ((JSParameterTableModel)this.myParametersTableModel).getItems();
        for (JSParameterTableModelItem item : items) {
            ((JSParameterInfo)item.parameter).setTypeText(item.typeCodeFragment.getText());
            ((JSParameterInfo)item.parameter).setInitializer(item.initializerCodeFragment.getText());
        }
        JSFunction method = ((JSMethodDescriptor)this.myMethod).getMethod();
        DialectOptionHolder dialectOptionHolder = holder = method == null ? null : DialectDetector.dialectOfElement((PsiElement)method);
        if (holder != null && holder.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS) && (arrow = JSPsiImplUtils.getFunctionArrowNode(method)) != null) {
            return this.calculateArrowFunctionSignature(arrow.getElementType());
        }
        String modifiers = this.calculateModifiers();
        StringBuilder buffer = new StringBuilder();
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        buffer.append(((JSMethodDescriptor)this.myMethod).getFunctionNameWithKeyword(this.getMethodName()));
        JSChangeSignatureDialog.buildParameterListText(this.getParameters(), buffer, ((JSMethodDescriptor)this.myMethod).dialect());
        if (this.myReturnTypeCodeFragment != null && this.myReturnTypeCodeFragment.getText().length() > 0) {
            buffer.append(": ");
            buffer.append(this.myReturnTypeCodeFragment.getText());
        }
        return buffer.toString();
    }

    private String calculateArrowFunctionSignature(IElementType arrow) {
        String methodName;
        PsiElement grandParent;
        StringBuilder buffer = new StringBuilder();
        PsiElement parent = ((JSMethodDescriptor)this.myMethod).getMethod().getParent();
        if (parent instanceof JSVariable && (grandParent = parent.getParent()) instanceof JSVarStatement) {
            buffer.append(grandParent.getFirstChild().getText());
        }
        if (StringUtil.isNotEmpty((String)(methodName = this.getMethodName()))) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(methodName);
        }
        buffer.append(" = ");
        JSChangeSignatureDialog.buildParameterListText(this.getParameters(), buffer, ((JSMethodDescriptor)this.myMethod).dialect());
        buffer.append(arrow == JSTokenTypes.EQGT ? " =" : " -").append("> ");
        return buffer.toString();
    }

    protected String calculateModifiers() {
        JSAttributeList modifierList = ((JSMethodDescriptor)this.myMethod).getMethod().getAttributeList();
        String modifiers = modifierList != null ? modifierList.getText() : "";
        String oldModifier = modifierList != null ? JSVisibilityUtil.getVisibilityKeyword(modifierList.getAccessType()) : "";
        JSAttributeList.AccessType newAccessType = JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility()));
        String newModifier = newAccessType == JSAttributeList.AccessType.PACKAGE_LOCAL && ((JSMethodDescriptor)this.myMethod).isConstructor() || !((JSMethodDescriptor)this.myMethod).canChangeVisibility() ? "" : JSVisibilityUtil.getVisibilityKeyword(newAccessType);
        if (!newModifier.equals(oldModifier)) {
            int index = modifiers.indexOf(oldModifier);
            if (index >= 0) {
                StringBuilder buf = new StringBuilder(modifiers);
                buf.replace(index, index + oldModifier.length() + (newModifier.isEmpty() ? 1 : 0), newModifier);
                modifiers = buf.toString();
            } else {
                if (!newModifier.isEmpty()) {
                    newModifier = newModifier + " ";
                }
                modifiers = newModifier + modifiers;
            }
        }
        return modifiers;
    }

    public static void buildParameterListText(@NotNull List<? extends JSParameterInfo> items, @NotNull StringBuilder buffer, @Nullable DialectOptionHolder holder) {
        if (items == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(8);
        }
        if (buffer == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(9);
        }
        buffer.append("(");
        for (int i = 0; i < items.size(); ++i) {
            String initializer;
            JSParameterInfo item = items.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            String type = item.getTypeText();
            if (item.isRest() && holder != null && holder.isECMA4) {
                buffer.append(type);
                buffer.append(item.getDeclarationText());
                continue;
            }
            String modifiersText = item.getModifiersText();
            if (!StringUtil.isEmpty((String)modifiersText)) {
                buffer.append(modifiersText).append(" ");
            }
            buffer.append(item.getDeclarationText());
            if (holder != null && holder.isTypeScript && item.isOptional() && !StringUtil.endsWith((CharSequence)item.getDeclarationText(), (CharSequence)"?") && StringUtil.isEmpty((String)item.getInitializer())) {
                buffer.append("?");
            }
            if (holder != null && holder.hasFeature(JSLanguageFeature.TYPES) && StringUtil.isNotEmpty((String)type)) {
                buffer.append(": ");
                buffer.append(type);
            }
            if (!StringUtil.isNotEmpty((String)(initializer = item.getInitializer()))) continue;
            buffer.append(" = ").append(initializer);
        }
        buffer.append(")");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JComponent centerPanel = super.createCenterPanel();
        assert (centerPanel != null);
        panel.add((Component)centerPanel, "Center");
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myWarningLabel.setVisible(false);
        panel.add((Component)this.myWarningLabel, "South");
        this.myPropagateParamChangesButton.setVisible(true);
        return panel;
    }

    protected void customizeParametersTable(TableView<JSParameterTableModelItem> table) {
        this.myParametersTable.getEmptyText().setText(JSBundle.message((String)"change.signature.parameter.table.empty.message", (Object[])new Object[0]));
    }

    private void setWarningText(String text) {
        if (text != null) {
            this.myWarningLabel.setText(text);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    protected String getHelpId() {
        if (((JSMethodDescriptor)this.myMethod).isActionScript()) {
            return "Change_Signature_Dialog_for_ActionScript";
        }
        if (((JSMethodDescriptor)this.myMethod).isTypeScript()) {
            return "refactoring.typescript.change.signature";
        }
        return "reference.refactoring.change.signature.javascript";
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)JSChangeSignatureDialog.getFileTypeFromContext((PsiElement)((JSMethodDescriptor)this.myMethod).getMethod())){

            protected String getFileName() {
                JSLanguageDialect language = ((JSMethodDescriptor)JSChangeSignatureDialog.this.myMethod).getFileLanguage();
                String extension = language == null ? ".js" : language.getFileExtension();
                return "dummy." + extension;
            }
        };
    }

    @NotNull
    public static JSLanguageDialect getDialectFromContext(@NotNull PsiElement context) {
        if (context == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(10);
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        JSLanguageDialect jSLanguageDialect = (JSLanguageDialect)((Object)ObjectUtils.coalesce((Object)((Object)dialect), (Object)((Object)JavaScriptSupportLoader.JAVASCRIPT_1_5)));
        if (jSLanguageDialect == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(11);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public static LanguageFileType getFileTypeFromContext(@NotNull PsiElement context) {
        JSLanguageDialect dialect;
        if (context == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(12);
        }
        LanguageFileType fileType = (dialect = DialectDetector.languageDialectOfElement(context)) != null ? dialect.getAssociatedFileType() : null;
        LanguageFileType languageFileType = fileType != null ? fileType : JavaScriptSupportLoader.JAVASCRIPT;
        if (languageFileType == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(13);
        }
        return languageFileType;
    }

    private static boolean hasES6DefaultParameters(@NotNull JSMethodDescriptor method) {
        DialectOptionHolder dialect;
        if (method == null) {
            JSChangeSignatureDialog.$$$reportNull$$$0(14);
        }
        return (dialect = method.dialect()) != null && (dialect.isECMA6 || dialect.isTypeScript);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureDialog";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createParametersInfoModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportedElementsFromFragments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReturnTypeCodeFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractParameterNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectFromContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeFromContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createParametersInfoModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryBuildParameterListElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractParameterNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterListText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDialectFromContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeFromContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasES6DefaultParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

