/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import b.h.la;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchDialog;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspectionOptions {
    final JBList<Configuration> myTemplatesList;
    final List<Configuration> myConfigurations;
    private static final long a = la.a(7412532110827357580L, 6865312309644725806L, MethodHandles.lookup().lookupClass()).a(258471151311110L);

    public SSBasedInspectionOptions(List<Configuration> configurations) {
        this.myConfigurations = configurations;
        this.myTemplatesList = new JBList((ListModel)new MyListModel());
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                Configuration configuration = SSBasedInspectionOptions.this.myConfigurations.get(index);
                jLabel.setText(configuration.getName());
                return jLabel;
            }
        });
    }

    void addTemplate(Configuration configuration, Project project) {
        if (!ConfigurationManager.showSaveTemplateAsDialog(this.myConfigurations, configuration, project)) {
            return;
        }
        this.configurationsChanged(project);
    }

    public void configurationsChanged(Project project) {
        ((MyListModel)this.myTemplatesList.getModel()).fireContentsChanged();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public JPanel getComponent() {
        long l2 = a ^ 0x56BCF2ECDC67L;
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JLabel(SSRBundle.message("SSRInspection.selected.templates", new Object[0])));
        jPanel.add(ToolbarDecorator.createDecorator(this.myTemplatesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AnAction[] anActionArray = new AnAction[]{new AddTemplateAction(SSBasedInspectionOptions.this, false), new AddTemplateAction(SSBasedInspectionOptions.this, true)};
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(anActionArray), DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)jPanel));
                if (project != null && !DumbService.isDumb((Project)project)) {
                    SSBasedInspectionOptions.this.performEditAction(project);
                }
            }
        }).setEditActionUpdater(anActionEvent -> {
            Project project = anActionEvent.getProject();
            return project != null && !DumbService.isDumb((Project)project);
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)jPanel));
                if (project == null) {
                    return;
                }
                for (Configuration configuration : SSBasedInspectionOptions.this.myTemplatesList.getSelectedValuesList()) {
                    SSBasedInspectionOptions.this.myConfigurations.remove(configuration);
                    SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration, project);
                }
                SSBasedInspectionOptions.this.configurationsChanged(project);
            }
        }).setRemoveActionUpdater(anActionEvent -> {
            Project project = anActionEvent.getProject();
            return project != null && !DumbService.isDumb((Project)project);
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(false);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(true);
            }
        }).setPreferredSize(new Dimension(-1, 100)).createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)jPanel));
                if (project != null && !DumbService.isDumb((Project)project)) {
                    SSBasedInspectionOptions.this.performEditAction(project);
                }
                return true;
            }
        }.installOn(this.myTemplatesList);
        return jPanel;
    }

    void performMoveUpDown(boolean down) {
        int n2;
        int[] nArray = this.myTemplatesList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        int n3 = down ? 1 : -1;
        this.myTemplatesList.removeSelectionInterval(0, this.myConfigurations.size() - 1);
        int n4 = n2 = down ? nArray.length - 1 : 0;
        while (down ? n2 >= 0 : n2 < nArray.length) {
            int n5 = nArray[n2];
            Configuration configuration = this.myConfigurations.get(n5);
            this.myConfigurations.set(n5, this.myConfigurations.get(n5 + n3));
            this.myConfigurations.set(n5 + n3, configuration);
            this.myTemplatesList.addSelectionInterval(n5 + n3, n5 + n3);
            n2 -= n3;
        }
        n2 = down ? this.myTemplatesList.getMaxSelectionIndex() : this.myTemplatesList.getMinSelectionIndex();
        Rectangle rectangle = this.myTemplatesList.getCellBounds(n2, n2);
        if (rectangle != null) {
            this.myTemplatesList.scrollRectToVisible(rectangle);
        }
    }

    void performEditAction(Project project) {
        Configuration configuration;
        DialogWrapper dialogWrapper;
        long l2 = a ^ 0x2A27DFB7F6F8L;
        Configuration configuration2 = (Configuration)this.myTemplatesList.getSelectedValue();
        if (configuration2 == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project);
        if (Registry.is((String)"ssr.use.new.search.dialog")) {
            dialogWrapper = new StructuralSearchDialog(searchContext, !(configuration2 instanceof SearchConfiguration), true);
            dialogWrapper.loadConfiguration(configuration2);
            dialogWrapper.setUseLastConfiguration(true);
            if (!dialogWrapper.showAndGet()) {
                return;
            }
            configuration = dialogWrapper.getConfiguration();
        } else {
            dialogWrapper = configuration2 instanceof SearchConfiguration ? new SearchDialog(searchContext, false, false) : new ReplaceDialog(searchContext, false, false);
            dialogWrapper.setValuesFromConfig(configuration2);
            dialogWrapper.setUseLastConfiguration(true);
            if (!dialogWrapper.showAndGet()) {
                return;
            }
            configuration = dialogWrapper.getConfiguration();
        }
        int n2 = this.myConfigurations.indexOf(configuration2);
        this.myConfigurations.set(n2, configuration);
        SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration2, project);
        this.configurationsChanged(project);
    }

    private class AddTemplateAction
    extends AnAction {
        private final boolean a;
        final /* synthetic */ SSBasedInspectionOptions this$0;
        private static final long b = la.a(2265182498527222771L, 4305541753454238637L, MethodHandles.lookup().lookupClass()).a(35966337706098L);

        AddTemplateAction(SSBasedInspectionOptions sSBasedInspectionOptions, boolean replace) {
            long l2 = b ^ 0x76A3F7C51501L;
            this.this$0 = sSBasedInspectionOptions;
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.a = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = b ^ 0x344BE8A02524L;
            if (e10 == null) {
                AddTemplateAction.a(0);
            }
            SearchContext searchContext = new SearchContext(e10.getDataContext());
            if (Registry.is((String)"ssr.use.new.search.dialog")) {
                StructuralSearchDialog structuralSearchDialog = new StructuralSearchDialog(searchContext, this.a, true);
                if (!structuralSearchDialog.showAndGet()) {
                    return;
                }
                this.this$0.addTemplate(structuralSearchDialog.getConfiguration(), e10.getProject());
            } else {
                SearchDialog searchDialog;
                SearchDialog searchDialog2 = searchDialog = this.a ? new ReplaceDialog(searchContext, false, false) : new SearchDialog(searchContext, false, false);
                if (!searchDialog.showAndGet()) {
                    return;
                }
                this.this$0.addTemplate(searchDialog.getConfiguration(), e10.getProject());
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x651C1932BDB8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionOptions$AddTemplateAction", "actionPerformed"));
        }
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return SSBasedInspectionOptions.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            return index < SSBasedInspectionOptions.this.myConfigurations.size() ? SSBasedInspectionOptions.this.myConfigurations.get(index) : null;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(SSBasedInspectionOptions.this.myTemplatesList, -1, -1);
        }
    }
}

