/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import b.h.la;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.ui.LayeredIcon;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RPresentationConstants;

public class RClassPresentationUtil
implements RPresentationConstants {
    private static final long a = la.a(6824715865335689147L, 2203309547824064921L, MethodHandles.lookup().lookupClass()).a(30209320783465L);

    public static Icon getIcon() {
        return AllIcons.Nodes.Class;
    }

    public static Icon getIcon(@NotNull RClass rClass) {
        if (rClass == null) {
            RClassPresentationUtil.a(0);
        }
        if (rClass instanceof RObjectClass) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(AllIcons.Nodes.StaticMark, 1);
            layeredIcon.setIcon(AllIcons.Nodes.Class, 0);
            return layeredIcon;
        }
        return AllIcons.Nodes.Class;
    }

    public static Icon getIcon(@NotNull RClass rClass, int flags) {
        if (rClass == null) {
            RClassPresentationUtil.a(1);
        }
        if ((flags & 1) == 1) {
            return RContainerPresentationUtil.getIconWithModifiers((RContainer)rClass);
        }
        return RClassPresentationUtil.getIcon(rClass);
    }

    @NotNull
    public static ItemPresentation getPresentation(final @NotNull RClass rClass) {
        if (rClass == null) {
            RClassPresentationUtil.a(2);
        }
        final Icon icon = RClassPresentationUtil.getIcon(rClass, 1);
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                if (!rClass.isValid()) {
                    return null;
                }
                return RClassPresentationUtil.formatName(rClass, 1);
            }

            public String getLocationString() {
                return TextUtil.wrapInParens(RContainerPresentationUtil.getLocation((RPsiElement)rClass));
            }

            public Icon getIcon(boolean open) {
                return icon;
            }
        };
        if (itemPresentation == null) {
            RClassPresentationUtil.a(3);
        }
        return itemPresentation;
    }

    public static String formatName(@NotNull RClass rClass, int options) {
        if (rClass == null) {
            RClassPresentationUtil.a(4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ((options & 0x200) != 0) {
            stringBuilder.append(RContainerPresentationUtil.getHumanizedFQN(rClass.getFQN()));
        } else if ((options & 1) != 0) {
            stringBuilder.append(rClass.getName());
        }
        return stringBuilder.toString();
    }

    public static String getNameByQualifiedName(@NotNull String qualifiedClassName) {
        int n2;
        if (qualifiedClassName == null) {
            RClassPresentationUtil.a(5);
        }
        if ((n2 = qualifiedClassName.lastIndexOf(RubyTokenTypes.tCOLON2.toString())) < 0) {
            return qualifiedClassName;
        }
        return qualifiedClassName.substring(n2 + RubyTokenTypes.tCOLON2.toString().length());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x694509F7AD48L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/presentation/RClassPresentationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedClassName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/RClassPresentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameByQualifiedName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

