/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import b.h.la;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RunBundlerInstallQuickFix;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public abstract class RubySdkConfigurator {
    private static final Logger b;
    private static final ExtensionPointName<RubySdkConfigurator> a;
    private static final long d;

    public abstract boolean supports(@NotNull SdkAdditionalData var1);

    @NotNull
    public abstract RubyAbstractRunner buildRunner(@NotNull RubySdkAdditionalData var1, @Nullable Module var2);

    public void initSdk(@NotNull Sdk sdk) {
        RubyGemsEnvironment rubyGemsEnvironment;
        long l2 = d ^ 0x5E0DA38102F5L;
        if (sdk == null) {
            RubySdkConfigurator.a(0);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        String string = rubySdkAdditionalData.getInterpreterPath(sdk);
        String string2 = RubySdkType.getInstance().getVersionString(string);
        rubySdkAdditionalData.setNormalizedVersionString(string2);
        rubySdkAdditionalData.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromVersion(string2));
        if (SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                rubySdkAdditionalData.setPlatform(RubyVersionUtil.extractPlatformFromVersion(RubyVersionUtil.getFullVersion(rubySdkAdditionalData.getRunner(null), string, false)));
            }
            catch (ExecutionException executionException) {
                b.error((Throwable)executionException);
            }
        }
        if ((rubyGemsEnvironment = RubyGemsEnvironment.get(sdk)).isEmpty()) {
            b.error("Could not get RubyGems environment for " + sdk);
            return;
        }
        rubySdkAdditionalData.setGemsBinDirectory(Objects.requireNonNull(rubyGemsEnvironment.getExecutableDirectory()));
        rubySdkAdditionalData.setGemsRootUrls(Collections.emptyList());
    }

    @NotNull
    public LocalQuickFix createBundleInstallQuickFix(@NotNull Module module) {
        if (module == null) {
            RubySdkConfigurator.a(1);
        }
        RunBundlerInstallQuickFix runBundlerInstallQuickFix = new RunBundlerInstallQuickFix(module);
        if (runBundlerInstallQuickFix == null) {
            RubySdkConfigurator.a(2);
        }
        return runBundlerInstallQuickFix;
    }

    @NotNull
    public static RubySdkConfigurator from(SdkAdditionalData sdkAdditionalData) {
        long l2 = d ^ 0x17EFE076A536L;
        for (RubySdkConfigurator rubySdkConfigurator : a.getExtensionList()) {
            if (!rubySdkConfigurator.supports(sdkAdditionalData)) continue;
            RubySdkConfigurator rubySdkConfigurator2 = rubySdkConfigurator;
            if (rubySdkConfigurator2 == null) {
                RubySdkConfigurator.a(3);
            }
            return rubySdkConfigurator2;
        }
        throw new RuntimeException("Unable to find SdkConfigurator for " + sdkAdditionalData);
    }

    static {
        d = la.a(7347289280731945784L, -2672246923577674768L, MethodHandles.lookup().lookupClass()).a(264528702796223L);
        long l2 = d ^ 0x57FD9D182A10L;
        b = Logger.getInstance(RubySdkConfigurator.class);
        a = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.rubySdkConfigurator");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x2295A6C335A6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBundleInstallQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBundleInstallQuickFix";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

