/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyThread
extends RubyEntity {
    private static final Logger b;
    private final int g;
    private final int f;
    private RubyFrame[] e;
    private boolean c;
    private IRubyLineBreakpoint d;
    private static final long h;

    public RubyThread(RubyDebugTarget target, int id2, int pid) {
        super(target.getProxy());
        this.g = id2;
        this.f = pid;
    }

    public RubyFrame[] getFrames() throws RubyDebuggerException {
        if (this.e == null) {
            this.e = this.supportsFrameReading() ? this.getProxy().readFrames(this) : new RubyFrame[0];
        }
        return this.e;
    }

    public boolean supportsFrameReading() {
        return this.isSuspended() || this.getProxy().canReadFramesOfNonSuspendedThreads();
    }

    public RubyFrame getTopFrame() throws RubyDebuggerException {
        RubyFrame[] rubyFrameArray = this.getFrames();
        return rubyFrameArray.length == 0 ? null : rubyFrameArray[0];
    }

    public boolean isSuspended() {
        return this.c;
    }

    void resumeImpl() {
        this.c = false;
        this.e = null;
    }

    public void resume() {
        this.resumeImpl();
        this.getProxy().resume(this);
    }

    public void suspend(SuspensionPoint suspensionPoint) {
        if (this.d != null) {
            this.getProxy().removeBreakpoint(this.d);
            this.d = null;
        }
        this.e = null;
        this.c = true;
        RubyDebugEvent rubyDebugEvent = new RubyDebugEvent(this.getProxy(), this, suspensionPoint);
        this.getProxy().fireDebugEvent(rubyDebugEvent);
    }

    public void stepOver(boolean forceNewLine) throws RubyDebuggerException {
        long l2 = h ^ 0x31FC043CDCD8L;
        RubyFrame rubyFrame = this.getTopFrame();
        if (rubyFrame == null) {
            b.debug("stepOver failed, not top stack frame (thread is not suspended?)");
        } else {
            rubyFrame.stepOver(forceNewLine);
        }
    }

    public void stepOver() throws RubyDebuggerException {
        this.stepOver(false);
    }

    public void stepReturn() throws RubyDebuggerException {
        long l2 = h ^ 0xA3DDCC9C4B8L;
        RubyFrame rubyFrame = this.getTopFrame();
        if (rubyFrame == null) {
            b.debug("stepReturn failed, empty frame stack (thread is not suspended?)");
        } else {
            rubyFrame.stepReturn();
        }
    }

    public void runTo(final String path, final int line) throws RubyDebuggerException {
        this.d = new IRubyLineBreakpoint(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public String getFilePath() {
                return path;
            }

            @Override
            public int getLineNumber() {
                return line;
            }

            @Override
            public String getCondition() {
                return null;
            }
        };
        this.getProxy().addBreakpoint(this.d);
        this.resume();
    }

    public void jump(int line) {
        this.getProxy().jump(line);
    }

    public int getId() {
        return this.g;
    }

    public int getPid() {
        return this.f;
    }

    public void invalidateFrames() {
        long l2 = h ^ 0xA6035526F3EL;
        try {
            for (RubyFrame rubyFrame : this.getFrames()) {
                rubyFrame.clearCachedVariables();
            }
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            b.debug("getting frame list failed");
        }
    }

    static {
        h = la.a(-8091573766363502516L, -7821730762968839698L, MethodHandles.lookup().lookupClass()).a(10745943234604L);
        b = Logger.getInstance(RubyThread.class);
    }
}

