/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptorImpl;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxProxyDescriptor;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.joni.exception.JOniException;

public class TextMateSyntaxTable {
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxTable.class);
    private final Map<String, SyntaxNodeDescriptor> rulesMap = ContainerUtil.newHashMap();

    @NotNull
    public String loadSyntax(Plist plist) {
        SyntaxNodeDescriptor rootSyntaxNode = this.loadRealNode(plist, null);
        String string = rootSyntaxNode.getScopeName();
        if (string == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public SyntaxNodeDescriptor getSyntax(String scopeName) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rulesMap.get(scopeName);
        if (syntaxNodeDescriptor == null) {
            LOG.debug("Can't find syntax node for scope: '" + scopeName + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = SyntaxNodeDescriptor.EMPTY_NODE;
            if (syntaxNodeDescriptor2 == null) {
                TextMateSyntaxTable.$$$reportNull$$$0(1);
            }
            return syntaxNodeDescriptor2;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor3 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor3 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(2);
        }
        return syntaxNodeDescriptor3;
    }

    public void clear() {
        this.rulesMap.clear();
    }

    private SyntaxNodeDescriptor loadNestedSyntax(Plist plist, SyntaxNodeDescriptor parentNode) {
        return plist.contains("include") ? this.loadProxyNode(plist, parentNode) : this.loadRealNode(plist, parentNode);
    }

    @NotNull
    private SyntaxNodeDescriptor loadRealNode(Plist plist, SyntaxNodeDescriptor parentNode) {
        SyntaxNodeDescriptorImpl result = new SyntaxNodeDescriptorImpl(parentNode);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue pListValue = entry.getValue();
            if (pListValue == null) continue;
            String key = entry.getKey();
            if (ArrayUtil.contains((String)key, (String[])Constants.REGEX_KEY_NAMES)) {
                try {
                    String pattern = pListValue.getString();
                    if (pattern == null) continue;
                    result.setRegexAttribute(key, RegexFacade.regex(pattern));
                }
                catch (JOniException e) {
                    LOG.error("Cannot compile pattern '" + pListValue.getString() + "' for '" + key + "'", (Throwable)e);
                }
                continue;
            }
            if (ArrayUtil.contains((String)key, (String[])Constants.STRING_KEY_NAMES)) {
                result.setStringAttribute(key, pListValue.getString());
                continue;
            }
            if (ArrayUtil.contains((String)key, (String[])Constants.DICT_KEY_NAMES)) {
                result.setPlistAttribute(key, pListValue.getPlist());
                continue;
            }
            if ("repository".equalsIgnoreCase(key)) {
                this.loadRepository(result, pListValue);
                continue;
            }
            if (!"patterns".equalsIgnoreCase(key)) continue;
            this.loadPatterns(result, pListValue);
        }
        if (plist.contains("scopeName")) {
            String scopeName = plist.getPlistValue("scopeName", "default").getString();
            result.setScopeName(scopeName);
            this.rulesMap.put(scopeName, result);
        }
        SyntaxNodeDescriptorImpl syntaxNodeDescriptorImpl = result;
        if (syntaxNodeDescriptorImpl == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(3);
        }
        return syntaxNodeDescriptorImpl;
    }

    private SyntaxNodeDescriptor loadProxyNode(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor result) {
        if (plist == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(4);
        }
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(5);
        }
        SyntaxNodeDescriptor rootNode = TextMateSyntaxTable.findRootNode(result);
        return new SyntaxProxyDescriptor(plist, result, rootNode, this);
    }

    private void loadPatterns(MutableSyntaxNodeDescriptor result, PListValue pListValue) {
        for (PListValue value : pListValue.getArray()) {
            result.addChild(this.loadNestedSyntax(value.getPlist(), result));
        }
    }

    private void loadRepository(MutableSyntaxNodeDescriptor result, PListValue pListValue) {
        for (Map.Entry<String, PListValue> repoEntry : pListValue.getPlist().entries()) {
            PListValue repoEntryValue = repoEntry.getValue();
            if (repoEntryValue == null) continue;
            Plist plist = repoEntryValue.getPlist();
            result.appendRepository(repoEntry.getKey(), this.loadNestedSyntax(plist, result));
        }
    }

    @NotNull
    private static SyntaxNodeDescriptor findRootNode(@NotNull SyntaxNodeDescriptor result) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(6);
        }
        SyntaxNodeDescriptor rootNode = result;
        SyntaxNodeDescriptor parentNode = result;
        while (parentNode != null) {
            rootNode = parentNode;
            parentNode = rootNode.getParentNode();
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor = rootNode;
        if (syntaxNodeDescriptor == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(7);
        }
        return syntaxNodeDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSyntax";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntax";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRealNode";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadProxyNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

