/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.transform;

import gnu.xml.libxmlj.dom.GnomeDocument;
import gnu.xml.libxmlj.sax.GnomeXMLReader;
import gnu.xml.libxmlj.transform.ErrorListenerErrorHandler;
import gnu.xml.libxmlj.transform.URIResolverEntityResolver;
import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class GnomeTransformer
extends Transformer
implements Templates {
    private Map parameters;
    private Properties outputProperties;
    private URIResolver resolver;
    private ErrorListener errorListener;
    private Object stylesheet;

    private final native Object newStylesheet() throws TransformerConfigurationException;

    private final native Object newStylesheetFromStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7) throws TransformerConfigurationException;

    private final native Object newStylesheetFromDoc(GnomeDocument var1) throws TransformerConfigurationException;

    public synchronized void setParameter(String parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public synchronized Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public synchronized void clearParameters() {
        this.parameters.clear();
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setURIResolver(URIResolver resolver) {
        this.resolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = new Properties(outputProperties);
    }

    public void setOutputProperty(String name, String value) {
        this.outputProperties.setProperty(name, value);
    }

    public Properties getOutputProperties() {
        return new Properties(this.outputProperties);
    }

    public String getOutputProperty(String name) {
        return this.outputProperties.getProperty(name);
    }

    public Transformer newTransformer() {
        return new GnomeTransformer(this.stylesheet, this.resolver, this.errorListener, new HashMap(this.parameters), new Properties(this.outputProperties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, Result result) throws TransformerException {
        if (source instanceof StreamSource) {
            try {
                StreamSource ss = (StreamSource)source;
                NamedInputStream in = XMLJ.getInputStream(ss);
                String publicId = ss.getPublicId();
                String systemId = ss.getSystemId();
                String base = XMLJ.getBaseURI(systemId);
                byte[] detectBuffer = in.getDetectBuffer();
                if (detectBuffer == null) {
                    throw new TransformerException("No document element");
                }
                if (result instanceof StreamResult) {
                    OutputStream out = XMLJ.getOutputStream((StreamResult)result);
                    boolean bl = false;
                    if (this.resolver != null) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (this.errorListener != null) {
                        bl2 = true;
                    }
                    this.transformStreamToStream(in, detectBuffer, publicId, systemId, base, bl, bl2, out);
                    return;
                }
                if (result instanceof DOMResult) {
                    DOMResult dr = (DOMResult)result;
                    boolean bl = false;
                    if (this.resolver != null) {
                        bl = true;
                    }
                    boolean bl3 = false;
                    if (this.errorListener != null) {
                        bl3 = true;
                    }
                    GnomeDocument ret = this.transformStreamToDoc(in, detectBuffer, publicId, systemId, base, bl, bl3);
                    dr.setNode(ret);
                    dr.setSystemId(null);
                    return;
                }
                if (!(result instanceof SAXResult)) {
                    String msg = "Result type not supported (" + result + ')';
                    throw new TransformerConfigurationException(msg);
                }
                SAXResult sr = (SAXResult)result;
                boolean bl = false;
                if (this.resolver != null) {
                    bl = true;
                }
                boolean bl4 = false;
                if (this.errorListener != null) {
                    bl4 = true;
                }
                this.transformStreamToSAX(in, detectBuffer, publicId, systemId, base, bl, bl4, this.getSAXContext(sr));
                return;
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
        if (!(source instanceof DOMSource)) {
            String msg = "Source type not supported";
            throw new TransformerConfigurationException(msg);
        }
        DOMSource ds = (DOMSource)source;
        Node node2 = ds.getNode();
        if (!(node2 instanceof GnomeDocument)) {
            String msg = "Node is not a GnomeDocument (" + node2 + ')';
            throw new TransformerException(msg);
        }
        GnomeDocument doc = (GnomeDocument)node2;
        if (result instanceof StreamResult) {
            try {
                OutputStream out = XMLJ.getOutputStream((StreamResult)result);
                this.transformDocToStream(doc, out);
                return;
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
        if (result instanceof DOMResult) {
            DOMResult dr = (DOMResult)result;
            GnomeDocument ret = this.transformDocToDoc(doc);
            dr.setNode(ret);
            dr.setSystemId(null);
            return;
        }
        if (result instanceof SAXResult) {
            SAXResult sr = (SAXResult)result;
            this.transformDocToSAX(doc, this.getSAXContext(sr));
            return;
        }
        String msg = "Result type not supported";
        throw new TransformerConfigurationException(msg);
    }

    private final GnomeXMLReader getSAXContext(SAXResult result) {
        GnomeXMLReader ctx = new GnomeXMLReader();
        ctx.setContentHandler(result.getHandler());
        ctx.setLexicalHandler(result.getLexicalHandler());
        if (this.errorListener != null) {
            ErrorListenerErrorHandler errorHandler = new ErrorListenerErrorHandler(this.errorListener);
            ctx.setErrorHandler(errorHandler);
        }
        if (this.resolver != null) {
            URIResolverEntityResolver entityResolver = new URIResolverEntityResolver(this.resolver);
            ctx.setEntityResolver(entityResolver);
        }
        return ctx;
    }

    private final native void transformStreamToStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, OutputStream var8) throws TransformerException;

    private final native GnomeDocument transformStreamToDoc(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7) throws TransformerException;

    private final native void transformStreamToSAX(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, GnomeXMLReader var8) throws TransformerException;

    private final native void transformDocToStream(GnomeDocument var1, OutputStream var2) throws TransformerException;

    private final native GnomeDocument transformDocToDoc(GnomeDocument var1) throws TransformerException;

    private final native void transformDocToSAX(GnomeDocument var1, GnomeXMLReader var2) throws TransformerException;

    private final String[] getParameterArray() {
        String[] parameterArray = new String[this.parameters.size() * 2];
        int index = 0;
        Iterator it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            String parameterKey = (String)it.next();
            String parameterValue = (String)this.parameters.get(parameterKey);
            parameterArray[index * 2] = parameterKey;
            parameterArray[index * 2 + 1] = "'" + (parameterValue != null ? parameterValue : "") + '\'';
            ++index;
        }
        return parameterArray;
    }

    public void finalize() {
        if (this.stylesheet != null) {
            this.free();
            this.stylesheet = null;
        }
    }

    private final native void free();

    private final InputStream resolveEntity(String publicId, String systemId) throws TransformerException {
        if (this.resolver != null) {
            systemId = this.resolver.resolve(null, systemId).getSystemId();
        }
        if (systemId == null) {
            return null;
        }
        try {
            URL url = new URL(systemId);
            return XMLJ.getInputStream(url);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    private final void setDocumentLocator(Object ctx, Object loc) {
    }

    private final void warning(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
        this.errorListener.warning(new TransformerException(message, l));
    }

    private final void error(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
        this.errorListener.error(new TransformerException(message, l));
    }

    private final void fatalError(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
        this.errorListener.fatalError(new TransformerException(message, l));
    }

    GnomeTransformer(Source source, URIResolver resolver, ErrorListener errorListener) throws TransformerConfigurationException {
        this.resolver = resolver;
        this.errorListener = errorListener;
        this.parameters = new HashMap();
        this.outputProperties = new Properties();
        if (source == null) {
            this.stylesheet = this.newStylesheet();
        } else if (source instanceof StreamSource) {
            try {
                StreamSource ss = (StreamSource)source;
                NamedInputStream in = XMLJ.getInputStream(ss);
                String systemId = ss.getSystemId();
                String publicId = ss.getPublicId();
                String base = XMLJ.getBaseURI(systemId);
                byte[] detectBuffer = in.getDetectBuffer();
                if (detectBuffer == null) {
                    String msg = "No document element";
                    throw new TransformerConfigurationException(msg);
                }
                boolean bl = false;
                if (resolver != null) {
                    bl = true;
                }
                boolean bl2 = false;
                if (errorListener != null) {
                    bl2 = true;
                }
                this.stylesheet = this.newStylesheetFromStream(in, detectBuffer, publicId, systemId, base, bl, bl2);
            }
            catch (IOException e) {
                throw new TransformerConfigurationException(e);
            }
        } else if (source instanceof DOMSource) {
            DOMSource ds = (DOMSource)source;
            Node node2 = ds.getNode();
            if (!(node2 instanceof GnomeDocument)) {
                String msg = "Node is not a GnomeDocument";
                throw new TransformerConfigurationException(msg);
            }
            GnomeDocument doc = (GnomeDocument)node2;
            this.stylesheet = this.newStylesheetFromDoc(doc);
        } else {
            String msg = "Source type not supported (" + source + ')';
            throw new TransformerConfigurationException(msg);
        }
    }

    private GnomeTransformer(Object stylesheet, URIResolver resolver, ErrorListener errorListener, Map parameters, Properties outputProperties) {
        this.stylesheet = stylesheet;
        this.resolver = resolver;
        this.errorListener = errorListener;
        this.parameters = parameters;
        this.outputProperties = outputProperties;
    }
}

